/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.cert;

import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN1Lengths;
import com.rsa.asn1.ASN1Template;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.EncodedContainer;
import com.rsa.asn1.EndContainer;
import com.rsa.asn1.OIDContainer;
import com.rsa.asn1.OfContainer;
import com.rsa.asn1.SequenceContainer;
import com.rsa.certj.cert.AttributeValueAssertion;
import com.rsa.certj.cert.NameException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RDN
implements Cloneable,
Serializable {
    private Vector<AttributeValueAssertion> avaList = new Vector();
    protected int special;
    protected ASN1Template asn1Template;
    private static final String INVALID_INDEX = "Invalid Index.";
    private static final char[] SPECIAL_CHARACTERS = new char[]{',', '=', '+', '<', '>', '#', ';', '\"', '\\', ' '};

    public RDN(byte[] rdnBER, int offset, int special) throws NameException {
        if (rdnBER == null) {
            throw new NameException("Encoding is null.");
        }
        this.special = special;
        try {
            OfContainer setOfContainer = new OfContainer(special, 12544, (ASN1Container)new EncodedContainer(12288));
            ASN1Container[] rdnDef = new ASN1Container[]{setOfContainer};
            ASN1.berDecode((byte[])rdnBER, (int)offset, (ASN1Container[])rdnDef);
            int avaCount = setOfContainer.getContainerCount();
            for (int avaIndex = 0; avaIndex < avaCount; ++avaIndex) {
                ASN1Container encodedAVAcontainer = setOfContainer.containerAt(avaIndex);
                SequenceContainer avaContainer = new SequenceContainer(0);
                OIDContainer oidContainer = new OIDContainer(0x1000000);
                EncodedContainer encodedValueContainer = new EncodedContainer(65280);
                EndContainer endContainer = new EndContainer();
                ASN1Container[] avaDef = new ASN1Container[]{avaContainer, oidContainer, encodedValueContainer, endContainer};
                ASN1.berDecode((byte[])encodedAVAcontainer.data, (int)encodedAVAcontainer.dataOffset, (ASN1Container[])avaDef);
                int avaType = AttributeValueAssertion.findOID(oidContainer.data, oidContainer.dataOffset, oidContainer.dataLen);
                byte[] avaOID = null;
                if (avaType == -1 && oidContainer.data != null && oidContainer.dataLen > 0) {
                    avaOID = new byte[oidContainer.dataLen];
                    System.arraycopy(oidContainer.data, oidContainer.dataOffset, avaOID, 0, oidContainer.dataLen);
                }
                AttributeValueAssertion newAVA = new AttributeValueAssertion(avaType, avaOID, encodedValueContainer.data, encodedValueContainer.dataOffset, encodedValueContainer.dataLen);
                this.addNameAVA(newAVA);
            }
        }
        catch (ASN_Exception asnException) {
            throw new NameException("Cannot decode the BER of the RDN.");
        }
    }

    public RDN(String name, int encoding) throws NameException {
        ByteBuffer utf8Bytes = ByteBuffer.allocate(4);
        if (name == null) {
            throw new NameException("The string is null.");
        }
        if (encoding != 0 && encoding != 3072 && encoding != 4864 && encoding != 5120 && encoding != 5632 && encoding != 7168 && encoding != 7680) {
            throw new NameException("The ASN.1 string encoding type is invalid.");
        }
        StringTokenizer parser = new StringTokenizer(name, "\\+", true);
        int avaCount = parser.countTokens();
        ArrayList<String> avaString = new ArrayList<String>();
        StringBuilder avaBuffer = new StringBuilder();
        for (int j = 0; j < avaCount; ++j) {
            String avaToken = parser.nextToken();
            if (avaToken.equals("\\")) {
                StringBuilder nextToken = new StringBuilder(parser.nextToken());
                if (!RDN.checkSpecialChar(nextToken.charAt(0))) {
                    this.processUtf8Byte(nextToken, utf8Bytes);
                }
                avaBuffer.append(nextToken.toString());
                ++j;
                continue;
            }
            avaBuffer.append(this.finalizeUtf8Sequence(utf8Bytes));
            if (!avaToken.equals("+")) {
                avaBuffer.append(avaToken);
                continue;
            }
            avaString.add(avaBuffer.toString());
            avaBuffer = new StringBuilder();
        }
        avaBuffer.append(this.finalizeUtf8Sequence(utf8Bytes));
        if (avaBuffer.length() != 0) {
            avaString.add(avaBuffer.toString());
        }
        for (int avaIndex = 0; avaIndex < avaString.size(); ++avaIndex) {
            String avaName = (String)avaString.get(avaIndex);
            AttributeValueAssertion ava = new AttributeValueAssertion(avaName, encoding);
            this.addNameAVA(ava);
        }
    }

    private void processUtf8Byte(StringBuilder buffer, ByteBuffer utf8Bytes) throws NameException {
        utf8Bytes.put(RDN.getHexByte(buffer));
        if (buffer.length() > 0) {
            buffer.insert(0, this.finalizeUtf8Sequence(utf8Bytes));
            return;
        }
    }

    private String finalizeUtf8Sequence(ByteBuffer utf8Bytes) {
        if (utf8Bytes.position() == 0) {
            return "";
        }
        String unicodeString = null;
        try {
            unicodeString = new String(utf8Bytes.array(), 0, utf8Bytes.position(), "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        utf8Bytes.clear();
        return unicodeString;
    }

    private static boolean checkSpecialChar(char nextChar) {
        int i;
        for (i = 0; i < SPECIAL_CHARACTERS.length && nextChar != SPECIAL_CHARACTERS[i]; ++i) {
        }
        return i != SPECIAL_CHARACTERS.length;
    }

    private static byte getHexByte(StringBuilder buffer) throws NameException {
        if (buffer.length() < 2) {
            throw new NameException("Invalid UTF-8 escape sequence: Two characters per hex byte required");
        }
        try {
            int val = Integer.parseInt(buffer.substring(0, 2), 16);
            buffer.delete(0, 2);
            return (byte)(val & 0xFF);
        }
        catch (NumberFormatException e) {
            throw new NameException("Invalid UTF-8 escape sequence: Escaped hex byte invalid");
        }
    }

    public RDN() {
    }

    public Object clone() throws CloneNotSupportedException {
        RDN otherSelf = new RDN();
        for (int avaIndex = 0; avaIndex < this.avaList.size(); ++avaIndex) {
            AttributeValueAssertion ava = this.avaList.elementAt(avaIndex);
            otherSelf.avaList.addElement((AttributeValueAssertion)ava.clone());
        }
        otherSelf.special = this.special;
        if (this.asn1Template != null) {
            otherSelf.derEncodeInit();
        }
        return otherSelf;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean unicode) {
        StringBuffer buffer = new StringBuffer();
        if (this.avaList.isEmpty()) {
            return "";
        }
        for (int avaIndex = 0; avaIndex < this.avaList.size(); ++avaIndex) {
            AttributeValueAssertion ava = this.avaList.elementAt(avaIndex);
            String avaString = ava.toString(unicode);
            buffer.append(avaString);
            if (avaIndex >= this.avaList.size() - 1) continue;
            buffer.append("+");
        }
        return buffer.toString();
    }

    public int getAttributeCount() {
        return this.avaList.size();
    }

    public AttributeValueAssertion getAttributeByIndex(int attributeIndex) throws NameException {
        int avaCount = this.avaList.size();
        if (attributeIndex >= 0 && avaCount > attributeIndex) {
            return this.avaList.elementAt(attributeIndex);
        }
        throw new NameException(INVALID_INDEX);
    }

    public void removeAVA(int index) throws NameException {
        if (index >= this.avaList.size()) {
            throw new NameException(INVALID_INDEX);
        }
        this.avaList.removeElementAt(index);
    }

    public void setAVA(AttributeValueAssertion name, int index) throws NameException {
        if (name == null) {
            throw new NameException("Specified AVA is null.");
        }
        if (index >= this.avaList.size()) {
            throw new NameException(INVALID_INDEX);
        }
        this.avaList.setElementAt(name, index);
    }

    public AttributeValueAssertion getAttribute(int attributeType) {
        int avaCount = this.avaList.size();
        for (int index = 0; index < avaCount; ++index) {
            AttributeValueAssertion ava = this.avaList.elementAt(index);
            if (ava.getAttributeType() != attributeType) continue;
            return ava;
        }
        return null;
    }

    public static int getNextBEROffset(byte[] rdnBER, int offset) throws NameException {
        if (rdnBER == null) {
            throw new NameException("Specified array is null.");
        }
        if (rdnBER[offset] == 0 && rdnBER[offset + 1] == 0) {
            return offset + 2;
        }
        try {
            return offset + 1 + ASN1Lengths.determineLengthLen((byte[])rdnBER, (int)(offset + 1)) + ASN1Lengths.determineLength((byte[])rdnBER, (int)(offset + 1));
        }
        catch (ASN_Exception asnException) {
            throw new NameException("Unable to determine length of the BER");
        }
    }

    public int getDERLen(int special) {
        this.special = special;
        return this.derEncodeInit();
    }

    public int getDEREncoding(byte[] encoding, int offset, int special) throws NameException {
        if (encoding == null) {
            throw new NameException("Specified array is null.");
        }
        try {
            if (this.asn1Template == null || special != this.special) {
                this.getDERLen(special);
                if (this.asn1Template == null) {
                    throw new NameException("Unable to encode RDN.");
                }
            }
            return this.asn1Template.derEncode(encoding, offset);
        }
        catch (ASN_Exception asnException) {
            this.asn1Template = null;
            throw new NameException("Unable to encode RDN.");
        }
    }

    private int derEncodeInit() {
        try {
            int avaCount = this.avaList.size();
            OfContainer setOf = new OfContainer(this.special, true, 0, 12544, (ASN1Container)new EncodedContainer(12288));
            for (int avaIndex = 0; avaIndex < avaCount; ++avaIndex) {
                AttributeValueAssertion nextAVA = this.avaList.elementAt(avaIndex);
                int nextAVALen = nextAVA.getDERLen();
                byte[] avaEncoding = new byte[nextAVALen];
                nextAVALen = nextAVA.getDEREncoding(avaEncoding, 0);
                EncodedContainer nextEncoded = new EncodedContainer(12288, true, 0, avaEncoding, 0, nextAVALen);
                setOf.addContainer((ASN1Container)nextEncoded);
            }
            ASN1Container[] asn1Def = new ASN1Container[]{setOf};
            this.asn1Template = new ASN1Template(asn1Def);
            return this.asn1Template.derEncodeInit();
        }
        catch (ASN_Exception asnException) {
            return 0;
        }
        catch (NameException asnException) {
            return 0;
        }
    }

    public void addNameAVA(AttributeValueAssertion ava) {
        if (ava != null) {
            this.avaList.addElement(ava);
        }
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof RDN)) {
            return false;
        }
        RDN other = (RDN)obj;
        if (this.avaList.size() != other.avaList.size()) {
            return false;
        }
        for (int index = 0; index < this.avaList.size(); ++index) {
            boolean avaFound = this.findAVA(this.avaList.elementAt(index), other.avaList);
            if (avaFound) continue;
            return false;
        }
        return true;
    }

    private boolean findAVA(AttributeValueAssertion ava, Vector<AttributeValueAssertion> avaVector) {
        if (ava == null || avaVector == null) {
            return false;
        }
        for (int index = 0; index < avaVector.size(); ++index) {
            if (!ava.equals(avaVector.elementAt(index))) continue;
            return true;
        }
        return false;
    }

    public int hashCode() {
        int result = 0;
        for (int index = 0; index < this.avaList.size(); ++index) {
            result ^= this.avaList.elementAt(index).hashCode();
            result *= 33;
        }
        return result;
    }
}

