/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.cert;

import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN1Lengths;
import com.rsa.asn1.ASN1Template;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.ChoiceContainer;
import com.rsa.asn1.EncodedContainer;
import com.rsa.asn1.EndContainer;
import com.rsa.asn1.GenTimeContainer;
import com.rsa.asn1.IntegerContainer;
import com.rsa.asn1.OfContainer;
import com.rsa.asn1.SequenceContainer;
import com.rsa.asn1.UTCTimeContainer;
import com.rsa.certj.CertJUtils;
import com.rsa.certj.cert.CertificateException;
import com.rsa.certj.cert.X509V3Extensions;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Date;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RevokedCertificates
implements Cloneable,
Serializable {
    private final Vector<Object>[] certData = this.createVectorArray(3);
    protected static int special;
    private boolean timeFlag;
    private ASN1Template asn1Template;

    public RevokedCertificates() {
    }

    public RevokedCertificates(byte[] valueBER, int offset, int special) throws CertificateException {
        if (valueBER == null) {
            throw new CertificateException("Encoding is null.");
        }
        try {
            OfContainer seqOf = new OfContainer(special, 12288, (ASN1Container)new EncodedContainer(12288));
            ASN1Container[] certDef = new ASN1Container[]{seqOf};
            ASN1.berDecode((byte[])valueBER, (int)offset, (ASN1Container[])certDef);
            int certCount = seqOf.getContainerCount();
            for (int certIndex = 0; certIndex < certCount; ++certIndex) {
                ASN1Container encodedCertContainer = seqOf.containerAt(certIndex);
                SequenceContainer seq = new SequenceContainer(0);
                EndContainer anEnd = new EndContainer();
                EncodedContainer extensions = new EncodedContainer(77824);
                IntegerContainer serialNumber = new IntegerContainer(0);
                EncodedContainer timeContainer = new EncodedContainer(65280);
                ASN1Container[] asn1Def = new ASN1Container[]{seq, serialNumber, timeContainer, extensions, anEnd};
                ASN1.berDecode((byte[])encodedCertContainer.data, (int)encodedCertContainer.dataOffset, (ASN1Container[])asn1Def);
                byte[] serialNumberArray = new byte[serialNumber.dataLen];
                System.arraycopy(serialNumber.data, serialNumber.dataOffset, serialNumberArray, 0, serialNumber.dataLen);
                this.certData[0].addElement(serialNumberArray);
                if (extensions.dataPresent) {
                    this.certData[2].addElement(new X509V3Extensions(extensions.data, extensions.dataOffset, 0, 3));
                } else {
                    this.certData[2].addElement(null);
                }
                ChoiceContainer time = new ChoiceContainer(0);
                GenTimeContainer genTime = new GenTimeContainer(65536);
                UTCTimeContainer utcTime = new UTCTimeContainer(65536);
                ASN1Container[] timeDef = new ASN1Container[]{time, genTime, utcTime, anEnd};
                ASN1.berDecode((byte[])timeContainer.data, (int)timeContainer.dataOffset, (ASN1Container[])timeDef);
                if (genTime.dataPresent) {
                    this.certData[1].addElement(genTime.theTime);
                    continue;
                }
                if (!utcTime.dataPresent) continue;
                this.certData[1].addElement(utcTime.theTime);
            }
        }
        catch (Exception certException) {
            throw new CertificateException("Cannot decode the BER of Revoked Certificates.");
        }
    }

    private Vector<Object>[] createVectorArray(int size) {
        Vector[] vectorArray = new Vector[size];
        for (int index = 0; index < size; ++index) {
            vectorArray[index] = new Vector();
        }
        return vectorArray;
    }

    public void addRevokedCertificate(byte[] serialNumber, Date date, X509V3Extensions extensions) throws CertificateException {
        if (serialNumber == null || date == null) {
            throw new CertificateException("Values cannot be NULL.");
        }
        this.certData[0].addElement(serialNumber);
        this.certData[1].addElement(date);
        if (extensions != null && extensions.getExtensionsType() != 3) {
            throw new CertificateException("Wrong extensions type: should be CRLEntry extensions.");
        }
        this.certData[2].addElement(extensions);
    }

    public byte[] getSerialNumber(int index) throws CertificateException {
        if (index >= this.getCertificateCount()) {
            throw new CertificateException("Invalid index");
        }
        return (byte[])this.certData[0].elementAt(index);
    }

    public Date getRevocationDate(int index) throws CertificateException {
        if (index >= this.getCertificateCount()) {
            throw new CertificateException("Invalid index");
        }
        return (Date)this.certData[1].elementAt(index);
    }

    public X509V3Extensions getExtensions(int index) throws CertificateException {
        if (index >= this.getCertificateCount()) {
            throw new CertificateException("Invalid index");
        }
        return (X509V3Extensions)this.certData[2].elementAt(index);
    }

    public int getCertificateCount() {
        return this.certData[0].size();
    }

    public static int getNextBEROffset(byte[] valueBER, int offset) throws CertificateException {
        if (valueBER == null) {
            throw new CertificateException("Encoding is null.");
        }
        if (valueBER[offset] == 0 && valueBER[offset + 1] == 0) {
            return offset + 2;
        }
        try {
            return offset + 1 + ASN1Lengths.determineLengthLen((byte[])valueBER, (int)(offset + 1)) + ASN1Lengths.determineLength((byte[])valueBER, (int)(offset + 1));
        }
        catch (ASN_Exception asnException) {
            throw new CertificateException("Unable to determine length of the BER");
        }
    }

    public int getDERLen(int special) throws CertificateException {
        RevokedCertificates.special = special;
        this.getASN1Template(special);
        try {
            return this.asn1Template.derEncodeInit();
        }
        catch (ASN_Exception asnException) {
            throw new CertificateException((Exception)((Object)asnException));
        }
    }

    public int getDEREncoding(byte[] encoding, int offset, int special, boolean timeFlag) throws CertificateException {
        if (encoding == null) {
            throw new CertificateException("Specified array is null.");
        }
        try {
            this.timeFlag = timeFlag;
            if (this.asn1Template == null || special != RevokedCertificates.special) {
                this.getDERLen(special);
            }
            int returnValue = this.asn1Template.derEncode(encoding, offset);
            this.asn1Template = null;
            return returnValue;
        }
        catch (ASN_Exception asnException) {
            this.asn1Template = null;
            throw new CertificateException("Unable to encode Revoked Certificates.");
        }
    }

    private void getASN1Template(int special) throws CertificateException {
        if (this.asn1Template != null && special == RevokedCertificates.special) {
            return;
        }
        Vector<OfContainer> asn1Def = new Vector<OfContainer>();
        try {
            OfContainer sequenceOfContainer = new OfContainer(special, 12288, (ASN1Container)new EncodedContainer(12288));
            asn1Def.addElement(sequenceOfContainer);
            for (int index = 0; index < this.certData[0].size(); ++index) {
                EncodedContainer certContainer = this.encodeCert(index);
                sequenceOfContainer.addContainer((ASN1Container)certContainer);
            }
        }
        catch (ASN_Exception e) {
            throw new CertificateException("Can't encode RevokedCerts", (Exception)((Object)e));
        }
        Object[] asn1DefArray = new ASN1Container[asn1Def.size()];
        asn1Def.copyInto(asn1DefArray);
        this.asn1Template = new ASN1Template((ASN1Container[])asn1DefArray);
    }

    private EncodedContainer encodeCert(int index) throws CertificateException {
        EncodedContainer next;
        SequenceContainer seq = new SequenceContainer(0, true, 0);
        EndContainer end = new EndContainer();
        EncodedContainer exten = null;
        try {
            ASN1Template templ;
            if (this.certData[2].elementAt(index) != null) {
                int extDERLen = ((X509V3Extensions)this.certData[2].elementAt(index)).getDERLen(0);
                byte[] extDER = new byte[extDERLen];
                int offset = 0;
                int returnLen = ((X509V3Extensions)this.certData[2].elementAt(index)).getDEREncoding(extDER, offset, 0);
                exten = new EncodedContainer(77824, true, 0, extDER, offset, returnLen);
            }
            byte[] number = (byte[])this.certData[0].elementAt(index);
            IntegerContainer serialNumber = new IntegerContainer(0, true, 0, number, 0, number.length, true);
            Date time = (Date)this.certData[1].elementAt(index);
            if (this.timeFlag) {
                GenTimeContainer genTime = new GenTimeContainer(0, true, 0, time);
                if (exten != null) {
                    ASN1Container[] asn1Def0 = new ASN1Container[]{seq, serialNumber, genTime, exten, end};
                    templ = new ASN1Template(asn1Def0);
                } else {
                    ASN1Container[] asn1Def1 = new ASN1Container[]{seq, serialNumber, genTime, end};
                    templ = new ASN1Template(asn1Def1);
                }
            } else {
                UTCTimeContainer utcTime = new UTCTimeContainer(0, true, 0, time);
                if (exten != null) {
                    ASN1Container[] asn1Def2 = new ASN1Container[]{seq, serialNumber, utcTime, exten, end};
                    templ = new ASN1Template(asn1Def2);
                } else {
                    ASN1Container[] asn1Def3 = new ASN1Container[]{seq, serialNumber, utcTime, end};
                    templ = new ASN1Template(asn1Def3);
                }
            }
            templ.derEncodeInit();
            int encodingLen = templ.derEncodeInit();
            byte[] encoding = new byte[encodingLen];
            encodingLen = templ.derEncode(encoding, 0);
            next = new EncodedContainer(12288, true, 0, encoding, 0, encodingLen);
        }
        catch (ASN_Exception asnException) {
            throw new CertificateException(" Can't encode RevokedCertificates");
        }
        return next;
    }

    public boolean equals(Object obj) {
        int vectorIndex;
        if (obj == null || !(obj instanceof RevokedCertificates)) {
            return false;
        }
        RevokedCertificates other = (RevokedCertificates)obj;
        int thisVectorSize = this.certData[0].size();
        if (thisVectorSize != other.certData[0].size()) {
            return false;
        }
        for (vectorIndex = 0; vectorIndex < thisVectorSize; ++vectorIndex) {
            byte[] otherSerial;
            byte[] thisSerial = (byte[])this.certData[0].elementAt(vectorIndex);
            if (CertJUtils.byteArraysEqual(thisSerial, otherSerial = (byte[])other.certData[0].elementAt(vectorIndex))) continue;
            return false;
        }
        thisVectorSize = this.certData[1].size();
        if (thisVectorSize != other.certData[1].size()) {
            return false;
        }
        for (vectorIndex = 0; vectorIndex < thisVectorSize; ++vectorIndex) {
            Date otherDate;
            Date thisDate = (Date)this.certData[1].elementAt(vectorIndex);
            if (thisDate.equals(otherDate = (Date)other.certData[1].elementAt(vectorIndex))) continue;
            return false;
        }
        thisVectorSize = this.certData[2].size();
        if (thisVectorSize != other.certData[2].size()) {
            return false;
        }
        for (vectorIndex = 0; vectorIndex < thisVectorSize; ++vectorIndex) {
            X509V3Extensions otherExts;
            X509V3Extensions thisExts = (X509V3Extensions)this.certData[2].elementAt(vectorIndex);
            if (thisExts.equals(otherExts = (X509V3Extensions)other.certData[2].elementAt(vectorIndex))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int index;
        int hashcode = 0;
        for (index = 0; index < this.certData[0].size(); ++index) {
            byte[] serialNumber = (byte[])this.certData[0].elementAt(index);
            hashcode ^= Arrays.hashCode(serialNumber);
        }
        for (index = 0; index < this.certData[1].size(); ++index) {
            Date date = (Date)this.certData[1].elementAt(index);
            hashcode ^= date.hashCode();
        }
        for (index = 0; index < this.certData[2].size(); ++index) {
            X509V3Extensions extensions = (X509V3Extensions)this.certData[2].elementAt(index);
            hashcode ^= extensions.hashCode();
        }
        return hashcode;
    }

    public Object clone() throws CloneNotSupportedException {
        RevokedCertificates otherSelf = new RevokedCertificates();
        for (int index = 0; index < this.certData.length; ++index) {
            for (int certIndex = 0; certIndex < this.certData[index].size(); ++certIndex) {
                otherSelf.certData[index].addElement(this.certData[index].elementAt(certIndex));
            }
        }
        try {
            if (this.asn1Template != null) {
                otherSelf.getASN1Template(special);
            }
        }
        catch (CertificateException certException) {
            throw new CloneNotSupportedException("Cannot get ASN1 Template");
        }
        return otherSelf;
    }
}

