/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.cert;

import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN1Lengths;
import com.rsa.asn1.ASN1Template;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.EncodedContainer;
import com.rsa.asn1.OfContainer;
import com.rsa.certj.cert.AttributeException;
import com.rsa.certj.cert.attributes.X501Attribute;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Vector;

public class X501Attributes
implements Cloneable,
Serializable {
    private Vector<X501Attribute> theAttributes;
    protected int special;
    private ASN1Template asn1Template;

    public X501Attributes() {
    }

    public X501Attributes(byte[] attributesBER, int offset, int special) throws AttributeException {
        if (attributesBER == null) {
            throw new AttributeException("Encoding is null.");
        }
        this.setAttributesBER(attributesBER, offset, special);
    }

    public static int getNextBEROffset(byte[] attributesBER, int offset) throws AttributeException {
        if (attributesBER == null) {
            throw new AttributeException("Encoding is null.");
        }
        try {
            return offset + 1 + ASN1Lengths.determineLengthLen((byte[])attributesBER, (int)(offset + 1)) + ASN1Lengths.determineLength((byte[])attributesBER, (int)(offset + 1));
        }
        catch (ASN_Exception asnException) {
            throw new AttributeException("Could not read the BER encoding.");
        }
    }

    private void setAttributesBER(byte[] attributesBER, int offset, int special) throws AttributeException {
        if (attributesBER == null) {
            throw new AttributeException("Encoding is null.");
        }
        this.reset();
        try {
            OfContainer setOf = new OfContainer(special, 12544, (ASN1Container)new EncodedContainer(12288));
            ASN1Container[] asn1Def = new ASN1Container[]{setOf};
            ASN1.berDecode((byte[])attributesBER, (int)offset, (ASN1Container[])asn1Def);
            int attributeCount = setOf.getContainerCount();
            if (attributeCount > 0) {
                this.theAttributes = new Vector();
            }
            for (int index = 0; index < attributeCount; ++index) {
                ASN1Container nextContainer = setOf.containerAt(index);
                X501Attribute nextAttribute = X501Attribute.getInstance(nextContainer.data, nextContainer.dataOffset, 0);
                this.theAttributes.addElement(nextAttribute);
            }
        }
        catch (ASN_Exception asnException) {
            throw new AttributeException("Could not read the BER of the Attributes.");
        }
    }

    public int getDERLen(int special) {
        return this.encodeInit(special);
    }

    private int encodeInit(int special) {
        this.special = special;
        try {
            OfContainer setOf = new OfContainer(special, true, 0, 12544, (ASN1Container)new EncodedContainer(12288));
            int attributeCount = 0;
            if (this.theAttributes != null) {
                attributeCount = this.theAttributes.size();
            }
            if (attributeCount == 0) {
                return 2;
            }
            for (int index = 0; index < attributeCount; ++index) {
                X501Attribute nextAttribute = this.theAttributes.elementAt(index);
                int nextLen = nextAttribute.getDERLen(0);
                byte[] encoding = new byte[nextLen];
                nextLen = nextAttribute.getDEREncoding(encoding, 0, 0);
                EncodedContainer nextContainer = new EncodedContainer(12288, true, 0, encoding, 0, nextLen);
                setOf.addContainer((ASN1Container)nextContainer);
            }
            ASN1Container[] asn1Def = new ASN1Container[]{setOf};
            this.asn1Template = new ASN1Template(asn1Def);
            return this.asn1Template.derEncodeInit();
        }
        catch (ASN_Exception asnException) {
            this.asn1Template = null;
            return 0;
        }
        catch (AttributeException attException) {
            this.asn1Template = null;
            return 0;
        }
    }

    public int getDEREncoding(byte[] encoding, int offset, int special) throws AttributeException {
        if (encoding == null) {
            throw new AttributeException("Specified array is null.");
        }
        if ((this.asn1Template == null || special != this.special) && this.encodeInit(special) == 0) {
            throw new AttributeException("Cannot compute the DER of the Attributes");
        }
        if (this.theAttributes == null) {
            encoding[offset] = -96;
            encoding[offset + 1] = 0;
            return 2;
        }
        try {
            return this.asn1Template.derEncode(encoding, offset);
        }
        catch (ASN_Exception asnException) {
            this.asn1Template = null;
            return 0;
        }
    }

    public int addAttribute(X501Attribute attribute) {
        if (attribute == null) {
            return -1;
        }
        this.reset();
        if (this.theAttributes == null) {
            this.theAttributes = new Vector();
            this.theAttributes.addElement(attribute);
            return 0;
        }
        X501Attribute already = this.getAttributeByOID(attribute.getOID());
        if (already != null) {
            this.theAttributes.removeElement(already);
        }
        this.theAttributes.addElement(attribute);
        return this.theAttributes.indexOf(attribute);
    }

    public int getAttributeCount() {
        if (this.theAttributes != null) {
            return this.theAttributes.size();
        }
        return 0;
    }

    public X501Attribute getAttributeByIndex(int index) {
        try {
            if (this.theAttributes != null) {
                return this.theAttributes.elementAt(index);
            }
            return null;
        }
        catch (ArrayIndexOutOfBoundsException arrayException) {
            return null;
        }
    }

    public X501Attribute getAttributeByType(int attributeType) {
        if (this.theAttributes == null) {
            return null;
        }
        int count = this.getAttributeCount();
        for (int index = 0; index < count; ++index) {
            X501Attribute nextAttribute = this.getAttributeByIndex(index);
            if (nextAttribute.getAttributeType() != attributeType) continue;
            return nextAttribute;
        }
        return null;
    }

    public X501Attribute getAttributeByOID(byte[] oid) {
        if (this.theAttributes == null) {
            return null;
        }
        int count = this.getAttributeCount();
        for (int index = 0; index < count; ++index) {
            X501Attribute nextAttribute = this.getAttributeByIndex(index);
            if (!nextAttribute.compareOID(oid)) continue;
            return nextAttribute;
        }
        return null;
    }

    public Object clone() throws CloneNotSupportedException {
        X501Attributes otherSelf = new X501Attributes();
        if (this.theAttributes != null) {
            otherSelf.theAttributes = new Vector();
            int count = this.theAttributes.size();
            for (int index = 0; index < count; ++index) {
                X501Attribute nextAttribute = (X501Attribute)this.getAttributeByIndex(index).clone();
                otherSelf.addAttribute(nextAttribute);
            }
        }
        if (this.asn1Template != null) {
            otherSelf.getDERLen(this.special);
        }
        return otherSelf;
    }

    public boolean equals(Object obj) {
        int otherVectorLen;
        if (obj == null || !(obj instanceof X501Attributes)) {
            return false;
        }
        X501Attributes other = (X501Attributes)obj;
        int thisVectorLen = this.theAttributes.size();
        if (thisVectorLen != (otherVectorLen = other.theAttributes.size())) {
            return false;
        }
        try {
            int thisLen = this.getDERLen(0);
            int otherLen = other.getDERLen(0);
            if (thisLen != otherLen) {
                return false;
            }
            byte[] thisEncoding = new byte[thisLen];
            byte[] otherEncoding = new byte[otherLen];
            thisLen = this.getDEREncoding(thisEncoding, 0, 0);
            if (thisLen != (otherLen = other.getDEREncoding(otherEncoding, 0, 0))) {
                return false;
            }
            for (int index = 0; index < thisLen; ++index) {
                if (thisEncoding[index] == otherEncoding[index]) continue;
                return false;
            }
        }
        catch (AttributeException certException) {
            return false;
        }
        return true;
    }

    public int hashCode() {
        int derLen = this.getDERLen(0);
        byte[] derEncoding = new byte[derLen];
        try {
            derLen = this.getDEREncoding(derEncoding, 0, 0);
        }
        catch (AttributeException certException) {
            return 0;
        }
        return Arrays.hashCode(derEncoding);
    }

    protected void reset() {
        this.asn1Template = null;
    }
}

