/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.cert;

import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN1Lengths;
import com.rsa.asn1.ASN1Template;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.AlgorithmID;
import com.rsa.asn1.BitStringContainer;
import com.rsa.asn1.ChoiceContainer;
import com.rsa.asn1.EncodedContainer;
import com.rsa.asn1.EndContainer;
import com.rsa.asn1.GenTimeContainer;
import com.rsa.asn1.IntegerContainer;
import com.rsa.asn1.SequenceContainer;
import com.rsa.asn1.UTCTimeContainer;
import com.rsa.certj.CertJ;
import com.rsa.certj.CertJUtils;
import com.rsa.certj.cert.CRL;
import com.rsa.certj.cert.CertificateException;
import com.rsa.certj.cert.NameException;
import com.rsa.certj.cert.RevokedCertificates;
import com.rsa.certj.cert.X500Name;
import com.rsa.certj.cert.X509V3Extensions;
import com.rsa.certj.cert.extensions.X509V3Extension;
import com.rsa.jsafe.JSAFE_PrivateKey;
import com.rsa.jsafe.JSAFE_PublicKey;
import java.io.NotSerializableException;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Date;
import java.util.Vector;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class X509CRL
extends CRL {
    private static final long serialVersionUID = -5083647906625180012L;
    public static final int X509_VERSION_1 = 0;
    public static final int X509_VERSION_2 = 1;
    private byte[] innerDER;
    private int innerDERLen;
    private int theVersion = 0;
    private X500Name issuerName;
    private RevokedCertificates revokedCerts;
    private boolean timeType;
    private Date thisUpdate;
    private Date nextUpdate;
    private X509V3Extensions crlExtensions;
    private int special = 0;
    private ASN1Template asn1Template;
    private int innerSpecial = 0;
    private ASN1Template asn1TemplateInner;
    private final Lock outerDERLock = new ReentrantLock();
    private final Lock innerDERLock = new ReentrantLock();

    public X509CRL() {
    }

    public X509CRL(CertJ certJContext) {
        this.setCertJ(certJContext);
    }

    public X509CRL(byte[] x509CrlBER, int offset, int special) throws CertificateException {
        this(x509CrlBER, offset, special, null);
    }

    public X509CRL(byte[] x509CrlBER, int offset, int special, CertJ certJContext) throws CertificateException {
        if (x509CrlBER == null) {
            throw new CertificateException("Encoding is null.");
        }
        this.setCRLBER(x509CrlBER, offset, special);
        this.setCertJ(certJContext);
    }

    private void checkSpecial(int special) throws CertificateException {
        if (special != 0 && special != 0x400000 && special != 0x600000 && special != 0xC00000 && special != 0xE00000 && special != 65536 && special != 131072 && special != 0x800000 && special != 0xA00000) {
            throw new CertificateException("Could not encode: Invalid 'special'");
        }
    }

    public static int getNextBEROffset(byte[] x509CrlBER, int offset) throws CertificateException {
        if (x509CrlBER == null) {
            throw new CertificateException("Encoding is null.");
        }
        try {
            return offset + 1 + ASN1Lengths.determineLengthLen((byte[])x509CrlBER, (int)(offset + 1)) + ASN1Lengths.determineLength((byte[])x509CrlBER, (int)(offset + 1));
        }
        catch (ASN_Exception asnException) {
            throw new CertificateException("Could not read the BER encoding.");
        }
    }

    private void setCRLBER(byte[] x509CrlBER, int offset, int special) throws CertificateException {
        if (x509CrlBER == null) {
            throw new CertificateException("Encoding is null.");
        }
        this.clearComponents();
        ASN1Container[] asn1Def = X509CRL.decodeCRL(x509CrlBER, offset, special);
        this.setInnerDER(asn1Def[1].data, asn1Def[1].dataOffset, special);
        this.signature = new byte[asn1Def[3].dataLen];
        System.arraycopy(asn1Def[3].data, asn1Def[3].dataOffset, this.signature, 0, asn1Def[3].dataLen);
        this.setSignatureAlgorithm(asn1Def[2].data, asn1Def[2].dataOffset, asn1Def[2].dataLen);
    }

    protected static ASN1Container[] decodeCRL(byte[] crlBER, int offset, int special) throws CertificateException {
        if (crlBER == null) {
            throw new CertificateException("Encoding is null.");
        }
        SequenceContainer aSeq = new SequenceContainer(special);
        EndContainer anEnd = new EndContainer();
        EncodedContainer info = new EncodedContainer(12288);
        EncodedContainer algID = new EncodedContainer(12288);
        EncodedContainer sig = new EncodedContainer(768);
        ASN1Container[] asn1Def = new ASN1Container[]{aSeq, info, algID, sig, anEnd};
        try {
            ASN1.berDecode((byte[])crlBER, (int)offset, (ASN1Container[])asn1Def);
        }
        catch (ASN_Exception asnException) {
            throw new CertificateException("Could not BER decode the CRL.");
        }
        return asn1Def;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getDERLen(int special) {
        this.outerDERLock.lock();
        try {
            this.outerDERSetSpecial(special);
            int n = this.outerDEREncodeInit();
            return n;
        }
        catch (CertificateException e) {
            int n = 0;
            return n;
        }
        finally {
            this.outerDERLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getDEREncoding(byte[] encoding, int offset, int special) throws CertificateException {
        if (encoding == null) {
            throw new CertificateException("Specified array is null.");
        }
        this.outerDERLock.lock();
        try {
            int totalLen = 0;
            try {
                int len;
                this.outerDERSetSpecial(special);
                if (this.asn1Template == null && (len = this.outerDEREncodeInit()) == 0) {
                    throw new CertificateException("Could not encode: Possibly some of the required fields of this CRL object are not set.");
                }
                this.asn1Template = null;
            }
            catch (ASN_Exception asnException) {
                this.asn1Template = null;
                throw new CertificateException("Could not encode: ", (Exception)((Object)asnException));
            }
            int infoLen = this.getInnerDER(encoding, offset + (totalLen += this.asn1Template.derEncode(encoding, offset)));
            if (infoLen == 0) {
                throw new CertificateException("Could not encode, missing data.");
            }
            System.arraycopy(this.signatureAlgorithmBER, 0, encoding, offset + (totalLen += infoLen), this.signatureAlgorithmBER.length);
            System.arraycopy(this.signature, 0, encoding, offset + (totalLen += this.signatureAlgorithmBER.length), this.signature.length);
            int n = totalLen + this.signature.length;
            return n;
        }
        finally {
            this.outerDERLock.unlock();
        }
    }

    private int outerDEREncodeInit() {
        if (this.getInnerDERLen() == 0) {
            return 0;
        }
        if (this.signatureAlgorithmBER == null || this.signature == null) {
            return 0;
        }
        try {
            SequenceContainer aSeq = new SequenceContainer(this.special, true, 0);
            EndContainer anEnd = new EndContainer();
            EncodedContainer info = new EncodedContainer(12288, true, 0, null, 0, this.innerDERLen);
            EncodedContainer algID = new EncodedContainer(12288, true, 0, null, 0, this.signatureAlgorithmBER.length);
            EncodedContainer sig = new EncodedContainer(768, true, 0, null, 0, this.signature.length);
            ASN1Container[] asn1Def = new ASN1Container[]{aSeq, info, algID, sig, anEnd};
            this.asn1Template = new ASN1Template(asn1Def);
            return this.asn1Template.derEncodeInit();
        }
        catch (ASN_Exception asnException) {
            return 0;
        }
    }

    private void outerDERSetSpecial(int special) throws CertificateException {
        if (special != this.special) {
            this.checkSpecial(special);
            this.clearTemplate();
            this.special = special;
        }
    }

    private void outerDERClear() {
        this.outerDERLock.lock();
        this.asn1Template = null;
        this.special = 0;
        this.outerDERLock.unlock();
    }

    protected void setVersionNumber(int versionInt) throws CertificateException {
        if (versionInt != 1) {
            throw new CertificateException("Invalid X.509 CRL version.");
        }
        this.theVersion = versionInt;
    }

    private void setSignatureAlgorithm(byte[] algID, int offset, int len) throws CertificateException {
        block6: {
            if (algID == null || len == 0) {
                throw new CertificateException("Unknown or invalid signature algorithm.");
            }
            if (this.signatureAlgorithmBER == null) {
                this.signatureAlgorithmBER = new byte[len];
                System.arraycopy(algID, offset, this.signatureAlgorithmBER, 0, len);
                try {
                    String trans = AlgorithmID.berDecodeAlgID((byte[])algID, (int)offset, (int)1, null);
                    if (trans == null) {
                        throw new CertificateException("Unknown or invalid signature algorithm.");
                    }
                    break block6;
                }
                catch (ASN_Exception asnException) {
                    throw new CertificateException("Cannot decode signature algorithm.");
                }
            }
            if (!CertJUtils.byteArraysEqual(algID, offset, len, this.signatureAlgorithmBER)) {
                throw new CertificateException("Signature algorithms do not match.");
            }
        }
    }

    public void setInnerDER(byte[] x509InnerDER, int offset) throws CertificateException {
        this.setInnerDER(x509InnerDER, offset, 0);
    }

    private void setInnerDER(byte[] x509InnerDER, int offset, int special) throws CertificateException {
        if (x509InnerDER == null) {
            throw new CertificateException("Encoding is null.");
        }
        this.clearSignature();
        this.clearTemplate();
        this.innerSpecial = special;
        SequenceContainer aSeq = new SequenceContainer(this.innerSpecial);
        EndContainer anEnd = new EndContainer();
        IntegerContainer vers = new IntegerContainer(65536);
        EncodedContainer algID = new EncodedContainer(12288);
        EncodedContainer issuer = new EncodedContainer(12288);
        ChoiceContainer thisUpdateCont = new ChoiceContainer(0);
        UTCTimeContainer utc1 = new UTCTimeContainer(0);
        GenTimeContainer gen1 = new GenTimeContainer(0);
        ChoiceContainer nextUpdateCont = new ChoiceContainer(65536);
        UTCTimeContainer utc2 = new UTCTimeContainer(0);
        GenTimeContainer gen2 = new GenTimeContainer(0);
        EncodedContainer revokedCertsCont = new EncodedContainer(77824);
        EncodedContainer exten = new EncodedContainer(10563584);
        ASN1Container[] asn1Def = new ASN1Container[]{aSeq, vers, algID, issuer, thisUpdateCont, utc1, gen1, anEnd, nextUpdateCont, utc2, gen2, anEnd, revokedCertsCont, exten, anEnd};
        try {
            ASN1.berDecode((byte[])x509InnerDER, (int)offset, (ASN1Container[])asn1Def);
        }
        catch (ASN_Exception asnException) {
            throw new CertificateException("Could not BER decode the CRL info.");
        }
        if (vers.dataPresent) {
            try {
                this.setVersionNumber(vers.getValueAsInt());
            }
            catch (ASN_Exception asnException) {
                throw new CertificateException("Invalid version number: ", (Exception)((Object)asnException));
            }
        }
        this.setSignatureAlgorithm(algID.data, algID.dataOffset, algID.dataLen);
        try {
            this.setIssuerName(new X500Name(issuer.data, issuer.dataOffset, 0));
        }
        catch (NameException nameException) {
            throw new CertificateException("Invalid issuer name: ", nameException);
        }
        this.thisUpdate = utc1.dataPresent ? utc1.theTime : gen1.theTime;
        if (utc2.dataPresent) {
            this.nextUpdate = utc2.theTime;
        } else if (gen2.dataPresent) {
            this.nextUpdate = gen2.theTime;
        }
        if (revokedCertsCont.dataPresent) {
            this.revokedCerts = new RevokedCertificates(revokedCertsCont.data, revokedCertsCont.dataOffset, 0);
        }
        if (exten.dataPresent) {
            X509V3Extensions extensions = new X509V3Extensions(exten.data, exten.dataOffset, 0xA00000, 2);
            this.setExtensions(extensions);
        }
        this.innerDERLen = X509CRL.getNextBEROffset(x509InnerDER, offset) - offset;
        this.innerDER = new byte[this.innerDERLen];
        System.arraycopy(x509InnerDER, offset, this.innerDER, 0, this.innerDERLen);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getInnerDERLen() {
        this.innerDERLock.lock();
        try {
            if (this.innerDERLen != 0) {
                if (this.innerSpecial == this.special) {
                    int n = this.innerDERLen;
                    return n;
                }
                this.innerSpecial = this.special;
                this.innerDERClear();
            }
            int n = this.innerDEREncodeInit();
            return n;
        }
        finally {
            this.innerDERLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getInnerDER(byte[] encoding, int offset) throws CertificateException {
        if (encoding == null) {
            throw new CertificateException("Passed array is null");
        }
        this.innerDERLock.lock();
        try {
            this.innerDEREncode();
            System.arraycopy(this.innerDER, 0, encoding, offset, this.innerDERLen);
            int n = this.innerDERLen;
            return n;
        }
        finally {
            this.innerDERLock.unlock();
        }
    }

    private int innerDEREncodeInit() {
        EncodedContainer algID;
        this.innerDERClear();
        if (this.thisUpdate == null || this.signatureAlgorithmBER == null) {
            return 0;
        }
        if (this.issuerName == null && !this.checkExtensions(18)) {
            return 0;
        }
        SequenceContainer aSeq = new SequenceContainer(this.innerSpecial, true, 0);
        EndContainer anEnd = new EndContainer();
        boolean dataPresent = true;
        if (this.theVersion == 0) {
            dataPresent = false;
        }
        IntegerContainer vers = new IntegerContainer(65536, dataPresent, 0, this.theVersion);
        try {
            algID = new EncodedContainer(12288, true, 0, this.signatureAlgorithmBER, 0, this.signatureAlgorithmBER.length);
        }
        catch (ASN_Exception e) {
            return 0;
        }
        Object thisUpdateCont = this.timeType ? new GenTimeContainer(0, true, 0, this.thisUpdate) : new UTCTimeContainer(0, true, 0, this.thisUpdate);
        dataPresent = false;
        if (this.nextUpdate != null) {
            dataPresent = true;
        }
        Object nextUpdateCont = this.timeType ? new GenTimeContainer(65536, dataPresent, 0, this.nextUpdate) : new UTCTimeContainer(65536, dataPresent, 0, this.nextUpdate);
        dataPresent = false;
        int dataLen = 0;
        try {
            if (this.revokedCerts != null) {
                dataLen = this.revokedCerts.getDERLen(65536);
                dataPresent = true;
            }
        }
        catch (CertificateException certException) {
            return 0;
        }
        try {
            byte[] issuerEncoding;
            EncodedContainer revCerts = new EncodedContainer(77824, dataPresent, 0, null, 0, dataLen);
            try {
                if (this.issuerName != null) {
                    dataLen = this.issuerName.getDERLen(0);
                    issuerEncoding = new byte[dataLen];
                    this.issuerName.getDEREncoding(issuerEncoding, 0, 0);
                } else {
                    dataLen = 2;
                    issuerEncoding = new byte[dataLen];
                    issuerEncoding[0] = 48;
                    issuerEncoding[1] = 0;
                }
            }
            catch (NameException nameException) {
                return 0;
            }
            EncodedContainer issuer = new EncodedContainer(12288, true, 0, issuerEncoding, 0, dataLen);
            dataPresent = false;
            dataLen = 0;
            if (this.theVersion == 1 && this.crlExtensions != null && (dataLen = this.crlExtensions.getDERLen(0xA10000)) != 0) {
                dataPresent = true;
            }
            EncodedContainer exten = new EncodedContainer(10563584, dataPresent, 0, null, 0, dataLen);
            ASN1Container[] asn1Def = new ASN1Container[]{aSeq, vers, algID, issuer, thisUpdateCont, nextUpdateCont, revCerts, exten, anEnd};
            this.asn1TemplateInner = new ASN1Template(asn1Def);
            this.innerDERLen = this.asn1TemplateInner.derEncodeInit();
            return this.innerDERLen;
        }
        catch (ASN_Exception asnException) {
            return 0;
        }
    }

    private void innerDEREncode() throws CertificateException {
        if (this.innerDER == null) {
            int totalLen = 0;
            try {
                int dataLen = this.getInnerDERLen();
                if (dataLen == 0) {
                    throw new CertificateException("Cannot encode innerDER, information missing.");
                }
                this.innerDER = new byte[dataLen];
                totalLen += this.asn1TemplateInner.derEncode(this.innerDER, 0);
                this.asn1TemplateInner = null;
            }
            catch (ASN_Exception asnException) {
                this.asn1TemplateInner = null;
                throw new CertificateException("Could not encode: ", (Exception)((Object)asnException));
            }
            if (this.revokedCerts != null) {
                totalLen += this.revokedCerts.getDEREncoding(this.innerDER, totalLen, 65536, this.timeType);
            }
            if (this.theVersion == 1 && this.crlExtensions != null) {
                int n = totalLen + this.crlExtensions.getDEREncoding(this.innerDER, totalLen, 0xA10000);
            }
        }
    }

    private void innerDERClear() {
        this.innerDERLock.lock();
        this.asn1TemplateInner = null;
        this.innerDER = null;
        this.innerDERLen = 0;
        this.innerSpecial = 0;
        this.innerDERLock.unlock();
    }

    public byte[] getSignature() throws CertificateException {
        if (this.signature == null) {
            throw new CertificateException("Object not signed.");
        }
        BitStringContainer sig = new BitStringContainer(0);
        ASN1Container[] asn1Def = new ASN1Container[]{sig};
        try {
            ASN1.berDecode((byte[])this.signature, (int)0, (ASN1Container[])asn1Def);
        }
        catch (ASN_Exception asnException) {
            throw new CertificateException("Cannot extract the signature.");
        }
        byte[] returnValue = new byte[sig.dataLen];
        System.arraycopy(sig.data, sig.dataOffset, returnValue, 0, sig.dataLen);
        return returnValue;
    }

    public void setVersion(int version) throws CertificateException {
        this.clearSignature();
        this.clearTemplate();
        this.theVersion = version;
        if (version == 0 || version == 1) {
            return;
        }
        this.theVersion = 0;
        throw new CertificateException("Invalid CRL version: " + version);
    }

    public int getVersion() {
        return this.theVersion;
    }

    public void setIssuerName(X500Name issuerName) throws CertificateException {
        this.clearSignature();
        this.clearTemplate();
        if (issuerName == null) {
            if (!this.checkExtensions(18)) {
                throw new CertificateException("Cannot set the CRL with null issuerName.");
            }
        } else {
            try {
                this.issuerName = (X500Name)issuerName.clone();
            }
            catch (CloneNotSupportedException cloneException) {
                throw new CertificateException("Cannot set the CRL with the given issuerName.");
            }
        }
    }

    public X500Name getIssuerName() {
        if (this.issuerName == null) {
            return null;
        }
        try {
            return (X500Name)this.issuerName.clone();
        }
        catch (CloneNotSupportedException cloneException) {
            return null;
        }
    }

    public void setNextUpdate(Date update) {
        this.clearSignature();
        this.clearTemplate();
        if (update != null) {
            this.nextUpdate = new Date(update.getTime());
        }
    }

    public Date getNextUpdate() {
        if (this.nextUpdate == null) {
            return null;
        }
        return new Date(this.nextUpdate.getTime());
    }

    public void setThisUpdate(Date update) {
        this.clearSignature();
        this.clearTemplate();
        if (update != null) {
            this.thisUpdate = new Date(update.getTime());
        }
    }

    public Date getThisUpdate() {
        if (this.thisUpdate == null) {
            return null;
        }
        return new Date(this.thisUpdate.getTime());
    }

    public void setRevokedCertificates(RevokedCertificates revokedCerts) throws CertificateException {
        this.clearSignature();
        this.clearTemplate();
        if (revokedCerts != null) {
            try {
                this.revokedCerts = (RevokedCertificates)revokedCerts.clone();
            }
            catch (CloneNotSupportedException cloneException) {
                throw new CertificateException("Cannot set the CRL with the given revoked Certs.");
            }
        }
    }

    public RevokedCertificates getRevokedCertificates() {
        if (this.revokedCerts == null) {
            return null;
        }
        try {
            return (RevokedCertificates)this.revokedCerts.clone();
        }
        catch (CloneNotSupportedException cloneException) {
            return null;
        }
    }

    public boolean compareIssuerName(X500Name issuerName) {
        if (this.issuerName == null || issuerName == null) {
            return false;
        }
        return this.issuerName.equals(issuerName);
    }

    public void setTimeType(boolean flag) {
        this.timeType = flag;
    }

    public void setExtensions(X509V3Extensions extensions) throws CertificateException {
        this.clearSignature();
        this.clearTemplate();
        if (extensions == null) {
            throw new CertificateException("CRL extensions are null.");
        }
        if (extensions.getExtensionsType() != 2) {
            throw new CertificateException("Wrong extensions type: should be CRL extensions.");
        }
        if (this.theVersion == 0) {
            for (int index = 0; index < extensions.getExtensionCount(); ++index) {
                X509V3Extension extension = extensions.getExtensionByIndex(index);
                if (!extension.getCriticality()) continue;
                throw new CertificateException("Cannot set critical extensions on a version 1 CRL.");
            }
        }
        try {
            this.crlExtensions = (X509V3Extensions)extensions.clone();
        }
        catch (CloneNotSupportedException cloneException) {
            throw new CertificateException("Cannot set the CRL with the given extensions.");
        }
    }

    public X509V3Extensions getExtensions() {
        if (this.crlExtensions == null) {
            return null;
        }
        try {
            return (X509V3Extensions)this.crlExtensions.clone();
        }
        catch (CloneNotSupportedException cloneException) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void signCRL(String transformation, String device, JSAFE_PrivateKey signingKey, SecureRandom random) throws CertificateException {
        byte[] sigData;
        this.clearSignature();
        this.clearTemplate();
        if (transformation == null || device == null || signingKey == null) {
            throw new CertificateException("Cannot sign, specified values are null.");
        }
        try {
            String algFormat = this.getSignatureFormat();
            this.signatureAlgorithmBER = algFormat == null ? AlgorithmID.derEncodeAlgID((String)transformation, (int)1, null, (int)0, (int)0) : AlgorithmID.derEncodeAlgID((String)algFormat, (int)1, null, (int)0, (int)0);
        }
        catch (ASN_Exception e) {
            throw new CertificateException("Cannot sign, unknown algorithm.", (Exception)((Object)e));
        }
        this.innerDERLock.lock();
        try {
            this.innerDEREncode();
            sigData = this.performSignature(transformation, device, signingKey, random, this.innerDER, 0, this.innerDERLen);
        }
        finally {
            this.innerDERLock.unlock();
        }
        try {
            BitStringContainer sig = new BitStringContainer(0, true, 0, sigData, 0, sigData.length, sigData.length * 8, false);
            ASN1Container[] asn1Def = new ASN1Container[]{sig};
            this.signature = ASN1.derEncode((ASN1Container[])asn1Def);
        }
        catch (ASN_Exception asnException) {
            this.clearSignature();
            throw new CertificateException("Cannot sign the CRL as presently set.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean verifyCRLSignature(String device, JSAFE_PublicKey verifyingKey, SecureRandom random) throws CertificateException {
        if (device == null || verifyingKey == null) {
            throw new CertificateException("Specified values are null.");
        }
        this.innerDERLock.lock();
        try {
            if (this.innerDER == null) {
                throw new CertificateException("Cannot verify CRL, values not set.");
            }
            byte[] signBytes = this.getSignature();
            boolean bl = this.performSignatureVerification(device, verifyingKey, random, this.innerDER, 0, this.innerDERLen, signBytes, 0, signBytes.length);
            return bl;
        }
        finally {
            this.innerDERLock.unlock();
        }
    }

    private boolean checkExtensions(int type) {
        if (this.theVersion == 1 && this.crlExtensions != null) {
            Vector<X509V3Extension> extensions = this.crlExtensions.theExtensions;
            for (X509V3Extension extension : extensions) {
                if (extension.getExtensionType() != type || !extension.getCriticality()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof X509CRL)) {
            return false;
        }
        X509CRL other = (X509CRL)obj;
        try {
            int thisLen = this.getDERLen(0);
            int otherLen = other.getDERLen(0);
            if (thisLen != otherLen) {
                return false;
            }
            byte[] thisEncoding = new byte[thisLen];
            byte[] otherEncoding = new byte[otherLen];
            thisLen = this.getDEREncoding(thisEncoding, 0, 0);
            if (thisLen != (otherLen = other.getDEREncoding(otherEncoding, 0, 0))) {
                return false;
            }
            for (int index = 0; index < thisLen; ++index) {
                if (thisEncoding[index] == otherEncoding[index]) continue;
                return false;
            }
        }
        catch (CertificateException certException) {
            return false;
        }
        return true;
    }

    public int hashCode() {
        int derLen = this.getDERLen(0);
        byte[] derEncoding = new byte[derLen];
        try {
            derLen = this.getDEREncoding(derEncoding, 0, 0);
        }
        catch (CertificateException certException) {
            return 0;
        }
        return Arrays.hashCode(derEncoding);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object clone() throws CloneNotSupportedException {
        X509CRL otherSelf = (X509CRL)super.clone();
        if (this.signatureAlgorithmBER != null) {
            otherSelf.signatureAlgorithmBER = (byte[])this.signatureAlgorithmBER.clone();
        }
        otherSelf.signatureAlgorithmFormat = this.signatureAlgorithmFormat;
        if (this.signature != null) {
            otherSelf.signature = (byte[])this.signature.clone();
        }
        if (this.theDevice != null) {
            otherSelf.theDevice = this.theDevice;
        }
        if (this.theDeviceList != null) {
            otherSelf.theDeviceList = (String[])this.theDeviceList.clone();
        }
        otherSelf.theVersion = this.theVersion;
        if (this.issuerName != null) {
            otherSelf.issuerName = (X500Name)this.issuerName.clone();
        }
        if (this.revokedCerts != null) {
            otherSelf.revokedCerts = (RevokedCertificates)this.revokedCerts.clone();
        }
        if (this.thisUpdate != null) {
            otherSelf.thisUpdate = new Date(this.thisUpdate.getTime());
        }
        if (this.nextUpdate != null) {
            otherSelf.nextUpdate = new Date(this.nextUpdate.getTime());
        }
        if (this.crlExtensions != null) {
            otherSelf.crlExtensions = (X509V3Extensions)this.crlExtensions.clone();
        }
        this.innerDERLock.lock();
        try {
            otherSelf.innerSpecial = this.innerSpecial;
            if (this.innerDER != null) {
                try {
                    otherSelf.innerDEREncode();
                }
                catch (CertificateException certificateException) {
                    // empty catch block
                }
            }
        }
        finally {
            this.innerDERLock.unlock();
        }
        this.outerDERLock.lock();
        try {
            otherSelf.special = this.special;
            if (this.asn1Template != null) {
                otherSelf.outerDEREncodeInit();
            }
        }
        finally {
            this.outerDERLock.unlock();
        }
        return otherSelf;
    }

    private void clearTemplate() {
        this.outerDERClear();
        this.innerDERClear();
    }

    protected void clearComponents() {
        super.clearComponents();
        this.clearTemplate();
        this.theVersion = 0;
        this.issuerName = null;
        this.revokedCerts = null;
        this.thisUpdate = null;
        this.nextUpdate = null;
        this.crlExtensions = null;
        this.timeType = false;
    }

    protected Object writeReplace() throws ObjectStreamException {
        try {
            int len = this.getDERLen(0);
            byte[] encoding = new byte[len];
            this.getDEREncoding(encoding, 0, 0);
            return new X509CrlRep(encoding);
        }
        catch (CertificateException e) {
            throw new NotSerializableException(e.getMessage());
        }
    }

    protected static class X509CrlRep
    implements Serializable {
        private static final long serialVersionUID = -5724087715786371523L;
        private byte[] encoding;

        protected X509CrlRep(byte[] data) {
            this.encoding = data;
        }

        protected Object readResolve() throws ObjectStreamException {
            try {
                return new X509CRL(this.encoding, 0, 0);
            }
            catch (CertificateException e) {
                throw new NotSerializableException(e.getMessage());
            }
        }
    }
}

