/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.cert;

import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN1Lengths;
import com.rsa.asn1.ASN1Template;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.AlgorithmID;
import com.rsa.asn1.BitStringContainer;
import com.rsa.asn1.ChoiceContainer;
import com.rsa.asn1.EncodedContainer;
import com.rsa.asn1.EndContainer;
import com.rsa.asn1.GenTimeContainer;
import com.rsa.asn1.IntegerContainer;
import com.rsa.asn1.SequenceContainer;
import com.rsa.asn1.UTCTimeContainer;
import com.rsa.certj.CertJ;
import com.rsa.certj.CertJUtils;
import com.rsa.certj.cert.Certificate;
import com.rsa.certj.cert.CertificateException;
import com.rsa.certj.cert.NameException;
import com.rsa.certj.cert.PKCS10CertRequest;
import com.rsa.certj.cert.X500Name;
import com.rsa.certj.cert.X501Attributes;
import com.rsa.certj.cert.X509V3Extensions;
import com.rsa.certj.cert.attributes.V3ExtensionAttribute;
import com.rsa.certj.cert.attributes.X501Attribute;
import com.rsa.certj.cert.extensions.X509V3Extension;
import com.rsa.jsafe.JSAFE_PrivateKey;
import com.rsa.jsafe.JSAFE_PublicKey;
import java.io.NotSerializableException;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Date;
import java.util.Vector;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class X509Certificate
extends Certificate
implements Serializable {
    private static final long serialVersionUID = -2111356029761194088L;
    private static final Date FIRST_GENERALIZED_TIME_DATE = new Date(2524608000000L);
    public static final int X509_VERSION_1 = 0;
    public static final int X509_VERSION_2 = 1;
    public static final int X509_VERSION_3 = 2;
    private byte[] innerDER;
    private int innerDERLen;
    private int theVersion = 2;
    private X500Name subjectName;
    private X500Name issuerName;
    private byte[] serialNumber;
    private byte[] issuerUniqueID;
    private byte[] subjectUniqueID;
    private boolean timeType;
    private boolean timeTypeExplicitlySet;
    private Date notBefore;
    private Date notAfter;
    private X509V3Extensions theExtensions;
    private int special = 0;
    private ASN1Template asn1Template;
    private int innerSpecial = 0;
    private ASN1Template asn1TemplateInner;
    private ASN1Template asn1TemplateValidity;
    private final Lock outerDERLock = new ReentrantLock();
    private final Lock innerDERLock = new ReentrantLock();

    public X509Certificate() {
    }

    public X509Certificate(CertJ certJContext) {
        this.setCertJ(certJContext);
    }

    public X509Certificate(byte[] x509CertBER, int offset, int special) throws CertificateException {
        this(x509CertBER, offset, special, null);
    }

    public X509Certificate(byte[] x509CertBER, int offset, int special, CertJ certJContext) throws CertificateException {
        if (x509CertBER == null) {
            throw new CertificateException("Encoding is null.");
        }
        this.setCertJ(certJContext);
        this.setCertBER(x509CertBER, offset, special);
    }

    private void checkSpecial(int special) throws CertificateException {
        if (special != 0 && special != 0x400000 && special != 0x600000 && special != 0xC00000 && special != 0xE00000 && special != 65536 && special != 131072 && special != 0x800000 && special != 0xA00000) {
            throw new CertificateException("Could not encode: Invalid 'special'");
        }
    }

    public static int getNextBEROffset(byte[] x509CertBER, int offset) throws CertificateException {
        if (x509CertBER == null) {
            throw new CertificateException("Encoding is null.");
        }
        try {
            return offset + 1 + ASN1Lengths.determineLengthLen((byte[])x509CertBER, (int)(offset + 1)) + ASN1Lengths.determineLength((byte[])x509CertBER, (int)(offset + 1));
        }
        catch (ASN_Exception asnException) {
            throw new CertificateException("Could not read the BER encoding.", (Exception)((Object)asnException));
        }
    }

    private void setCertBER(byte[] x509CertBER, int offset, int special) throws CertificateException {
        if (x509CertBER == null) {
            throw new CertificateException("Encoding is null.");
        }
        this.clearComponents();
        ASN1Container[] asn1Def = X509Certificate.decodeCert(x509CertBER, offset, special);
        this.setInnerDER(asn1Def[1].data, asn1Def[1].dataOffset, this.special);
        this.signature = new byte[asn1Def[3].dataLen];
        System.arraycopy(asn1Def[3].data, asn1Def[3].dataOffset, this.signature, 0, asn1Def[3].dataLen);
        this.setSignatureAlgorithm(asn1Def[2].data, asn1Def[2].dataOffset, asn1Def[2].dataLen);
    }

    protected static ASN1Container[] decodeCert(byte[] certBER, int offset, int special) throws CertificateException {
        if (certBER == null) {
            throw new CertificateException("Encoding is null.");
        }
        SequenceContainer aSeq = new SequenceContainer(special);
        EndContainer anEnd = new EndContainer();
        EncodedContainer info = new EncodedContainer(12288);
        EncodedContainer algID = new EncodedContainer(12288);
        EncodedContainer sig = new EncodedContainer(768);
        ASN1Container[] asn1Def = new ASN1Container[]{aSeq, info, algID, sig, anEnd};
        try {
            ASN1.berDecode((byte[])certBER, (int)offset, (ASN1Container[])asn1Def);
        }
        catch (ASN_Exception asnException) {
            throw new CertificateException("Could not BER decode the cert.", (Exception)((Object)asnException));
        }
        return asn1Def;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getDERLen(int special) {
        this.outerDERLock.lock();
        try {
            this.outerDERSetSpecial(special);
            int n = this.outerDEREncodeInit();
            return n;
        }
        catch (CertificateException e) {
            int n = 0;
            return n;
        }
        finally {
            this.outerDERLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getDEREncoding(byte[] encoding, int offset, int special) throws CertificateException {
        if (encoding == null) {
            throw new CertificateException("Specified array is null.");
        }
        this.outerDERLock.lock();
        try {
            int totalLen = 0;
            try {
                int len;
                this.outerDERSetSpecial(special);
                if (this.asn1Template == null && (len = this.outerDEREncodeInit()) == 0) {
                    throw new CertificateException("Could not encode: Possibly some of the required fields of this certificate object are not set.");
                }
                this.asn1Template = null;
            }
            catch (ASN_Exception asnException) {
                this.asn1Template = null;
                throw new CertificateException("Could not encode: ", (Exception)((Object)asnException));
            }
            int infoLen = this.getInnerDER(encoding, offset + (totalLen += this.asn1Template.derEncode(encoding, offset)));
            if (infoLen == 0) {
                throw new CertificateException("Could not encode, missing data.");
            }
            System.arraycopy(this.signatureAlgorithmBER, 0, encoding, offset + (totalLen += infoLen), this.signatureAlgorithmBER.length);
            System.arraycopy(this.signature, 0, encoding, offset + (totalLen += this.signatureAlgorithmBER.length), this.signature.length);
            int n = totalLen + this.signature.length;
            return n;
        }
        finally {
            this.outerDERLock.unlock();
        }
    }

    private int outerDEREncodeInit() {
        if (this.getInnerDERLen() == 0) {
            return 0;
        }
        if (this.signatureAlgorithmBER == null || this.signature == null) {
            return 0;
        }
        try {
            SequenceContainer aSeq = new SequenceContainer(this.special, true, 0);
            EndContainer anEnd = new EndContainer();
            EncodedContainer info = new EncodedContainer(12288, true, 0, null, 0, this.innerDERLen);
            EncodedContainer algID = new EncodedContainer(12288, true, 0, null, 0, this.signatureAlgorithmBER.length);
            EncodedContainer sig = new EncodedContainer(768, true, 0, null, 0, this.signature.length);
            ASN1Container[] asn1Def = new ASN1Container[]{aSeq, info, algID, sig, anEnd};
            this.asn1Template = new ASN1Template(asn1Def);
            return this.asn1Template.derEncodeInit();
        }
        catch (ASN_Exception asnException) {
            return 0;
        }
    }

    private void outerDERSetSpecial(int special) throws CertificateException {
        if (special != this.special) {
            this.checkSpecial(special);
            this.clearTemplate();
            this.special = special;
        }
    }

    private void outerDERClear() {
        this.outerDERLock.lock();
        this.asn1Template = null;
        this.special = 0;
        this.outerDERLock.unlock();
    }

    protected void setVersionNumber(int versionInt) throws CertificateException {
        if (versionInt != 0 && versionInt != 1 && versionInt != 2) {
            throw new CertificateException("Invalid X.509 Certificate version.");
        }
        this.theVersion = versionInt;
    }

    private void setSignatureAlgorithm(byte[] algID, int offset, int len) throws CertificateException {
        block6: {
            if (algID == null || len == 0) {
                throw new CertificateException("Unknown or invalid signature algorithm.");
            }
            if (this.signatureAlgorithmBER == null) {
                this.signatureAlgorithmBER = new byte[len];
                System.arraycopy(algID, offset, this.signatureAlgorithmBER, 0, len);
                try {
                    String trans = AlgorithmID.berDecodeAlgID((byte[])algID, (int)offset, (int)1, null);
                    if (trans == null) {
                        throw new CertificateException("Unknown or invalid signature algorithm.");
                    }
                    break block6;
                }
                catch (ASN_Exception asnException) {
                    throw new CertificateException("Cannot decode signature algorithm.");
                }
            }
            if (!CertJUtils.byteArraysEqual(algID, offset, len, this.signatureAlgorithmBER)) {
                throw new CertificateException("Signature algorithms do not match.");
            }
        }
    }

    public void setInnerDER(byte[] x509InnerDER, int offset) throws CertificateException {
        this.setInnerDER(x509InnerDER, offset, 0);
    }

    private void setInnerDER(byte[] x509InnerDER, int offset, int special) throws CertificateException {
        if (x509InnerDER == null) {
            throw new CertificateException("Encoding is null.");
        }
        this.clearSignature();
        this.clearTemplate();
        this.innerSpecial = special;
        SequenceContainer aSeq = new SequenceContainer(this.innerSpecial);
        EndContainer anEnd = new EndContainer();
        IntegerContainer vers = new IntegerContainer(0xA20000);
        IntegerContainer serial = new IntegerContainer(0);
        EncodedContainer algID = new EncodedContainer(12288);
        EncodedContainer issuer = new EncodedContainer(12288);
        EncodedContainer validity = new EncodedContainer(12288);
        EncodedContainer subject = new EncodedContainer(12288);
        EncodedContainer key = new EncodedContainer(12288);
        EncodedContainer issuerID = new EncodedContainer(8454913);
        EncodedContainer subjectID = new EncodedContainer(8454914);
        EncodedContainer exten = new EncodedContainer(10563587);
        ASN1Container[] asn1Def = new ASN1Container[]{aSeq, vers, serial, algID, issuer, validity, subject, key, issuerID, subjectID, exten, anEnd};
        try {
            ASN1.berDecode((byte[])x509InnerDER, (int)offset, (ASN1Container[])asn1Def);
        }
        catch (ASN_Exception asnException) {
            throw new CertificateException("Could not BER decode the cert info.", (Exception)((Object)asnException));
        }
        if (vers.dataPresent) {
            try {
                this.setVersionNumber(vers.getValueAsInt());
            }
            catch (ASN_Exception asnException) {
                throw new CertificateException("Invalid version number: ", (Exception)((Object)asnException));
            }
        }
        this.setSerialNumber(serial.data, serial.dataOffset, serial.dataLen);
        this.setSignatureAlgorithm(algID.data, algID.dataOffset, algID.dataLen);
        try {
            this.setIssuerName(new X500Name(issuer.data, issuer.dataOffset, 0));
        }
        catch (NameException nameException) {
            throw new CertificateException("Invalid issuer name: ", nameException);
        }
        this.setValidityBER(validity.data, validity.dataOffset);
        try {
            this.setSubjectName(new X500Name(subject.data, subject.dataOffset, 0));
        }
        catch (NameException nameException) {
            throw new CertificateException("Invalid subject name: ", nameException);
        }
        this.setSubjectPublicKey(key.data, key.dataOffset);
        if (issuerID.dataPresent) {
            if (this.theVersion == 0) {
                throw new CertificateException("Version 1 certs not allowed to have issuer unique ID.");
            }
            this.issuerUniqueID = new byte[issuerID.dataLen];
            System.arraycopy(issuerID.data, issuerID.dataOffset, this.issuerUniqueID, 0, issuerID.dataLen);
        }
        if (subjectID.dataPresent) {
            if (this.theVersion == 0) {
                throw new CertificateException("Version 1 certs not allowed to have subject unique ID.");
            }
            this.subjectUniqueID = new byte[subjectID.dataLen];
            System.arraycopy(subjectID.data, subjectID.dataOffset, this.subjectUniqueID, 0, subjectID.dataLen);
        }
        if (exten.dataPresent) {
            X509V3Extensions extensions = new X509V3Extensions(exten.data, exten.dataOffset, 0xA00003, 1);
            this.setExtensions(extensions);
        }
        this.innerDERLen = X509Certificate.getNextBEROffset(x509InnerDER, offset) - offset;
        this.innerDER = new byte[this.innerDERLen];
        System.arraycopy(x509InnerDER, offset, this.innerDER, 0, this.innerDERLen);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getInnerDERLen() {
        this.innerDERLock.lock();
        try {
            if (this.innerDERLen != 0) {
                if (this.innerSpecial == this.special) {
                    int n = this.innerDERLen;
                    return n;
                }
                this.innerSpecial = this.special;
                this.innerDERClear();
            }
            try {
                this.innerDEREncodeInit();
            }
            catch (CertificateException e) {
                int n = 0;
                this.innerDERLock.unlock();
                return n;
            }
            int n = this.innerDERLen;
            return n;
        }
        finally {
            this.innerDERLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getInnerDER(byte[] encoding, int offset) throws CertificateException {
        if (encoding == null) {
            throw new CertificateException("Passed array is null");
        }
        this.innerDERLock.lock();
        try {
            this.innerDEREncode();
            System.arraycopy(this.innerDER, 0, encoding, offset, this.innerDERLen);
            int n = this.innerDERLen;
            return n;
        }
        finally {
            this.innerDERLock.unlock();
        }
    }

    private void innerDEREncodeInit() throws CertificateException {
        this.innerDERClear();
        if (this.subjectPublicKeyInfo == null || this.signatureAlgorithmBER == null || this.serialNumber == null || this.notBefore == null || this.notAfter == null) {
            throw new CertificateException("Cannot encode innerDER, information missing.");
        }
        if (this.subjectName == null && !this.checkExtensions(17)) {
            throw new CertificateException("Cannot encode innerDER, subject name missing.");
        }
        if (this.issuerName == null && !this.checkExtensions(18)) {
            throw new CertificateException("Cannot encode innerDER, issuer name missing.");
        }
        int validityLen = this.getValidityDERLen();
        try {
            SequenceContainer aSeq = new SequenceContainer(this.innerSpecial, true, 0);
            EndContainer anEnd = new EndContainer();
            boolean dataPresent = true;
            if (this.theVersion == 0) {
                dataPresent = false;
            }
            IntegerContainer vers = new IntegerContainer(0xA20000, dataPresent, 0, this.theVersion);
            IntegerContainer serial = (this.serialNumber[0] & 0x80) >> 7 == 0 ? new IntegerContainer(0, true, 0, this.serialNumber, 0, this.serialNumber.length, true) : new IntegerContainer(0, true, 0, this.serialNumber, 0, this.serialNumber.length, false);
            EncodedContainer algID = new EncodedContainer(12288, true, 0, this.signatureAlgorithmBER, 0, this.signatureAlgorithmBER.length);
            EncodedContainer validity = new EncodedContainer(12288, true, 0, null, 0, validityLen);
            EncodedContainer key = new EncodedContainer(12288, true, 0, null, 0, this.subjectPublicKeyInfo.length);
            int dataLen = this.issuerName != null ? this.issuerName.getDERLen(0) : 2;
            EncodedContainer issuer = new EncodedContainer(12288, true, 0, null, 0, dataLen);
            dataLen = this.subjectName != null ? this.subjectName.getDERLen(0) : 2;
            EncodedContainer subject = new EncodedContainer(12288, true, 0, null, 0, dataLen);
            dataPresent = false;
            dataLen = 0;
            if (this.theVersion != 0 && this.issuerUniqueID != null) {
                dataPresent = true;
                dataLen = this.issuerUniqueID.length;
            }
            EncodedContainer issuerID = new EncodedContainer(8454913, dataPresent, 0, null, 0, dataLen);
            dataPresent = false;
            dataLen = 0;
            if (this.theVersion != 0 && this.subjectUniqueID != null) {
                dataPresent = true;
                dataLen = this.subjectUniqueID.length;
            }
            EncodedContainer subjectID = new EncodedContainer(8454914, dataPresent, 0, null, 0, dataLen);
            dataPresent = false;
            dataLen = 0;
            if (this.theVersion == 2 && this.theExtensions != null && (dataLen = this.theExtensions.getDERLen(10551299)) != 0) {
                dataPresent = true;
            }
            EncodedContainer exten = new EncodedContainer(10563587, dataPresent, 0, null, 0, dataLen);
            ASN1Container[] asn1Def = new ASN1Container[]{aSeq, vers, serial, algID, issuer, validity, subject, key, issuerID, subjectID, exten, anEnd};
            this.asn1TemplateInner = new ASN1Template(asn1Def);
            this.innerDERLen = this.asn1TemplateInner.derEncodeInit();
        }
        catch (ASN_Exception asnException) {
            throw new CertificateException("Cannot encode innerDER, information missing.");
        }
    }

    private void innerDEREncode() throws CertificateException {
        if (this.innerDER == null) {
            int totalLen = 0;
            try {
                int dataLen = this.getInnerDERLen();
                if (dataLen == 0) {
                    throw new CertificateException("Cannot encode innerDER, information missing.");
                }
                this.innerDER = new byte[dataLen];
                totalLen += this.asn1TemplateInner.derEncode(this.innerDER, 0);
                this.asn1TemplateInner = null;
            }
            catch (ASN_Exception asnException) {
                this.asn1TemplateInner = null;
                throw new CertificateException("Could not encode: ", (Exception)((Object)asnException));
            }
            try {
                if (this.issuerName != null) {
                    totalLen += this.issuerName.getDEREncoding(this.innerDER, totalLen, 0);
                } else {
                    this.innerDER[totalLen] = 48;
                    this.innerDER[totalLen + 1] = 0;
                    totalLen += 2;
                }
                int valueLen = this.getValidityDEREncoding(this.innerDER, totalLen);
                if (valueLen == 0) {
                    throw new CertificateException("Could not encode Validity.");
                }
                totalLen += valueLen;
                if (this.subjectName != null) {
                    totalLen += this.subjectName.getDEREncoding(this.innerDER, totalLen, 0);
                } else {
                    this.innerDER[totalLen] = 48;
                    this.innerDER[totalLen + 1] = 0;
                    totalLen += 2;
                }
                System.arraycopy(this.subjectPublicKeyInfo, 0, this.innerDER, totalLen, this.subjectPublicKeyInfo.length);
                totalLen += this.subjectPublicKeyInfo.length;
                if (this.theVersion != 0 && this.issuerUniqueID != null) {
                    System.arraycopy(this.issuerUniqueID, 0, this.innerDER, totalLen, this.issuerUniqueID.length);
                    totalLen += this.issuerUniqueID.length;
                }
                if (this.theVersion != 0 && this.subjectUniqueID != null) {
                    System.arraycopy(this.subjectUniqueID, 0, this.innerDER, totalLen, this.subjectUniqueID.length);
                    totalLen += this.subjectUniqueID.length;
                }
                if (this.theVersion == 2 && this.theExtensions != null) {
                    totalLen += this.theExtensions.getDEREncoding(this.innerDER, totalLen, 10551299);
                }
            }
            catch (NameException nameException) {
                throw new CertificateException("Could not encode a Name: ", nameException);
            }
        }
    }

    private void innerDERClear() {
        this.innerDERLock.lock();
        this.asn1TemplateInner = null;
        this.innerDER = null;
        this.innerDERLen = 0;
        this.innerSpecial = 0;
        this.innerDERLock.unlock();
    }

    public void setUnsignedCertFromPKCS10Request(PKCS10CertRequest certRequest) throws CertificateException {
        this.clearComponents();
        if (certRequest == null) {
            throw new CertificateException("Cert Request is null.");
        }
        this.setSubjectName(certRequest.getSubjectName());
        this.setSubjectPublicKey(certRequest.getSubjectPublicKey("Java"));
        X501Attributes attribs = certRequest.getAttributes();
        if (attribs == null) {
            return;
        }
        X501Attribute extensions = attribs.getAttributeByType(2);
        if (extensions == null) {
            this.setVersion(0);
            return;
        }
        this.setVersion(2);
        this.setExtensions(((V3ExtensionAttribute)extensions).getV3ExtensionAttribute());
    }

    public byte[] getSignature() throws CertificateException {
        if (this.signature == null) {
            throw new CertificateException("Object not signed.");
        }
        BitStringContainer sig = new BitStringContainer(0);
        ASN1Container[] asn1Def = new ASN1Container[]{sig};
        try {
            ASN1.berDecode((byte[])this.signature, (int)0, (ASN1Container[])asn1Def);
        }
        catch (ASN_Exception asnException) {
            throw new CertificateException("Cannot extract the signature.", (Exception)((Object)asnException));
        }
        byte[] returnValue = new byte[sig.dataLen];
        System.arraycopy(sig.data, sig.dataOffset, returnValue, 0, sig.dataLen);
        return returnValue;
    }

    public void setVersion(int version) throws CertificateException {
        if (version == this.theVersion) {
            return;
        }
        if (version != 0 && version != 1 && version != 2) {
            throw new CertificateException("Invalid cert version: " + version);
        }
        this.clearSignature();
        this.clearTemplate();
        switch (version) {
            case 0: {
                if (!this.emptyExtensions(this.theExtensions)) {
                    throw new CertificateException("You can not use X509 V1 version for a certificate with extensions.");
                }
                if (this.issuerUniqueID != null) {
                    throw new CertificateException("You can not use X509 V1 version for a certificate with issuer unique ID.");
                }
                if (this.subjectUniqueID == null) break;
                throw new CertificateException("You can not use X509 V1 version for a certificate with subject unique ID.");
            }
            case 1: {
                if (this.emptyExtensions(this.theExtensions)) break;
                throw new CertificateException("You can not use X509 V2 version for a certificate with extensions.");
            }
        }
        this.theVersion = version;
    }

    public int getVersion() {
        return this.theVersion;
    }

    public void setSubjectName(X500Name subjectName) throws CertificateException {
        this.clearSignature();
        this.clearTemplate();
        if (subjectName == null) {
            if (!this.checkExtensions(17)) {
                throw new CertificateException("Cannot set the cert with the given subjectName.");
            }
        } else {
            try {
                this.subjectName = (X500Name)subjectName.clone();
            }
            catch (CloneNotSupportedException cloneException) {
                throw new CertificateException("Cannot set the cert with the given subjectName.");
            }
        }
    }

    public X500Name getSubjectName() {
        if (this.subjectName == null) {
            return null;
        }
        try {
            return (X500Name)this.subjectName.clone();
        }
        catch (CloneNotSupportedException cloneException) {
            return null;
        }
    }

    public void setIssuerName(X500Name issuerName) throws CertificateException {
        this.clearSignature();
        this.clearTemplate();
        if (issuerName == null) {
            if (!this.checkExtensions(18)) {
                throw new CertificateException("Cannot set the cert with the given issuerName.");
            }
        } else {
            try {
                this.issuerName = (X500Name)issuerName.clone();
            }
            catch (CloneNotSupportedException cloneException) {
                throw new CertificateException("Cannot set the cert with the given issuerName.");
            }
        }
    }

    public X500Name getIssuerName() {
        if (this.issuerName == null) {
            return null;
        }
        try {
            return (X500Name)this.issuerName.clone();
        }
        catch (CloneNotSupportedException cloneException) {
            return null;
        }
    }

    public void setSerialNumber(byte[] serialNumber, int offset, int len) {
        this.clearSignature();
        this.clearTemplate();
        this.serialNumber = new byte[len];
        if (serialNumber == null) {
            return;
        }
        System.arraycopy(serialNumber, offset, this.serialNumber, 0, len);
    }

    public byte[] getSerialNumber() {
        if (this.serialNumber == null) {
            return new byte[0];
        }
        return (byte[])this.serialNumber.clone();
    }

    public byte[] getIssuerAndSerialNumber() throws CertificateException {
        if (this.issuerName == null || this.serialNumber == null) {
            throw new CertificateException("Cannot get issuerSerial, not all values set.");
        }
        try {
            int nameLen = this.issuerName.getDERLen(0);
            byte[] nameBER = new byte[nameLen];
            nameLen = this.issuerName.getDEREncoding(nameBER, 0, 0);
            SequenceContainer aSeq = new SequenceContainer(0, true, 0);
            EndContainer anEnd = new EndContainer();
            IntegerContainer serial = (this.serialNumber[0] & 0x80) >> 7 == 0 ? new IntegerContainer(0, true, 0, this.serialNumber, 0, this.serialNumber.length, true) : new IntegerContainer(0, true, 0, this.serialNumber, 0, this.serialNumber.length, false);
            EncodedContainer issue = new EncodedContainer(12288, true, 0, nameBER, 0, nameLen);
            ASN1Container[] asn1Def = new ASN1Container[]{aSeq, issue, serial, anEnd};
            return ASN1.derEncode((ASN1Container[])asn1Def);
        }
        catch (ASN_Exception asnException) {
            throw new CertificateException("Cannot encode issuerSerial: ", (Exception)((Object)asnException));
        }
        catch (NameException nameException) {
            throw new CertificateException("Cannot encode issuerSerial: ", nameException);
        }
    }

    public boolean compareIssuerAndSerialNumber(byte[] issuerSerial, int offset, int len) {
        if (issuerSerial == null || len == 0) {
            return false;
        }
        try {
            byte[] thisIssuerSerial = this.getIssuerAndSerialNumber();
            if (thisIssuerSerial.length != len) {
                return false;
            }
            int index = 0;
            while (index < len) {
                if (issuerSerial[offset] != thisIssuerSerial[index]) {
                    return false;
                }
                ++index;
                ++offset;
            }
            return true;
        }
        catch (CertificateException certException) {
            return false;
        }
    }

    public boolean compareSubjectName(X500Name subjectName) {
        if (this.subjectName == null || subjectName == null) {
            return false;
        }
        return this.subjectName.equals(subjectName);
    }

    public void setTimeType(boolean flag) {
        this.timeType = flag;
        this.timeTypeExplicitlySet = true;
    }

    private void setValidityBER(byte[] validityBER, int offset) throws CertificateException {
        if (validityBER == null) {
            throw new CertificateException("Encoding is null.");
        }
        SequenceContainer aSeq = new SequenceContainer(0);
        EndContainer anEnd = new EndContainer();
        ChoiceContainer choice1 = new ChoiceContainer(0);
        ChoiceContainer choice2 = new ChoiceContainer(0);
        UTCTimeContainer utc1 = new UTCTimeContainer(0);
        UTCTimeContainer utc2 = new UTCTimeContainer(0);
        GenTimeContainer gen1 = new GenTimeContainer(0);
        GenTimeContainer gen2 = new GenTimeContainer(0);
        ASN1Container[] asn1Def = new ASN1Container[]{aSeq, choice1, utc1, gen1, anEnd, choice2, utc2, gen2, anEnd, anEnd};
        try {
            ASN1.berDecode((byte[])validityBER, (int)offset, (ASN1Container[])asn1Def);
        }
        catch (ASN_Exception asnException) {
            throw new CertificateException("Cannot extract Validity.", (Exception)((Object)asnException));
        }
        Date start = gen1.theTime;
        if (!gen1.dataPresent) {
            start = utc1.theTime;
        }
        Date end = gen2.theTime;
        if (!gen2.dataPresent) {
            end = utc2.theTime;
        }
        this.setValidity(start, end);
    }

    public void setValidity(Date start, Date end) throws CertificateException {
        this.clearSignature();
        this.clearTemplate();
        this.clearValidityTemplate();
        if (start == null || end == null) {
            throw new CertificateException("Cannot set the validity with the given dates.");
        }
        this.notBefore = new Date(start.getTime());
        this.notAfter = new Date(end.getTime());
        if (!this.notAfter.after(this.notBefore)) {
            throw new CertificateException("Cannot set the validity with the given dates.");
        }
    }

    private void clearValidityTemplate() {
        this.asn1TemplateValidity = null;
    }

    private int getValidityDERLen() {
        Object gen2;
        Object gen1;
        SequenceContainer aSeq = new SequenceContainer(0, true, 0);
        EndContainer anEnd = new EndContainer();
        if (!this.timeTypeExplicitlySet) {
            gen1 = this.notBefore.before(FIRST_GENERALIZED_TIME_DATE) ? new UTCTimeContainer(0, true, 0, this.notBefore) : new GenTimeContainer(0, true, 0, this.notBefore);
            gen2 = this.notAfter.before(FIRST_GENERALIZED_TIME_DATE) ? new UTCTimeContainer(0, true, 0, this.notAfter) : new GenTimeContainer(0, true, 0, this.notAfter);
        } else if (this.timeType) {
            gen1 = new GenTimeContainer(0, true, 0, this.notBefore);
            gen2 = new GenTimeContainer(0, true, 0, this.notAfter);
        } else {
            gen1 = new UTCTimeContainer(0, true, 0, this.notBefore);
            gen2 = new UTCTimeContainer(0, true, 0, this.notAfter);
        }
        ASN1Container[] asn1Def = new ASN1Container[]{aSeq, gen1, gen2, anEnd};
        this.asn1TemplateValidity = new ASN1Template(asn1Def);
        try {
            return this.asn1TemplateValidity.derEncodeInit();
        }
        catch (ASN_Exception asnException) {
            return 0;
        }
    }

    private int getValidityDEREncoding(byte[] encoding, int offset) {
        if (this.asn1TemplateValidity == null && this.getValidityDERLen() == 0) {
            return 0;
        }
        try {
            int returnValue = this.asn1TemplateValidity.derEncode(encoding, offset);
            this.asn1TemplateValidity = null;
            return returnValue;
        }
        catch (ASN_Exception asnException) {
            this.asn1TemplateValidity = null;
            return 0;
        }
    }

    public Date getStartDate() {
        if (this.notBefore == null) {
            return null;
        }
        return new Date(this.notBefore.getTime());
    }

    public Date getEndDate() {
        if (this.notAfter == null) {
            return null;
        }
        return new Date(this.notAfter.getTime());
    }

    public boolean checkValidityDate(Date validityCheckDate) {
        if (this.notBefore == null || this.notAfter == null || validityCheckDate == null) {
            return false;
        }
        return validityCheckDate.compareTo(this.notBefore) >= 0 && validityCheckDate.compareTo(this.notAfter) <= 0;
    }

    public void setIssuerUniqueID(byte[] issuerUniqueID, int offset, int len) throws CertificateException {
        this.clearSignature();
        this.clearTemplate();
        if (this.theVersion == 0) {
            throw new CertificateException("Cannot set unique ID on a version 1 cert.");
        }
        if (issuerUniqueID == null) {
            return;
        }
        try {
            BitStringContainer id = new BitStringContainer(0x800001, true, 0, issuerUniqueID, offset, len, len * 8, false);
            ASN1Container[] asn1Def = new ASN1Container[]{id};
            this.issuerUniqueID = ASN1.derEncode((ASN1Container[])asn1Def);
        }
        catch (ASN_Exception asnException) {
            throw new CertificateException("Cannot set issuerUniqueID: ", (Exception)((Object)asnException));
        }
    }

    public byte[] getIssuerUniqueID() {
        if (this.issuerUniqueID == null) {
            return null;
        }
        try {
            int offset = 2 + ASN1Lengths.determineLengthLen((byte[])this.issuerUniqueID, (int)1);
            byte[] returnValue = new byte[this.issuerUniqueID.length - offset];
            System.arraycopy(this.issuerUniqueID, offset, returnValue, 0, returnValue.length);
            return returnValue;
        }
        catch (ASN_Exception e) {
            return null;
        }
    }

    public void setSubjectUniqueID(byte[] subjectUniqueID, int offset, int len) throws CertificateException {
        this.clearSignature();
        this.clearTemplate();
        if (this.theVersion == 0) {
            throw new CertificateException("Cannot set unique ID on a version 1 cert.");
        }
        if (subjectUniqueID == null) {
            return;
        }
        try {
            BitStringContainer id = new BitStringContainer(0x800002, true, 0, subjectUniqueID, offset, len, len * 8, false);
            ASN1Container[] asn1Def = new ASN1Container[]{id};
            this.subjectUniqueID = ASN1.derEncode((ASN1Container[])asn1Def);
        }
        catch (ASN_Exception asnException) {
            throw new CertificateException("Cannot set subjectUniqueID.", (Exception)((Object)asnException));
        }
    }

    public byte[] getSubjectUniqueID() {
        if (this.subjectUniqueID == null) {
            return null;
        }
        try {
            int offset = 2 + ASN1Lengths.determineLengthLen((byte[])this.subjectUniqueID, (int)1);
            byte[] returnValue = new byte[this.subjectUniqueID.length - offset];
            System.arraycopy(this.subjectUniqueID, offset, returnValue, 0, returnValue.length);
            return returnValue;
        }
        catch (ASN_Exception e) {
            return null;
        }
    }

    public void setExtensions(X509V3Extensions extensions) throws CertificateException {
        if (this.emptyExtensions(extensions)) {
            return;
        }
        if (extensions.getExtensionsType() != 1) {
            throw new CertificateException("Wrong extensions type: should be Cert extensions.");
        }
        this.clearSignature();
        this.clearTemplate();
        try {
            this.theExtensions = (X509V3Extensions)extensions.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new CertificateException("Cannot set the cert with the given extensions.", e);
        }
        if (this.theVersion != 2) {
            this.setVersion(2);
        }
    }

    public X509V3Extensions getExtensions() {
        if (this.theExtensions == null) {
            return null;
        }
        try {
            return (X509V3Extensions)this.theExtensions.clone();
        }
        catch (CloneNotSupportedException cloneException) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void signCertificate(String transformation, String device, JSAFE_PrivateKey signingKey, SecureRandom random) throws CertificateException {
        byte[] sigData;
        this.clearSignature();
        this.clearTemplate();
        if (transformation == null || device == null || signingKey == null) {
            throw new CertificateException("Specified values are null.");
        }
        try {
            String algFormat = this.getSignatureFormat(transformation);
            this.signatureAlgorithmBER = algFormat == null ? AlgorithmID.derEncodeAlgID((String)transformation, (int)1, null, (int)0, (int)0) : AlgorithmID.derEncodeAlgID((String)algFormat, (int)1, null, (int)0, (int)0);
        }
        catch (ASN_Exception e) {
            throw new CertificateException("Cannot sign, unknown algorithm.", (Exception)((Object)e));
        }
        this.innerDERLock.lock();
        try {
            this.innerDEREncode();
            sigData = this.performSignature(transformation, device, signingKey, random, this.innerDER, 0, this.innerDERLen);
        }
        finally {
            this.innerDERLock.unlock();
        }
        try {
            BitStringContainer sig = new BitStringContainer(0, true, 0, sigData, 0, sigData.length, sigData.length * 8, false);
            ASN1Container[] asn1Def = new ASN1Container[]{sig};
            this.signature = ASN1.derEncode((ASN1Container[])asn1Def);
        }
        catch (ASN_Exception asnException) {
            this.clearSignature();
            throw new CertificateException("Cannot sign the cert as presently set.", (Exception)((Object)asnException));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean verifyCertificateSignature(String device, JSAFE_PublicKey verifyingKey, SecureRandom random) throws CertificateException {
        if (device == null || verifyingKey == null) {
            throw new CertificateException("Specified values are null.");
        }
        this.innerDERLock.lock();
        try {
            if (this.innerDER == null) {
                throw new CertificateException("Cannot verify certificate, values not set.");
            }
            byte[] signBytes = this.getSignature();
            boolean bl = this.performSignatureVerification(device, verifyingKey, random, this.innerDER, 0, this.innerDERLen, signBytes, 0, signBytes.length);
            return bl;
        }
        finally {
            this.innerDERLock.unlock();
        }
    }

    private boolean checkExtensions(int type) {
        if (this.theVersion == 2 && this.theExtensions != null) {
            Vector<X509V3Extension> extensions = this.theExtensions.theExtensions;
            for (X509V3Extension extension : extensions) {
                if (extension.getExtensionType() != type || !extension.getCriticality()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof X509Certificate)) {
            return false;
        }
        X509Certificate other = (X509Certificate)obj;
        try {
            int thisLen = this.getDERLen(0);
            int otherLen = other.getDERLen(0);
            if (thisLen != otherLen) {
                return false;
            }
            byte[] thisEncoding = new byte[thisLen];
            byte[] otherEncoding = new byte[otherLen];
            thisLen = this.getDEREncoding(thisEncoding, 0, 0);
            if (thisLen != (otherLen = other.getDEREncoding(otherEncoding, 0, 0))) {
                return false;
            }
            return Arrays.equals(thisEncoding, otherEncoding);
        }
        catch (CertificateException certException) {
            return false;
        }
    }

    public int hashCode() {
        int derLen = this.getDERLen(0);
        byte[] derEncoding = new byte[derLen];
        try {
            derLen = this.getDEREncoding(derEncoding, 0, 0);
        }
        catch (CertificateException e) {
            return 0;
        }
        return Arrays.hashCode(derEncoding);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object clone() throws CloneNotSupportedException {
        X509Certificate otherSelf = (X509Certificate)super.clone();
        if (this.subjectPublicKeyInfo != null) {
            otherSelf.subjectPublicKeyInfo = (byte[])this.subjectPublicKeyInfo.clone();
        }
        if (this.subjectPublicKey != null) {
            otherSelf.subjectPublicKey = (JSAFE_PublicKey)this.subjectPublicKey.clone();
        }
        if (this.signatureAlgorithmBER != null) {
            otherSelf.signatureAlgorithmBER = (byte[])this.signatureAlgorithmBER.clone();
        }
        if (this.signature != null) {
            otherSelf.signature = (byte[])this.signature.clone();
        }
        otherSelf.signatureAlgorithmFormat = this.signatureAlgorithmFormat;
        otherSelf.theVersion = this.theVersion;
        if (this.subjectName != null) {
            otherSelf.subjectName = (X500Name)this.subjectName.clone();
        }
        if (this.issuerName != null) {
            otherSelf.issuerName = (X500Name)this.issuerName.clone();
        }
        if (this.serialNumber != null) {
            otherSelf.serialNumber = (byte[])this.serialNumber.clone();
        }
        if (this.issuerUniqueID != null) {
            otherSelf.issuerUniqueID = (byte[])this.issuerUniqueID.clone();
        }
        if (this.subjectUniqueID != null) {
            otherSelf.subjectUniqueID = (byte[])this.subjectUniqueID.clone();
        }
        otherSelf.timeType = this.timeType;
        if (this.notBefore != null) {
            otherSelf.notBefore = new Date(this.notBefore.getTime());
        }
        if (this.notAfter != null) {
            otherSelf.notAfter = new Date(this.notAfter.getTime());
        }
        if (this.theExtensions != null) {
            otherSelf.theExtensions = (X509V3Extensions)this.theExtensions.clone();
        }
        this.innerDERLock.lock();
        try {
            otherSelf.innerSpecial = this.innerSpecial;
            if (this.innerDER != null) {
                try {
                    otherSelf.innerDEREncode();
                }
                catch (CertificateException certificateException) {
                    // empty catch block
                }
            }
        }
        finally {
            this.innerDERLock.unlock();
        }
        this.outerDERLock.lock();
        try {
            otherSelf.special = this.special;
            if (this.asn1Template != null) {
                otherSelf.outerDEREncodeInit();
            }
        }
        finally {
            this.outerDERLock.unlock();
        }
        if (this.asn1TemplateValidity != null) {
            otherSelf.getValidityDERLen();
        }
        return otherSelf;
    }

    private void clearTemplate() {
        this.outerDERClear();
        this.innerDERClear();
    }

    protected void clearComponents() {
        super.clearComponents();
        this.clearTemplate();
        this.theVersion = 2;
        this.subjectName = null;
        this.issuerName = null;
        this.serialNumber = null;
        this.issuerUniqueID = null;
        this.subjectUniqueID = null;
        this.notBefore = null;
        this.notAfter = null;
        this.theExtensions = null;
    }

    private boolean emptyExtensions(X509V3Extensions extensions) {
        return extensions == null || extensions.getExtensionCount() == 0;
    }

    protected Object writeReplace() throws ObjectStreamException {
        try {
            int len = this.getDERLen(0);
            byte[] encoding = new byte[len];
            this.getDEREncoding(encoding, 0, 0);
            return new X509CertRep(encoding);
        }
        catch (CertificateException e) {
            throw new NotSerializableException(e.getMessage());
        }
    }

    protected static class X509CertRep
    implements Serializable {
        private static final long serialVersionUID = 2461303762189202977L;
        private byte[] encoding;

        protected X509CertRep(byte[] data) {
            this.encoding = data;
        }

        protected Object readResolve() throws ObjectStreamException {
            try {
                return new X509Certificate(this.encoding, 0, 0);
            }
            catch (CertificateException e) {
                throw new NotSerializableException(e.getMessage());
            }
        }
    }
}

