/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.cert;

import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN1Lengths;
import com.rsa.asn1.ASN1Template;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.EncodedContainer;
import com.rsa.asn1.OfContainer;
import com.rsa.certj.CertJUtils;
import com.rsa.certj.cert.CRLEntryExtension;
import com.rsa.certj.cert.CRLExtension;
import com.rsa.certj.cert.CertExtension;
import com.rsa.certj.cert.CertificateException;
import com.rsa.certj.cert.OCSPRequestExtension;
import com.rsa.certj.cert.OCSPSingleExtension;
import com.rsa.certj.cert.extensions.X509V3Extension;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Vector;

public class X509V3Extensions
implements Cloneable,
Serializable {
    protected Vector<X509V3Extension> theExtensions;
    protected int special;
    private int extFlag;
    public static final int X509_EXT_TYPE_CERT = 1;
    public static final int X509_EXT_TYPE_CRL = 2;
    public static final int X509_EXT_TYPE_CRL_ENTRY = 3;
    public static final int X509_EXT_TYPE_OCSP_SINGLE = 4;
    public static final int X509_EXT_TYPE_OCSP_REQUEST = 5;
    private int extFlagMin = 1;
    private int extFlagMax = 5;
    private ASN1Template asn1Template;

    public X509V3Extensions(int extType) throws CertificateException {
        if (extType > this.extFlagMax || extType < this.extFlagMin) {
            throw new CertificateException("Invalid extensions type.");
        }
        this.extFlag = extType;
    }

    public X509V3Extensions(byte[] extensionsBER, int offset, int special, int extType) throws CertificateException {
        if (extType > this.extFlagMax || extType < this.extFlagMin) {
            throw new CertificateException("Invalid extensions type.");
        }
        if (extensionsBER == null) {
            throw new CertificateException("Encoding is null.");
        }
        this.extFlag = extType;
        this.setExtensionsBER(extensionsBER, offset, special);
    }

    public static int getNextBEROffset(byte[] extensionsBER, int offset) throws CertificateException {
        if (extensionsBER == null) {
            throw new CertificateException("Encoding is null.");
        }
        try {
            return offset + ASN1Lengths.determineLength((byte[])extensionsBER, (int)offset);
        }
        catch (ASN_Exception asnException) {
            throw new CertificateException("Could not read the BER encoding.");
        }
    }

    private void setExtensionsBER(byte[] extensionsBER, int offset, int special) throws CertificateException {
        if (extensionsBER == null) {
            throw new CertificateException("Encoding is null.");
        }
        this.reset();
        try {
            OfContainer seqOf = new OfContainer(special, 12288, (ASN1Container)new EncodedContainer(12288));
            ASN1Container[] asn1Def = new ASN1Container[]{seqOf};
            ASN1.berDecode((byte[])extensionsBER, (int)offset, (ASN1Container[])asn1Def);
            int extensionCount = seqOf.getContainerCount();
            if (extensionCount > 0) {
                this.theExtensions = new Vector();
            }
            for (int index = 0; index < extensionCount; ++index) {
                ASN1Container nextContainer = seqOf.containerAt(index);
                X509V3Extension nextExtension = X509V3Extension.getInstance(nextContainer.data, nextContainer.dataOffset);
                switch (this.extFlag) {
                    case 1: {
                        if (nextExtension instanceof CertExtension) break;
                        throw new CertificateException("Extension of the wrong type");
                    }
                    case 2: {
                        if (nextExtension instanceof CRLExtension) break;
                        throw new CertificateException("Extension of the wrong type");
                    }
                    case 3: {
                        if (nextExtension instanceof CRLEntryExtension) break;
                        throw new CertificateException("Extension of the wrong type");
                    }
                    case 4: {
                        if (nextExtension instanceof OCSPSingleExtension) break;
                        throw new CertificateException("Extension of the wrong type");
                    }
                    case 5: {
                        if (nextExtension instanceof OCSPRequestExtension) break;
                        throw new CertificateException("Extension of the wrong type");
                    }
                }
                if (this.getExtensionByType(nextExtension.getExtensionType()) != null && nextExtension.getExtensionType() != -1) {
                    throw new CertificateException("Extension of " + nextExtension.getExtensionTypeString() + " type already exists.");
                }
                this.theExtensions.addElement(nextExtension);
            }
        }
        catch (ASN_Exception asnException) {
            throw new CertificateException("Could not read the BER of the Extensions.");
        }
    }

    public int getDERLen(int special) {
        return this.encodeInit(special);
    }

    private int encodeInit(int special) {
        this.special = special;
        try {
            OfContainer seqOf = new OfContainer(special, true, 0, 12288, (ASN1Container)new EncodedContainer(12288));
            int extensionCount = 0;
            if (this.theExtensions != null) {
                extensionCount = this.theExtensions.size();
            }
            for (int index = 0; index < extensionCount; ++index) {
                X509V3Extension nextExtension = this.theExtensions.elementAt(index);
                int nextLen = nextExtension.getDERLen(0);
                EncodedContainer nextContainer = new EncodedContainer(12288, true, 0, null, 0, nextLen);
                seqOf.addContainer((ASN1Container)nextContainer);
            }
            ASN1Container[] asn1Def = new ASN1Container[]{seqOf};
            this.asn1Template = new ASN1Template(asn1Def);
            return this.asn1Template.derEncodeInit();
        }
        catch (ASN_Exception asnException) {
            this.asn1Template = null;
            return 0;
        }
    }

    public int getDEREncoding(byte[] encoding, int offset, int special) {
        if (encoding == null) {
            return 0;
        }
        if ((this.asn1Template == null || special != this.special) && this.encodeInit(special) == 0) {
            return 0;
        }
        int totalLen = 0;
        try {
            totalLen += this.asn1Template.derEncode(encoding, offset);
            this.asn1Template = null;
        }
        catch (ASN_Exception asnException) {
            this.asn1Template = null;
            return 0;
        }
        int extensionCount = 0;
        if (this.theExtensions != null) {
            extensionCount = this.theExtensions.size();
        }
        for (int index = 0; index < extensionCount; ++index) {
            X509V3Extension nextExtension = this.theExtensions.elementAt(index);
            totalLen += nextExtension.getDEREncoding(encoding, offset + totalLen, 0);
        }
        return totalLen;
    }

    public int addV3Extension(X509V3Extension extension) throws CertificateException {
        if (extension == null) {
            throw new CertificateException("Specified extension is null.");
        }
        this.reset();
        if (this.theExtensions == null) {
            this.theExtensions = new Vector();
        }
        switch (this.extFlag) {
            case 1: {
                if (extension instanceof CertExtension) break;
                throw new CertificateException("Extension of the wrong type");
            }
            case 2: {
                if (extension instanceof CRLExtension) break;
                throw new CertificateException("Extension of the wrong type");
            }
            case 3: {
                if (extension instanceof CRLEntryExtension) break;
                throw new CertificateException("Extension of the wrong type");
            }
        }
        if (this.getExtensionByType(extension.getExtensionType()) != null && extension.getExtensionType() != -1) {
            throw new CertificateException("Extension of " + extension.getExtensionTypeString() + " type already exists.");
        }
        this.theExtensions.addElement(extension);
        return this.theExtensions.indexOf(extension);
    }

    public int getExtensionCount() {
        if (this.theExtensions != null) {
            return this.theExtensions.size();
        }
        return 0;
    }

    public int getExtensionsType() {
        return this.extFlag;
    }

    public X509V3Extension getExtensionByIndex(int index) throws CertificateException {
        if (this.theExtensions == null) {
            throw new CertificateException(" There is no extensions.");
        }
        if (index < this.getExtensionCount()) {
            return this.theExtensions.elementAt(index);
        }
        throw new CertificateException("Invalid index");
    }

    public X509V3Extension getExtensionByType(int extensionType) throws CertificateException {
        if (this.theExtensions == null) {
            throw new CertificateException("There is no extensions.");
        }
        int count = this.getExtensionCount();
        try {
            for (int index = 0; index < count; ++index) {
                X509V3Extension candidate = this.getExtensionByIndex(index);
                if (candidate.getExtensionType() != extensionType) continue;
                return (X509V3Extension)candidate.clone();
            }
        }
        catch (CloneNotSupportedException cloneException) {
            throw new CertificateException("Clone Exception");
        }
        return null;
    }

    public boolean equals(Object other) {
        if (!(other instanceof X509V3Extensions)) {
            return false;
        }
        int len = this.getDERLen(0);
        if (len == 0) {
            return false;
        }
        byte[] enc = new byte[len];
        if ((len = this.getDEREncoding(enc, 0, 0)) == 0) {
            return false;
        }
        X509V3Extensions otherExt = (X509V3Extensions)other;
        int otherLen = otherExt.getDERLen(0);
        if (otherLen == 0) {
            return false;
        }
        byte[] otherEnc = new byte[len];
        otherLen = otherExt.getDEREncoding(otherEnc, 0, 0);
        if (otherLen == 0) {
            return false;
        }
        return CertJUtils.byteArraysEqual(enc, otherEnc);
    }

    public int hashCode() {
        int len = this.getDERLen(0);
        if (len == 0) {
            return 0;
        }
        byte[] enc = new byte[len];
        this.getDEREncoding(enc, 0, 0);
        return Arrays.hashCode(enc);
    }

    public Object clone() throws CloneNotSupportedException {
        try {
            X509V3Extensions otherSelf = new X509V3Extensions(this.extFlag);
            if (this.theExtensions != null) {
                otherSelf.theExtensions = new Vector();
                int count = this.theExtensions.size();
                for (int index = 0; index < count; ++index) {
                    X509V3Extension nextExtension = (X509V3Extension)this.getExtensionByIndex(index).clone();
                    otherSelf.addV3Extension(nextExtension);
                }
            }
            if (this.asn1Template != null) {
                otherSelf.getDERLen(this.special);
            }
            return otherSelf;
        }
        catch (CertificateException certException) {
            throw new CloneNotSupportedException("Wrong Extensions type.");
        }
    }

    protected void reset() {
        this.asn1Template = null;
    }
}

