/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.cert.attributes;

import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN1Template;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.BMPStringContainer;
import com.rsa.asn1.ChoiceContainer;
import com.rsa.asn1.EndContainer;
import com.rsa.asn1.IA5StringContainer;
import com.rsa.asn1.PrintStringContainer;
import com.rsa.asn1.SetContainer;
import com.rsa.asn1.TeletexStringContainer;
import com.rsa.asn1.UTF8StringContainer;
import com.rsa.asn1.UniversalStringContainer;
import com.rsa.certj.cert.AttributeException;
import com.rsa.certj.cert.attributes.X501Attribute;
import java.util.Arrays;

public class ChallengePassword
extends X501Attribute {
    private char[] thePassword;
    private int stringType;
    ASN1Template asn1TemplateValue;

    public ChallengePassword() {
        super(1, "ChallengePassword");
    }

    public ChallengePassword(char[] password, int offset, int len, int stringType) throws AttributeException {
        this();
        this.setChallengePassword(password, offset, len, stringType);
    }

    protected void decodeValue(byte[] valueBER, int offset) throws AttributeException {
        if (valueBER == null) {
            throw new AttributeException("Encoding is null.");
        }
        this.reset();
        SetContainer aSet = new SetContainer(0);
        EndContainer anEnd = new EndContainer();
        ChoiceContainer aChoice = new ChoiceContainer(0);
        try {
            PrintStringContainer pass1 = new PrintStringContainer(0);
            TeletexStringContainer pass2 = new TeletexStringContainer(0);
            UniversalStringContainer pass3 = new UniversalStringContainer(0);
            BMPStringContainer pass4 = new BMPStringContainer(0);
            UTF8StringContainer pass5 = new UTF8StringContainer(0);
            IA5StringContainer pass6 = new IA5StringContainer(0);
            ASN1Container[] asn1Def = new ASN1Container[]{aSet, aChoice, pass1, pass2, pass3, pass4, pass5, pass6, anEnd, anEnd};
            ASN1.berDecode((byte[])valueBER, (int)offset, (ASN1Container[])asn1Def);
            if (pass1.dataPresent) {
                this.stringType = 4864;
                this.thePassword = pass1.getValueAsString().toCharArray();
            } else if (pass2.dataPresent) {
                this.stringType = 5120;
                this.thePassword = pass2.getValueAsString().toCharArray();
            } else if (pass3.dataPresent) {
                this.stringType = 7168;
                this.thePassword = pass3.getValueAsString().toCharArray();
            } else if (pass4.dataPresent) {
                this.stringType = 7680;
                this.thePassword = pass4.getValueAsString().toCharArray();
            } else if (pass5.dataPresent) {
                this.stringType = 3072;
                String passString = this.utf8Decode(pass5.data, pass5.dataOffset, pass5.dataLen);
                this.thePassword = passString.toCharArray();
            } else if (pass6.dataPresent) {
                this.stringType = 5632;
                this.thePassword = pass6.getValueAsString().toCharArray();
            }
        }
        catch (ASN_Exception asnException) {
            throw new AttributeException("Could not BER decode ChallengePassword.");
        }
    }

    public void setChallengePassword(char[] password, int offset, int len, int stringType) throws AttributeException {
        if (password == null || len == 0) {
            throw new AttributeException("Password is null.");
        }
        this.thePassword = new char[len];
        System.arraycopy(password, offset, this.thePassword, 0, len);
        if (stringType != 4864 && stringType != 5120 && stringType != 7168 && stringType != 3072 && stringType != 7680 && stringType != 5632) {
            throw new AttributeException("Invalid String Type.");
        }
        this.stringType = stringType;
    }

    public char[] getChallengePassword() {
        if (this.thePassword == null) {
            return null;
        }
        char[] returnValue = new char[this.thePassword.length];
        for (int index = 0; index < this.thePassword.length; ++index) {
            returnValue[index] = (char)(this.thePassword[index] & 0xFF);
        }
        return returnValue;
    }

    protected int derEncodeValueInit() {
        this.asn1TemplateValue = null;
        if (this.thePassword == null) {
            return 0;
        }
        if (this.stringType == 0) {
            this.stringType = 3072;
        }
        try {
            TeletexStringContainer passContainer;
            EndContainer anEnd = new EndContainer();
            SetContainer aSet = new SetContainer(0, true, 0);
            ChoiceContainer aChoice = new ChoiceContainer(0, 0);
            byte[] pswd = new byte[this.thePassword.length];
            for (int index = 0; index < this.thePassword.length; ++index) {
                pswd[index] = (byte)this.thePassword[index];
            }
            switch (this.stringType) {
                case 5120: {
                    passContainer = new TeletexStringContainer(0, true, 0, pswd, 0, pswd.length);
                    break;
                }
                case 4864: {
                    passContainer = new PrintStringContainer(0, true, 0, pswd, 0, pswd.length);
                    break;
                }
                case 7168: {
                    passContainer = new UniversalStringContainer(0, true, 0, pswd, 0, pswd.length, 1);
                    break;
                }
                case 5632: {
                    passContainer = new IA5StringContainer(0, true, 0, pswd, 0, pswd.length);
                    break;
                }
                case 3072: {
                    byte[] utf8Bytes = this.utf8Encode(new String(pswd));
                    if (utf8Bytes.length < 2) {
                        return 0;
                    }
                    passContainer = new UTF8StringContainer(0, true, 0, utf8Bytes, 2, utf8Bytes.length - 2);
                    break;
                }
                case 7680: {
                    passContainer = new BMPStringContainer(0, true, 0, pswd, 0, pswd.length, 1);
                    break;
                }
                default: {
                    return 0;
                }
            }
            ASN1Container[] asn1Def = new ASN1Container[]{aSet, aChoice, passContainer, anEnd, anEnd};
            this.asn1TemplateValue = new ASN1Template(asn1Def);
            return this.asn1TemplateValue.derEncodeInit();
        }
        catch (Exception asnException) {
            return 0;
        }
    }

    protected int derEncodeValue(byte[] encoding, int offset) {
        if (encoding == null) {
            return 0;
        }
        if (this.asn1TemplateValue == null && this.derEncodeValueInit() == 0) {
            return 0;
        }
        try {
            int totalLen = this.asn1TemplateValue.derEncode(encoding, offset);
            this.asn1Template = null;
            return totalLen;
        }
        catch (ASN_Exception asnException) {
            this.asn1Template = null;
            return 0;
        }
    }

    public Object clone() throws CloneNotSupportedException {
        ChallengePassword otherSelf = new ChallengePassword();
        if (this.thePassword != null) {
            otherSelf.thePassword = (char[])this.thePassword.clone();
        }
        otherSelf.stringType = this.stringType;
        super.copyValues(otherSelf);
        return otherSelf;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof ChallengePassword)) {
            return false;
        }
        ChallengePassword other = (ChallengePassword)obj;
        if (this.thePassword != null) {
            if (other.thePassword == null) return false;
            if (this.thePassword.length != other.thePassword.length) {
                return false;
            }
            for (int index = 0; index < this.thePassword.length; ++index) {
                if (this.thePassword[index] == other.thePassword[index]) continue;
                return false;
            }
            return true;
        } else {
            if (other.thePassword == null) return true;
            return false;
        }
    }

    public int hashCode() {
        int hashcode = 0;
        if (this.thePassword != null) {
            hashcode ^= Arrays.hashCode(this.thePassword);
        }
        return hashcode;
    }

    protected void reset() {
        super.reset();
        this.asn1TemplateValue = null;
        if (this.thePassword != null) {
            for (int index = 0; index < this.thePassword.length; ++index) {
                this.thePassword[index] = '\u0000';
            }
            this.thePassword = null;
        }
    }

    protected void finalize() {
        this.reset();
    }
}

