/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.cert.attributes;

import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN1Template;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.EndContainer;
import com.rsa.asn1.PrintStringContainer;
import com.rsa.asn1.SetContainer;
import com.rsa.certj.CertJInternalHelper;
import com.rsa.certj.cert.AttributeException;
import com.rsa.certj.cert.attributes.X501Attribute;

public class CountryOfCitizenship
extends X501Attribute {
    private String country = "";
    ASN1Template asn1TemplateValue;

    public CountryOfCitizenship() {
        super(21, "countryOfCitizenship");
    }

    public CountryOfCitizenship(String country) throws AttributeException {
        this();
        this.setCountry(country);
    }

    protected void decodeValue(byte[] valueBER, int offset) throws AttributeException {
        if (valueBER == null) {
            throw new AttributeException("Encoding is null.");
        }
        this.reset();
        try {
            SetContainer aSet = new SetContainer(0);
            EndContainer anEnd = new EndContainer();
            PrintStringContainer theCountry = new PrintStringContainer(0);
            ASN1Container[] asn1Def = new ASN1Container[]{aSet, theCountry, anEnd};
            ASN1.berDecode((byte[])valueBER, (int)offset, (ASN1Container[])asn1Def);
            this.country = theCountry.getValueAsString();
        }
        catch (ASN_Exception asnException) {
            throw new AttributeException("Could not BER decode CountryOfCitizenship.");
        }
    }

    public void setCountry(String theCountry) throws AttributeException {
        if (theCountry != null) {
            if (theCountry.length() != 2) {
                throw new AttributeException("Country of Citizenship should be 2 characters long.");
            }
            this.reset();
            this.country = theCountry;
        }
    }

    public String getCountry() {
        return this.country;
    }

    protected int derEncodeValueInit() {
        this.asn1TemplateValue = null;
        if (this.country == null) {
            return 0;
        }
        try {
            SetContainer aSet = new SetContainer(0, true, 0);
            PrintStringContainer print = new PrintStringContainer(0, true, 0, this.country, 2, 2);
            EndContainer anEnd = new EndContainer();
            ASN1Container[] asn1Def = new ASN1Container[]{aSet, print, anEnd};
            this.asn1TemplateValue = new ASN1Template(asn1Def);
            return this.asn1TemplateValue.derEncodeInit();
        }
        catch (ASN_Exception asnException) {
            return 0;
        }
    }

    protected int derEncodeValue(byte[] encoding, int offset) {
        if (encoding == null) {
            return 0;
        }
        if (this.asn1TemplateValue == null && this.derEncodeValueInit() == 0) {
            return 0;
        }
        try {
            int totalLen = this.asn1TemplateValue.derEncode(encoding, offset);
            this.asn1Template = null;
            return totalLen;
        }
        catch (ASN_Exception asnException) {
            this.asn1Template = null;
            return 0;
        }
    }

    public Object clone() throws CloneNotSupportedException {
        CountryOfCitizenship otherSelf = new CountryOfCitizenship();
        if (this.country != null) {
            otherSelf.country = this.country;
        }
        super.copyValues(otherSelf);
        return otherSelf;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof CountryOfCitizenship)) {
            return false;
        }
        CountryOfCitizenship other = (CountryOfCitizenship)obj;
        return this.country.equalsIgnoreCase(other.country);
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = prime * result + CertJInternalHelper.hashCodeValue(this.country);
        return result;
    }

    protected void reset() {
        super.reset();
        this.country = null;
        this.asn1TemplateValue = null;
    }
}

