/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.cert.attributes;

import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN1Template;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.EndContainer;
import com.rsa.asn1.IntegerContainer;
import com.rsa.asn1.PrintStringContainer;
import com.rsa.asn1.SetContainer;
import com.rsa.certj.CertJ;
import com.rsa.certj.CompatibilityType;
import com.rsa.certj.cert.AttributeException;
import com.rsa.certj.cert.attributes.X501Attribute;

abstract class IntegerPrintableStringAttr
extends X501Attribute {
    protected int value = -1;
    private ASN1Template asn1TemplateValue;

    protected IntegerPrintableStringAttr(int attrId, String attrName) {
        super(attrId, attrName);
    }

    protected void decodeValue(byte[] valueBER, int offset) throws AttributeException {
        block5: {
            if (valueBER == null) {
                throw new AttributeException("Encoding is null.");
            }
            this.reset();
            try {
                SetContainer aSet = new SetContainer(0);
                EndContainer anEnd = new EndContainer();
                IntegerContainer intVal = new IntegerContainer(65536);
                PrintStringContainer prtVal = new PrintStringContainer(65536);
                ASN1Container[] asn1Def = new ASN1Container[]{aSet, intVal, prtVal, anEnd};
                ASN1.berDecode((byte[])valueBER, (int)offset, (ASN1Container[])asn1Def);
                if (intVal.dataPresent) {
                    this.value = intVal.getValueAsInt();
                    break block5;
                }
                if (prtVal.dataPresent) {
                    String strVal = prtVal.getValueAsString();
                    this.value = Integer.parseInt(strVal);
                    break block5;
                }
                throw new AttributeException("Unexpected encoding.");
            }
            catch (Exception anyException) {
                throw new AttributeException("Could not BER decode attribute.");
            }
        }
    }

    protected void setValue(int val) {
        this.reset();
        if (val >= 0) {
            this.value = val;
        }
    }

    protected int getValue() {
        return this.value;
    }

    protected int derEncodeValueInit() {
        this.asn1TemplateValue = null;
        if (this.value == -1) {
            return 0;
        }
        SetContainer aSet = new SetContainer(0, true, 0);
        EndContainer anEnd = new EndContainer();
        ASN1Container[] asn1Def = new ASN1Container[3];
        asn1Def[0] = aSet;
        asn1Def[2] = anEnd;
        try {
            if (CertJ.isCompatibilityTypeSet(CompatibilityType.CERTJ_COMPATIBILITY_SCEP)) {
                String strVal = Integer.toString(this.value);
                PrintStringContainer scepVal = new PrintStringContainer(0, true, 0, strVal);
                asn1Def[1] = scepVal;
            } else {
                IntegerContainer crsVal = new IntegerContainer(0, true, 0, this.value);
                asn1Def[1] = crsVal;
            }
            this.asn1TemplateValue = new ASN1Template(asn1Def);
            return this.asn1TemplateValue.derEncodeInit();
        }
        catch (ASN_Exception asnException) {
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int derEncodeValue(byte[] encoding, int offset) {
        if (encoding == null) {
            return 0;
        }
        if (this.asn1TemplateValue == null && this.derEncodeValueInit() == 0) {
            return 0;
        }
        try {
            int totalLen;
            int n = totalLen = this.asn1TemplateValue.derEncode(encoding, offset);
            return n;
        }
        catch (ASN_Exception asnException) {
            int n = 0;
            return n;
        }
        finally {
            this.asn1Template = null;
        }
    }

    protected void copyValues(IntegerPrintableStringAttr otherSelf) {
        otherSelf.value = this.value;
        super.copyValues(otherSelf);
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof IntegerPrintableStringAttr)) {
            return false;
        }
        IntegerPrintableStringAttr other = (IntegerPrintableStringAttr)obj;
        return other.value == this.value;
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = prime * result + this.value;
        return result;
    }

    protected void reset() {
        super.reset();
        this.value = -1;
        this.asn1TemplateValue = null;
    }
}

