/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.cert.attributes;

import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN1Template;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.EndContainer;
import com.rsa.asn1.OctetStringContainer;
import com.rsa.asn1.SetContainer;
import com.rsa.certj.CertJUtils;
import com.rsa.certj.cert.AttributeException;
import com.rsa.certj.cert.attributes.X501Attribute;
import java.util.Arrays;

public class MessageDigest
extends X501Attribute {
    private byte[] digest;
    ASN1Template asn1TemplateValue;

    public MessageDigest() {
        super(15, "MessageDigest");
    }

    public MessageDigest(byte[] digest, int offset, int len) {
        this();
        this.setMessageDigest(digest, offset, len);
    }

    protected void decodeValue(byte[] valueBER, int offset) throws AttributeException {
        if (valueBER == null) {
            throw new AttributeException("Encoding is null.");
        }
        this.reset();
        SetContainer aSet = new SetContainer(0);
        EndContainer anEnd = new EndContainer();
        OctetStringContainer theDigest = new OctetStringContainer(0);
        ASN1Container[] asn1Def = new ASN1Container[]{aSet, theDigest, anEnd};
        try {
            ASN1.berDecode((byte[])valueBER, (int)offset, (ASN1Container[])asn1Def);
        }
        catch (ASN_Exception asnException) {
            throw new AttributeException("Could not BER decode MessageDigest.");
        }
        if (theDigest.dataLen != 0) {
            this.digest = new byte[theDigest.dataLen];
            System.arraycopy(theDigest.data, theDigest.dataOffset, this.digest, 0, theDigest.dataLen);
        }
    }

    public byte[] getMessageDigest() {
        if (this.digest == null) {
            return null;
        }
        byte[] returnValue = new byte[this.digest.length];
        System.arraycopy(this.digest, 0, returnValue, 0, this.digest.length);
        return returnValue;
    }

    public void setMessageDigest(byte[] digest, int offset, int len) {
        if (digest != null && len != 0) {
            this.digest = new byte[len];
            System.arraycopy(digest, offset, this.digest, 0, len);
        }
    }

    protected int derEncodeValueInit() {
        this.asn1TemplateValue = null;
        int digestLen = 0;
        if (this.digest != null) {
            digestLen = this.digest.length;
        }
        try {
            EndContainer anEnd = new EndContainer();
            SetContainer aSet = new SetContainer(0, true, 0);
            OctetStringContainer octet = new OctetStringContainer(0, true, 0, this.digest, 0, digestLen);
            ASN1Container[] asn1Def = new ASN1Container[]{aSet, octet, anEnd};
            this.asn1TemplateValue = new ASN1Template(asn1Def);
            return this.asn1TemplateValue.derEncodeInit();
        }
        catch (ASN_Exception asnException) {
            return 0;
        }
    }

    protected int derEncodeValue(byte[] encoding, int offset) {
        if (encoding == null) {
            return 0;
        }
        if (this.asn1TemplateValue == null && this.derEncodeValueInit() == 0) {
            return 0;
        }
        int totalLen = 0;
        try {
            totalLen = this.asn1TemplateValue.derEncode(encoding, offset);
            this.asn1Template = null;
            return totalLen;
        }
        catch (ASN_Exception asnException) {
            this.asn1Template = null;
            return 0;
        }
    }

    public Object clone() throws CloneNotSupportedException {
        MessageDigest otherSelf = new MessageDigest();
        if (this.digest != null) {
            otherSelf.digest = (byte[])this.digest.clone();
        }
        super.copyValues(otherSelf);
        return otherSelf;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof MessageDigest)) {
            return false;
        }
        MessageDigest other = (MessageDigest)obj;
        return CertJUtils.byteArraysEqual(other.digest, this.digest);
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = prime * result + Arrays.hashCode(this.digest);
        return result;
    }

    protected void reset() {
        super.reset();
        this.asn1TemplateValue = null;
        if (this.digest != null) {
            for (int index = 0; index < this.digest.length; ++index) {
                this.digest[index] = 0;
            }
            this.digest = null;
        }
    }
}

