/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.cert.attributes;

import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN1Template;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.EncodedContainer;
import com.rsa.asn1.EndContainer;
import com.rsa.asn1.OfContainer;
import com.rsa.asn1.SetContainer;
import com.rsa.certj.CertJUtils;
import com.rsa.certj.cert.AttributeException;
import com.rsa.certj.cert.attributes.X501Attribute;
import java.util.Arrays;

public class NonStandardAttribute
extends X501Attribute {
    private byte[] valueDER;
    ASN1Template asn1TemplateValue;

    public NonStandardAttribute() {
        super(23, "NonStandardAttribute");
    }

    public NonStandardAttribute(byte[] oid, int oidOffset, int oidLen, byte[] valueDER, int valueOffset, int valueLen) {
        this();
        this.setOID(oid, oidOffset, oidLen);
        this.setValue(valueDER, valueOffset, valueLen);
    }

    protected void decodeValue(byte[] valueBER, int offset) throws AttributeException {
        if (valueBER == null) {
            throw new AttributeException("Encoding is null.");
        }
        this.reset();
        try {
            OfContainer setOf = new OfContainer(0, 12544, (ASN1Container)new EncodedContainer(65280));
            ASN1Container[] asn1Def = new ASN1Container[]{setOf};
            ASN1.berDecode((byte[])valueBER, (int)offset, (ASN1Container[])asn1Def);
            if (setOf.getContainerCount() == 0) {
                this.valueDER = new byte[0];
                return;
            }
            EncodedContainer theValue = (EncodedContainer)setOf.containerAt(0);
            this.valueDER = new byte[theValue.dataLen];
            System.arraycopy(theValue.data, theValue.dataOffset, this.valueDER, 0, theValue.dataLen);
        }
        catch (ASN_Exception asnException) {
            throw new AttributeException("Could not BER decode the non-standard attribute.");
        }
    }

    public void setOID(byte[] oid, int oidOffset, int oidLen) {
        if (oid != null && oidLen != 0) {
            this.theOID = new byte[oidLen];
            System.arraycopy(oid, oidOffset, this.theOID, 0, oidLen);
        }
    }

    public void setValue(byte[] valueDER, int valueOffset, int valueLen) {
        if (valueDER != null && valueLen != 0) {
            this.valueDER = new byte[valueLen];
            System.arraycopy(valueDER, valueOffset, this.valueDER, 0, valueLen);
        }
    }

    public byte[] getValue() {
        if (this.valueDER == null) {
            return null;
        }
        return (byte[])this.valueDER.clone();
    }

    protected int derEncodeValueInit() {
        this.asn1TemplateValue = null;
        if (this.valueDER == null || this.theOID == null) {
            return 0;
        }
        try {
            EndContainer anEnd = new EndContainer();
            SetContainer aSet = new SetContainer(0, true, 0);
            EncodedContainer theValue = new EncodedContainer(65280, true, 0, this.valueDER, 0, this.valueDER.length);
            ASN1Container[] asn1Def = new ASN1Container[]{aSet, theValue, anEnd};
            this.asn1TemplateValue = new ASN1Template(asn1Def);
            return this.asn1TemplateValue.derEncodeInit();
        }
        catch (ASN_Exception asnException) {
            return 0;
        }
    }

    protected int derEncodeValue(byte[] encoding, int offset) {
        if (encoding == null) {
            return 0;
        }
        if (this.asn1TemplateValue == null && this.derEncodeValueInit() == 0) {
            return 0;
        }
        int totalLen = 0;
        try {
            totalLen = this.asn1TemplateValue.derEncode(encoding, offset);
            this.asn1Template = null;
            return totalLen;
        }
        catch (ASN_Exception asnException) {
            this.asn1TemplateValue = null;
            return 0;
        }
    }

    public Object clone() throws CloneNotSupportedException {
        NonStandardAttribute otherSelf = new NonStandardAttribute();
        if (this.valueDER != null) {
            otherSelf.valueDER = (byte[])this.valueDER.clone();
        }
        if (this.theOID != null) {
            otherSelf.theOID = (byte[])this.theOID.clone();
        }
        super.copyValues(otherSelf);
        return otherSelf;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof NonStandardAttribute)) {
            return false;
        }
        NonStandardAttribute other = (NonStandardAttribute)obj;
        if (!CertJUtils.byteArraysEqual(other.valueDER, this.valueDER)) {
            return false;
        }
        return CertJUtils.byteArraysEqual(other.theOID, this.theOID);
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = prime * result + Arrays.hashCode(this.valueDER);
        result = prime * result + Arrays.hashCode(this.theOID);
        return result;
    }

    protected void reset() {
        super.reset();
        this.valueDER = null;
        this.asn1TemplateValue = null;
    }
}

