/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.cert.attributes;

import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN1Template;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.BMPStringContainer;
import com.rsa.asn1.ChoiceContainer;
import com.rsa.asn1.EncodedContainer;
import com.rsa.asn1.EndContainer;
import com.rsa.asn1.IA5StringContainer;
import com.rsa.asn1.OfContainer;
import com.rsa.asn1.PrintStringContainer;
import com.rsa.asn1.SetContainer;
import com.rsa.asn1.TeletexStringContainer;
import com.rsa.asn1.UTF8StringContainer;
import com.rsa.asn1.UniversalStringContainer;
import com.rsa.certj.CertJInternalHelper;
import com.rsa.certj.cert.AttributeException;
import com.rsa.certj.cert.attributes.X501Attribute;
import java.util.Vector;

public class PostalAddress
extends X501Attribute {
    private Vector<String> postalAddress = new Vector();
    private Vector<Integer> stringType = new Vector();
    ASN1Template asn1TemplateValue;

    public PostalAddress() {
        super(16, "postalAddress");
    }

    public PostalAddress(String postalAddress, int stringType) throws AttributeException {
        this();
        this.addPostalAddress(postalAddress, stringType);
    }

    protected void decodeValue(byte[] valueBER, int offset) throws AttributeException {
        if (valueBER == null) {
            throw new AttributeException("Encoding is null.");
        }
        this.reset();
        try {
            SetContainer aSet = new SetContainer(0);
            EndContainer anEnd = new EndContainer();
            EncodedContainer anEnc = new EncodedContainer(12288);
            ASN1Container[] asn1Def = new ASN1Container[]{aSet, anEnc, anEnd};
            ASN1.berDecode((byte[])valueBER, (int)offset, (ASN1Container[])asn1Def);
            OfContainer seqOf = new OfContainer(0, 12288, (ASN1Container)new EncodedContainer(65280));
            ASN1Container[] asnDef = new ASN1Container[]{seqOf};
            ASN1.berDecode((byte[])anEnc.data, (int)anEnc.dataOffset, (ASN1Container[])asnDef);
            for (int index = 0; index < seqOf.getContainerCount(); ++index) {
                EncodedContainer value = (EncodedContainer)seqOf.containerAt(index);
                ChoiceContainer choiceContainer = new ChoiceContainer(0);
                PrintStringContainer printStringContainer = new PrintStringContainer(0, 1, -1);
                TeletexStringContainer teletexStringContainer = new TeletexStringContainer(0, 1, -1);
                UniversalStringContainer universalStringContainer = new UniversalStringContainer(0, 1, -1);
                BMPStringContainer bmpStringContainer = new BMPStringContainer(0, 1, -1);
                UTF8StringContainer utf8StringContainer = new UTF8StringContainer(0);
                IA5StringContainer ia5StringContainer = new IA5StringContainer(0, 1, -1);
                ASN1Container[] asn1Array = new ASN1Container[]{choiceContainer, printStringContainer, teletexStringContainer, universalStringContainer, bmpStringContainer, utf8StringContainer, ia5StringContainer, anEnd};
                ASN1.berDecode((byte[])value.data, (int)value.dataOffset, (ASN1Container[])asn1Array);
                if (printStringContainer.dataPresent) {
                    this.stringType.addElement(new Integer(4864));
                    this.postalAddress.addElement(printStringContainer.getValueAsString());
                    continue;
                }
                if (teletexStringContainer.dataPresent) {
                    this.stringType.addElement(new Integer(5120));
                    this.postalAddress.addElement(teletexStringContainer.getValueAsString());
                    continue;
                }
                if (universalStringContainer.dataPresent) {
                    this.stringType.addElement(new Integer(7168));
                    this.postalAddress.addElement(universalStringContainer.getValueAsString());
                    continue;
                }
                if (bmpStringContainer.dataPresent) {
                    this.stringType.addElement(new Integer(7680));
                    this.postalAddress.addElement(bmpStringContainer.getValueAsString());
                    continue;
                }
                if (utf8StringContainer.dataPresent) {
                    this.stringType.addElement(new Integer(3072));
                    this.postalAddress.addElement(this.utf8Decode(utf8StringContainer.data, utf8StringContainer.dataOffset, utf8StringContainer.dataLen));
                    continue;
                }
                if (ia5StringContainer.dataPresent) {
                    this.stringType.addElement(new Integer(5632));
                    this.postalAddress.addElement(ia5StringContainer.getValueAsString());
                    continue;
                }
                throw new AttributeException("DirectoryString expected.");
            }
        }
        catch (ASN_Exception asnException) {
            throw new AttributeException("Could not BER decode postalAddress.", (Exception)((Object)asnException));
        }
    }

    public void addPostalAddress(String postalAddress, int stringType) throws AttributeException {
        if (postalAddress == null) {
            throw new AttributeException("PostalAddress is null.");
        }
        if (stringType != 4864 && stringType != 5120 && stringType != 7168 && stringType != 3072 && stringType != 7680 && stringType != 5632) {
            throw new AttributeException("Invalid String Type.");
        }
        this.postalAddress.addElement(postalAddress);
        this.stringType.addElement(new Integer(stringType));
    }

    public String[] getPostalAddress() {
        String[] returnValue = new String[this.postalAddress.size()];
        for (int index = 0; index < returnValue.length; ++index) {
            returnValue[index] = this.postalAddress.elementAt(index);
        }
        return returnValue;
    }

    protected int derEncodeValueInit() {
        this.asn1TemplateValue = null;
        if (this.postalAddress == null) {
            return 0;
        }
        try {
            OfContainer seqOf = new OfContainer(0, true, 0, 12288, (ASN1Container)new EncodedContainer(65280));
            EndContainer anEnd = new EndContainer();
            SetContainer aSet = new SetContainer(0, true, 0);
            ChoiceContainer choice = new ChoiceContainer(0);
            for (int index = 0; index < this.postalAddress.size(); ++index) {
                TeletexStringContainer passContainer;
                int type = this.stringType.elementAt(index);
                if (type == 0) {
                    type = 3072;
                }
                switch (type) {
                    case 5120: {
                        passContainer = new TeletexStringContainer(0, true, 0, this.postalAddress.elementAt(index));
                        break;
                    }
                    case 4864: {
                        passContainer = new PrintStringContainer(0, true, 0, this.postalAddress.elementAt(index));
                        break;
                    }
                    case 7168: {
                        passContainer = new UniversalStringContainer(0, true, 0, this.postalAddress.elementAt(index));
                        break;
                    }
                    case 5632: {
                        passContainer = new IA5StringContainer(0, true, 0, this.postalAddress.elementAt(index));
                        break;
                    }
                    case 3072: {
                        byte[] utf8Bytes = this.utf8Encode(this.postalAddress.elementAt(index));
                        if (utf8Bytes.length < 2) {
                            return 0;
                        }
                        passContainer = new UTF8StringContainer(0, true, 0, utf8Bytes, 2, utf8Bytes.length - 2);
                        break;
                    }
                    case 7680: {
                        passContainer = new BMPStringContainer(0, true, 0, this.postalAddress.elementAt(index));
                        break;
                    }
                    default: {
                        return 0;
                    }
                }
                ASN1Container[] asnDef = new ASN1Container[]{choice, passContainer, anEnd};
                ASN1Template asn1Value = new ASN1Template(asnDef);
                byte[] encoding = new byte[asn1Value.derEncodeInit()];
                int len = asn1Value.derEncode(encoding, 0);
                EncodedContainer encContainer = new EncodedContainer(0, true, 0, encoding, 0, len);
                seqOf.addContainer((ASN1Container)encContainer);
            }
            ASN1Container[] asn1Def = new ASN1Container[]{aSet, seqOf, anEnd};
            this.asn1TemplateValue = new ASN1Template(asn1Def);
            return this.asn1TemplateValue.derEncodeInit();
        }
        catch (Exception asnException) {
            return 0;
        }
    }

    protected int derEncodeValue(byte[] encoding, int offset) {
        if (encoding == null) {
            return 0;
        }
        if (this.asn1TemplateValue == null && this.derEncodeValueInit() == 0) {
            return 0;
        }
        try {
            int totalLen = this.asn1TemplateValue.derEncode(encoding, offset);
            this.asn1Template = null;
            return totalLen;
        }
        catch (ASN_Exception asnException) {
            this.asn1Template = null;
            return 0;
        }
    }

    public Object clone() throws CloneNotSupportedException {
        PostalAddress otherSelf = new PostalAddress();
        for (int index = 0; index < this.postalAddress.size(); ++index) {
            otherSelf.postalAddress.addElement(this.postalAddress.elementAt(index));
            otherSelf.stringType.addElement(this.stringType.elementAt(index));
        }
        super.copyValues(otherSelf);
        return otherSelf;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof PostalAddress)) {
            return false;
        }
        PostalAddress other = (PostalAddress)obj;
        if (this.postalAddress.size() != other.postalAddress.size()) {
            return false;
        }
        for (int index = 0; index < this.postalAddress.size(); ++index) {
            if (!this.postalAddress.elementAt(index).equals(other.postalAddress.elementAt(index))) {
                return false;
            }
            if (this.stringType.elementAt(index).equals(other.stringType.elementAt(index))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = prime * result + CertJInternalHelper.hashCodeValue(this.postalAddress);
        result = prime * result + CertJInternalHelper.hashCodeValue(this.stringType);
        return result;
    }

    protected void reset() {
        super.reset();
        this.postalAddress = new Vector();
        this.stringType = new Vector();
        this.asn1TemplateValue = null;
    }
}

