/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.cert.attributes;

import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN1Template;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.BMPStringContainer;
import com.rsa.asn1.ChoiceContainer;
import com.rsa.asn1.EndContainer;
import com.rsa.asn1.IA5StringContainer;
import com.rsa.asn1.PrintStringContainer;
import com.rsa.asn1.SetContainer;
import com.rsa.asn1.TeletexStringContainer;
import com.rsa.asn1.UTF8StringContainer;
import com.rsa.asn1.UniversalStringContainer;
import com.rsa.certj.CertJInternalHelper;
import com.rsa.certj.cert.AttributeException;
import com.rsa.certj.cert.attributes.X501Attribute;

public class Pseudonym
extends X501Attribute {
    private String pseudonym;
    private int stringType;
    ASN1Template asn1TemplateValue;

    public Pseudonym() {
        super(17, "pseudonym");
    }

    public Pseudonym(String pseudonym, int stringType) throws AttributeException {
        this();
        this.setPseudonym(pseudonym, stringType);
    }

    protected void decodeValue(byte[] valueBER, int offset) throws AttributeException {
        block9: {
            if (valueBER == null) {
                throw new AttributeException("Encoding is null.");
            }
            this.reset();
            try {
                SetContainer aSet = new SetContainer(0);
                EndContainer anEnd = new EndContainer();
                ChoiceContainer choiceContainer = new ChoiceContainer(0);
                PrintStringContainer printStringContainer = new PrintStringContainer(0, 1, -1);
                TeletexStringContainer teletexStringContainer = new TeletexStringContainer(0, 1, -1);
                UniversalStringContainer universalStringContainer = new UniversalStringContainer(0, 1, -1);
                BMPStringContainer bmpStringContainer = new BMPStringContainer(0, 1, -1);
                UTF8StringContainer utf8StringContainer = new UTF8StringContainer(0);
                IA5StringContainer ia5StringContainer = new IA5StringContainer(0, 1, -1);
                ASN1Container[] asn1Def = new ASN1Container[]{aSet, choiceContainer, printStringContainer, teletexStringContainer, universalStringContainer, bmpStringContainer, utf8StringContainer, ia5StringContainer, anEnd, anEnd};
                ASN1.berDecode((byte[])valueBER, (int)offset, (ASN1Container[])asn1Def);
                if (printStringContainer.dataPresent) {
                    this.stringType = 4864;
                    this.pseudonym = printStringContainer.getValueAsString();
                    break block9;
                }
                if (teletexStringContainer.dataPresent) {
                    this.stringType = 5120;
                    this.pseudonym = teletexStringContainer.getValueAsString();
                    break block9;
                }
                if (universalStringContainer.dataPresent) {
                    this.stringType = 7168;
                    this.pseudonym = universalStringContainer.getValueAsString();
                    break block9;
                }
                if (bmpStringContainer.dataPresent) {
                    this.stringType = 7680;
                    this.pseudonym = bmpStringContainer.getValueAsString();
                    break block9;
                }
                if (utf8StringContainer.dataPresent) {
                    this.stringType = 3072;
                    this.pseudonym = this.utf8Decode(utf8StringContainer.data, utf8StringContainer.dataOffset, utf8StringContainer.dataLen);
                    break block9;
                }
                if (ia5StringContainer.dataPresent) {
                    this.stringType = 5632;
                    this.pseudonym = ia5StringContainer.getValueAsString();
                    break block9;
                }
                throw new AttributeException("DirectoryString expected.");
            }
            catch (ASN_Exception asnException) {
                throw new AttributeException("Could not BER decode Pseudonym.", (Exception)((Object)asnException));
            }
        }
    }

    public void setPseudonym(String pseudonym, int stringType) throws AttributeException {
        if (pseudonym == null) {
            throw new AttributeException("Pseudonym is null.");
        }
        this.reset();
        this.pseudonym = pseudonym;
        if (stringType != 4864 && stringType != 5120 && stringType != 7168 && stringType != 3072 && stringType != 7680 && stringType != 5632) {
            throw new AttributeException("Invalid String Type.");
        }
        this.stringType = stringType;
    }

    public String getPseudonym() {
        return this.pseudonym;
    }

    protected int derEncodeValueInit() {
        this.asn1TemplateValue = null;
        if (this.pseudonym == null) {
            return 0;
        }
        if (this.stringType == 0) {
            this.stringType = 3072;
        }
        try {
            TeletexStringContainer passContainer;
            EndContainer anEnd = new EndContainer();
            SetContainer aSet = new SetContainer(0, true, 0);
            ChoiceContainer aChoice = new ChoiceContainer(0, 0);
            switch (this.stringType) {
                case 5120: {
                    passContainer = new TeletexStringContainer(0, true, 0, this.pseudonym);
                    break;
                }
                case 4864: {
                    passContainer = new PrintStringContainer(0, true, 0, this.pseudonym);
                    break;
                }
                case 7168: {
                    passContainer = new UniversalStringContainer(0, true, 0, this.pseudonym);
                    break;
                }
                case 5632: {
                    passContainer = new IA5StringContainer(0, true, 0, this.pseudonym);
                    break;
                }
                case 3072: {
                    byte[] utf8Bytes = this.utf8Encode(this.pseudonym);
                    if (utf8Bytes.length < 2) {
                        return 0;
                    }
                    passContainer = new UTF8StringContainer(0, true, 0, utf8Bytes, 2, utf8Bytes.length - 2);
                    break;
                }
                case 7680: {
                    passContainer = new BMPStringContainer(0, true, 0, this.pseudonym);
                    break;
                }
                default: {
                    return 0;
                }
            }
            ASN1Container[] asn1Def = new ASN1Container[]{aSet, aChoice, passContainer, anEnd, anEnd};
            this.asn1TemplateValue = new ASN1Template(asn1Def);
            return this.asn1TemplateValue.derEncodeInit();
        }
        catch (Exception asnException) {
            return 0;
        }
    }

    protected int derEncodeValue(byte[] encoding, int offset) {
        if (encoding == null) {
            return 0;
        }
        if (this.asn1TemplateValue == null && this.derEncodeValueInit() == 0) {
            return 0;
        }
        try {
            int totalLen = this.asn1TemplateValue.derEncode(encoding, offset);
            this.asn1Template = null;
            return totalLen;
        }
        catch (ASN_Exception asnException) {
            this.asn1Template = null;
            return 0;
        }
    }

    public Object clone() throws CloneNotSupportedException {
        Pseudonym otherSelf = new Pseudonym();
        if (this.pseudonym != null) {
            otherSelf.pseudonym = this.pseudonym;
        }
        otherSelf.stringType = this.stringType;
        super.copyValues(otherSelf);
        return otherSelf;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof Pseudonym)) {
            return false;
        }
        Pseudonym other = (Pseudonym)obj;
        if (this.pseudonym == null) {
            return other.pseudonym == null;
        }
        if (other.pseudonym == null) {
            return false;
        }
        return this.pseudonym.equals(other.pseudonym);
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = prime * result + CertJInternalHelper.hashCodeValue(this.pseudonym);
        return result;
    }

    protected void reset() {
        super.reset();
        this.pseudonym = null;
        this.asn1TemplateValue = null;
    }
}

