/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.cert.attributes;

import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN1Template;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.EndContainer;
import com.rsa.asn1.IntegerContainer;
import com.rsa.asn1.PrintStringContainer;
import com.rsa.asn1.SetContainer;
import com.rsa.certj.CertJ;
import com.rsa.certj.CertJUtils;
import com.rsa.certj.CompatibilityType;
import com.rsa.certj.cert.AttributeException;
import com.rsa.certj.cert.attributes.X501Attribute;
import java.math.BigInteger;
import java.util.Arrays;

public class VeriSignCRSTransactionID
extends X501Attribute {
    private byte[] id;
    private String idString;
    ASN1Template asn1TemplateValue;

    public VeriSignCRSTransactionID() {
        super(11, "VeriSignCRSTransactionID");
    }

    public VeriSignCRSTransactionID(byte[] id, int offset, int len) {
        this();
        this.setTransactionID(id, offset, len);
    }

    private String byteArrayToString(byte[] arr) {
        BigInteger bigInt = new BigInteger(arr);
        return bigInt.toString();
    }

    private byte[] stringToByteArray(String str) {
        try {
            BigInteger bigInt = new BigInteger(str, 10);
            return bigInt.toByteArray();
        }
        catch (NumberFormatException e) {
            if (!CertJ.isCompatibilityTypeSet(CompatibilityType.CERTJ_COMPATIBILITY_SCEP)) {
                throw e;
            }
            return null;
        }
    }

    protected void decodeValue(byte[] valueBER, int offset) throws AttributeException {
        block6: {
            if (valueBER == null) {
                throw new AttributeException("Encoding is null.");
            }
            this.reset();
            try {
                SetContainer aSet = new SetContainer(0);
                EndContainer anEnd = new EndContainer();
                IntegerContainer intVal = new IntegerContainer(65536);
                PrintStringContainer prtVal = new PrintStringContainer(65536);
                ASN1Container[] asn1Def = new ASN1Container[]{aSet, intVal, prtVal, anEnd};
                ASN1.berDecode((byte[])valueBER, (int)offset, (ASN1Container[])asn1Def);
                if (intVal.dataPresent) {
                    if (intVal.dataLen > 0) {
                        this.id = new byte[intVal.dataLen];
                        System.arraycopy(intVal.data, intVal.dataOffset, this.id, 0, intVal.dataLen);
                        this.idString = this.byteArrayToString(this.id);
                    }
                    break block6;
                }
                if (prtVal.dataPresent) {
                    String strVal = prtVal.getValueAsString();
                    byte[] b = new byte[prtVal.dataLen];
                    System.arraycopy(prtVal.data, prtVal.dataOffset, b, 0, prtVal.dataLen);
                    this.id = this.stringToByteArray(strVal);
                    this.idString = strVal;
                    break block6;
                }
                throw new AttributeException("Unexpected encoding.");
            }
            catch (ASN_Exception asnException) {
                throw new AttributeException("Could not BER decode VeriSignCRSTransactionID.");
            }
        }
    }

    public void setTransactionID(byte[] id, int offset, int len) {
        this.reset();
        if (id != null && len != 0) {
            this.id = new byte[len];
            System.arraycopy(id, offset, this.id, 0, len);
            this.idString = this.byteArrayToString(this.id);
        }
    }

    public byte[] getTransactionID() {
        if (this.id == null) {
            return null;
        }
        return (byte[])this.id.clone();
    }

    public void setTransactionIDString(String idString) {
        this.reset();
        if (idString != null) {
            this.id = this.stringToByteArray(idString);
            this.idString = idString;
        }
    }

    public String getTransactionIDString() {
        return this.idString;
    }

    protected int derEncodeValueInit() {
        this.asn1TemplateValue = null;
        SetContainer aSet = new SetContainer(0, true, 0);
        EndContainer anEnd = new EndContainer();
        ASN1Container[] asn1Def = new ASN1Container[3];
        asn1Def[0] = aSet;
        asn1Def[2] = anEnd;
        try {
            if (CertJ.isCompatibilityTypeSet(CompatibilityType.CERTJ_COMPATIBILITY_SCEP)) {
                String strVal = this.idString == null || this.idString.length() == 0 ? "0" : this.idString;
                PrintStringContainer scepVal = new PrintStringContainer(0, true, 0, strVal);
                asn1Def[1] = scepVal;
            } else {
                int idLen = 0;
                if (this.id != null) {
                    idLen = this.id.length;
                }
                IntegerContainer crsVal = new IntegerContainer(0, true, 0, this.id, 0, idLen, true);
                asn1Def[1] = crsVal;
            }
            this.asn1TemplateValue = new ASN1Template(asn1Def);
            return this.asn1TemplateValue.derEncodeInit();
        }
        catch (ASN_Exception asnException) {
            return 0;
        }
    }

    protected int derEncodeValue(byte[] encoding, int offset) {
        if (encoding == null) {
            return 0;
        }
        if (this.asn1TemplateValue == null && this.derEncodeValueInit() == 0) {
            return 0;
        }
        try {
            int totalLen = this.asn1TemplateValue.derEncode(encoding, offset);
            this.asn1Template = null;
            return totalLen;
        }
        catch (ASN_Exception asnException) {
            this.asn1Template = null;
            return 0;
        }
    }

    public Object clone() throws CloneNotSupportedException {
        VeriSignCRSTransactionID otherSelf = new VeriSignCRSTransactionID();
        if (this.id != null) {
            otherSelf.id = (byte[])this.id.clone();
        }
        otherSelf.idString = this.idString;
        super.copyValues(otherSelf);
        return otherSelf;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof VeriSignCRSTransactionID)) {
            return false;
        }
        VeriSignCRSTransactionID other = (VeriSignCRSTransactionID)obj;
        if (CertJ.isCompatibilityTypeSet(CompatibilityType.CERTJ_COMPATIBILITY_SCEP)) {
            return this.idString == other.idString || this.idString != null && this.idString.equals(other.idString);
        }
        return CertJUtils.byteArraysEqual(other.id, this.id);
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        int idHash = this.id == null && this.idString != null ? this.idString.hashCode() : Arrays.hashCode(this.id);
        result = prime * result + idHash;
        return result;
    }

    protected void reset() {
        super.reset();
        this.id = null;
        this.idString = null;
        this.asn1TemplateValue = null;
    }
}

