/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.cert.attributes;

import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN1Template;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.EndContainer;
import com.rsa.asn1.IntegerContainer;
import com.rsa.asn1.SetContainer;
import com.rsa.certj.cert.AttributeException;
import com.rsa.certj.cert.attributes.X501Attribute;

public class VeriSignCRSVersion
extends X501Attribute {
    private int version = -1;
    ASN1Template asn1TemplateValue;

    public VeriSignCRSVersion() {
        super(12, "VeriSignCRSVersion");
    }

    public VeriSignCRSVersion(int version) {
        this();
        this.setVersion(version);
    }

    protected void decodeValue(byte[] valueBER, int offset) throws AttributeException {
        if (valueBER == null) {
            throw new AttributeException("Encoding is null.");
        }
        this.reset();
        try {
            SetContainer aSet = new SetContainer(0);
            EndContainer anEnd = new EndContainer();
            IntegerContainer crsVersion = new IntegerContainer(0);
            ASN1Container[] asn1Def = new ASN1Container[]{aSet, crsVersion, anEnd};
            ASN1.berDecode((byte[])valueBER, (int)offset, (ASN1Container[])asn1Def);
            this.version = crsVersion.getValueAsInt();
        }
        catch (ASN_Exception asnException) {
            throw new AttributeException("Could not BER decode VeriSignCRSVersion.");
        }
    }

    public void setVersion(int version) {
        this.reset();
        if (version >= 0) {
            this.version = version;
        }
    }

    public int getVersion() {
        return this.version;
    }

    protected int derEncodeValueInit() {
        this.asn1TemplateValue = null;
        if (this.version == -1) {
            this.version = 0;
        }
        SetContainer aSet = new SetContainer(0, true, 0);
        IntegerContainer crsVersion = new IntegerContainer(0, true, 0, this.version);
        EndContainer anEnd = new EndContainer();
        ASN1Container[] asn1Def = new ASN1Container[]{aSet, crsVersion, anEnd};
        this.asn1TemplateValue = new ASN1Template(asn1Def);
        try {
            return this.asn1TemplateValue.derEncodeInit();
        }
        catch (ASN_Exception asnException) {
            return 0;
        }
    }

    protected int derEncodeValue(byte[] encoding, int offset) {
        if (encoding == null) {
            return 0;
        }
        if (this.asn1TemplateValue == null && this.derEncodeValueInit() == 0) {
            return 0;
        }
        try {
            int totalLen = this.asn1TemplateValue.derEncode(encoding, offset);
            this.asn1Template = null;
            return totalLen;
        }
        catch (ASN_Exception asnException) {
            this.asn1Template = null;
            return 0;
        }
    }

    public Object clone() throws CloneNotSupportedException {
        VeriSignCRSVersion otherSelf = new VeriSignCRSVersion();
        if (this.version != -1) {
            otherSelf.version = this.version;
        }
        super.copyValues(otherSelf);
        return otherSelf;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof VeriSignCRSVersion)) {
            return false;
        }
        VeriSignCRSVersion other = (VeriSignCRSVersion)obj;
        return this.version == other.version;
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = prime * result + this.version;
        return result;
    }

    protected void reset() {
        super.reset();
        this.version = -1;
        this.asn1TemplateValue = null;
    }
}

