/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.cert.attributes;

import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN1Template;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.EndContainer;
import com.rsa.asn1.IA5StringContainer;
import com.rsa.asn1.SetContainer;
import com.rsa.certj.CertJInternalHelper;
import com.rsa.certj.cert.AttributeException;
import com.rsa.certj.cert.attributes.X501Attribute;

public class VeriSignSmartCSP
extends X501Attribute {
    private String value;
    ASN1Template asn1TemplateValue;

    public VeriSignSmartCSP() {
        super(5, "VeriSignSmartCSP");
    }

    public VeriSignSmartCSP(String value) {
        this();
        this.setValue(value);
    }

    protected void decodeValue(byte[] valueBER, int offset) throws AttributeException {
        if (valueBER == null) {
            throw new AttributeException("Encoding is null.");
        }
        this.reset();
        try {
            SetContainer aSet = new SetContainer(0);
            EndContainer anEnd = new EndContainer();
            IA5StringContainer csp = new IA5StringContainer(0, 1, 255);
            ASN1Container[] asn1Def = new ASN1Container[]{aSet, csp, anEnd};
            ASN1.berDecode((byte[])valueBER, (int)offset, (ASN1Container[])asn1Def);
            this.value = csp.getValueAsString();
        }
        catch (ASN_Exception asnException) {
            throw new AttributeException("Could not BER decode VeriSignSmartCSP.");
        }
    }

    public void setValue(String value) {
        if (value != null) {
            this.reset();
            this.value = value;
        }
    }

    public String getValue() {
        return this.value;
    }

    protected int derEncodeValueInit() {
        this.asn1TemplateValue = null;
        if (this.value == null) {
            return 0;
        }
        try {
            SetContainer aSet = new SetContainer(0, true, 0);
            IA5StringContainer csp = new IA5StringContainer(0, true, 0, this.value, 1, 255);
            EndContainer anEnd = new EndContainer();
            ASN1Container[] asn1Def = new ASN1Container[]{aSet, csp, anEnd};
            this.asn1TemplateValue = new ASN1Template(asn1Def);
            return this.asn1TemplateValue.derEncodeInit();
        }
        catch (ASN_Exception asnException) {
            return 0;
        }
    }

    protected int derEncodeValue(byte[] encoding, int offset) {
        if (encoding == null) {
            return 0;
        }
        if (this.asn1TemplateValue == null && this.derEncodeValueInit() == 0) {
            return 0;
        }
        try {
            int totalLen = this.asn1TemplateValue.derEncode(encoding, offset);
            this.asn1Template = null;
            return totalLen;
        }
        catch (ASN_Exception asnException) {
            this.asn1Template = null;
            return 0;
        }
    }

    public Object clone() throws CloneNotSupportedException {
        VeriSignSmartCSP otherSelf = new VeriSignSmartCSP();
        if (this.value != null) {
            otherSelf.value = this.value;
        }
        super.copyValues(otherSelf);
        return otherSelf;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof VeriSignSmartCSP)) {
            return false;
        }
        VeriSignSmartCSP other = (VeriSignSmartCSP)obj;
        if (this.value == null) {
            return other.value == null;
        }
        return this.value.equals(other.value);
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = prime * result + CertJInternalHelper.hashCodeValue(this.value);
        return result;
    }

    protected void reset() {
        super.reset();
        this.value = null;
        this.asn1TemplateValue = null;
    }
}

