/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.cert.attributes;

import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN1Lengths;
import com.rsa.asn1.ASN1Template;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.EncodedContainer;
import com.rsa.asn1.EndContainer;
import com.rsa.asn1.OIDContainer;
import com.rsa.asn1.SequenceContainer;
import com.rsa.certj.CertJUtils;
import com.rsa.certj.cert.AttributeException;
import com.rsa.certj.cert.attributes.ChallengePassword;
import com.rsa.certj.cert.attributes.ContentType;
import com.rsa.certj.cert.attributes.CountryOfCitizenship;
import com.rsa.certj.cert.attributes.CountryOfResidence;
import com.rsa.certj.cert.attributes.DateOfBirth;
import com.rsa.certj.cert.attributes.FriendlyName;
import com.rsa.certj.cert.attributes.Gender;
import com.rsa.certj.cert.attributes.LocalKeyID;
import com.rsa.certj.cert.attributes.MessageDigest;
import com.rsa.certj.cert.attributes.NonStandardAttribute;
import com.rsa.certj.cert.attributes.PlaceOfBirth;
import com.rsa.certj.cert.attributes.PostalAddress;
import com.rsa.certj.cert.attributes.Pseudonym;
import com.rsa.certj.cert.attributes.SigningTime;
import com.rsa.certj.cert.attributes.V3ExtensionAttribute;
import com.rsa.certj.cert.attributes.VeriSignCRSDualEnrollmentStatus;
import com.rsa.certj.cert.attributes.VeriSignCRSFailureInfo;
import com.rsa.certj.cert.attributes.VeriSignCRSMessageType;
import com.rsa.certj.cert.attributes.VeriSignCRSPKIStatus;
import com.rsa.certj.cert.attributes.VeriSignCRSRecipientNonce;
import com.rsa.certj.cert.attributes.VeriSignCRSSenderNonce;
import com.rsa.certj.cert.attributes.VeriSignCRSTransactionID;
import com.rsa.certj.cert.attributes.VeriSignCRSVersion;
import com.rsa.certj.cert.attributes.VeriSignSmartCSP;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;

public abstract class X501Attribute
implements Cloneable,
Serializable {
    public static final int SIGNING_TIME = 0;
    public static final int CHALLENGE_PASSWORD = 1;
    public static final int X509_V3_EXTENSION = 2;
    public static final int FRIENDLY_NAME = 3;
    public static final int LOCAL_KEY_ID = 4;
    public static final int SMART_CSP = 5;
    public static final int CRS_MESSAGE_TYPE = 6;
    public static final int CRS_PKI_STATUS = 7;
    public static final int CRS_FAILURE_INFO = 8;
    public static final int CRS_SENDER_NONCE = 9;
    public static final int CRS_RECIPIENT_NONCE = 10;
    public static final int CRS_TRANSACTION_ID = 11;
    public static final int CRS_VERSION = 12;
    public static final int CRS_DUAL_STATUS = 13;
    public static final int CONTENT_TYPE = 14;
    public static final int MESSAGE_DIGEST = 15;
    public static final int POSTAL_ADDRESS = 16;
    public static final int PSEUDONYM = 17;
    public static final int DATE_OF_BIRTH = 18;
    public static final int PLACE_OF_BIRTH = 19;
    public static final int GENDER = 20;
    public static final int COUNTRY_OF_CITIZENSHIP = 21;
    public static final int COUNTRY_OF_RESIDENCE = 22;
    public static final int NON_STANDARD = 23;
    protected static final byte[][] OID_LIST = new byte[][]{{42, -122, 72, -122, -9, 13, 1, 9, 5}, {42, -122, 72, -122, -9, 13, 1, 9, 7}, {42, -122, 72, -122, -9, 13, 1, 9, 14}, {42, -122, 72, -122, -9, 13, 1, 9, 20}, {42, -122, 72, -122, -9, 13, 1, 9, 21}, {96, -122, 72, 1, -122, -8, 69, 1, 9, 1}, {96, -122, 72, 1, -122, -8, 69, 1, 9, 2}, {96, -122, 72, 1, -122, -8, 69, 1, 9, 3}, {96, -122, 72, 1, -122, -8, 69, 1, 9, 4}, {96, -122, 72, 1, -122, -8, 69, 1, 9, 5}, {96, -122, 72, 1, -122, -8, 69, 1, 9, 6}, {96, -122, 72, 1, -122, -8, 69, 1, 9, 7}, {96, -122, 72, 1, -122, -8, 69, 1, 9, 9}, {96, -122, 72, 1, -122, -8, 69, 1, 9, 10}, {42, -122, 72, -122, -9, 13, 1, 9, 3}, {42, -122, 72, -122, -9, 13, 1, 9, 4}, {85, 4, 16}, {85, 4, 65}, {43, 6, 1, 5, 5, 7, 9, 1}, {43, 6, 1, 5, 5, 7, 9, 2}, {43, 6, 1, 5, 5, 7, 9, 3}, {43, 6, 1, 5, 5, 7, 9, 4}, {43, 6, 1, 5, 5, 7, 9, 5}};
    protected int attributeTypeFlag;
    byte[] theOID;
    protected int special;
    protected ASN1Template asn1Template;
    protected String attributeTypeString;

    protected X501Attribute(int attrId, String attrName) {
        this.attributeTypeFlag = attrId;
        if (attrId != 23) {
            this.theOID = new byte[OID_LIST[attrId].length];
            System.arraycopy(OID_LIST[attrId], 0, this.theOID, 0, this.theOID.length);
        }
        this.attributeTypeString = attrName;
    }

    public static X501Attribute getInstance(byte[] attributeBER, int offset, int special) throws AttributeException {
        if (attributeBER == null) {
            throw new AttributeException("Encoding is null.");
        }
        ASN1Container[] asn1Def = X501Attribute.decodeAttribute(attributeBER, offset, special);
        int attrType = X501Attribute.findOID(asn1Def[1].data, asn1Def[1].dataOffset, asn1Def[1].dataLen);
        X501Attribute returnValue = null;
        switch (attrType) {
            case 0: {
                returnValue = new SigningTime();
                break;
            }
            case 1: {
                returnValue = new ChallengePassword();
                break;
            }
            case 2: {
                returnValue = new V3ExtensionAttribute();
                break;
            }
            case 3: {
                returnValue = new FriendlyName();
                break;
            }
            case 4: {
                returnValue = new LocalKeyID();
                break;
            }
            case 5: {
                returnValue = new VeriSignSmartCSP();
                break;
            }
            case 6: {
                returnValue = new VeriSignCRSMessageType();
                break;
            }
            case 7: {
                returnValue = new VeriSignCRSPKIStatus();
                break;
            }
            case 8: {
                returnValue = new VeriSignCRSFailureInfo();
                break;
            }
            case 9: {
                returnValue = new VeriSignCRSSenderNonce();
                break;
            }
            case 10: {
                returnValue = new VeriSignCRSRecipientNonce();
                break;
            }
            case 11: {
                returnValue = new VeriSignCRSTransactionID();
                break;
            }
            case 12: {
                returnValue = new VeriSignCRSVersion();
                break;
            }
            case 13: {
                returnValue = new VeriSignCRSDualEnrollmentStatus();
                break;
            }
            case 14: {
                returnValue = new ContentType();
                break;
            }
            case 15: {
                returnValue = new MessageDigest();
                break;
            }
            case 16: {
                returnValue = new PostalAddress();
                break;
            }
            case 17: {
                returnValue = new Pseudonym();
                break;
            }
            case 18: {
                returnValue = new DateOfBirth();
                break;
            }
            case 19: {
                returnValue = new PlaceOfBirth();
                break;
            }
            case 20: {
                returnValue = new Gender();
                break;
            }
            case 21: {
                returnValue = new CountryOfCitizenship();
                break;
            }
            case 22: {
                returnValue = new CountryOfResidence();
                break;
            }
            case 23: {
                returnValue = new NonStandardAttribute();
                returnValue.theOID = new byte[asn1Def[1].dataLen];
                System.arraycopy(asn1Def[1].data, asn1Def[1].dataOffset, returnValue.theOID, 0, asn1Def[1].dataLen);
                break;
            }
        }
        if (returnValue != null) {
            ((X501Attribute)returnValue).decodeValue(asn1Def[2].data, asn1Def[2].dataOffset);
        }
        for (int index = 0; index < asn1Def.length; ++index) {
            asn1Def[index].clearSensitiveData();
        }
        return returnValue;
    }

    protected static ASN1Container[] decodeAttribute(byte[] attributeBER, int offset, int special) throws AttributeException {
        if (attributeBER == null) {
            throw new AttributeException("Encoding is null.");
        }
        try {
            SequenceContainer seq1 = new SequenceContainer(special);
            EndContainer anEnd = new EndContainer();
            OIDContainer oid = new OIDContainer(0x1000000);
            EncodedContainer value = new EncodedContainer(12544);
            ASN1Container[] asn1Def = new ASN1Container[]{seq1, oid, value, anEnd};
            ASN1.berDecode((byte[])attributeBER, (int)offset, (ASN1Container[])asn1Def);
            return asn1Def;
        }
        catch (ASN_Exception asnException) {
            throw new AttributeException("Cannot read the BER of the attribute.");
        }
    }

    private static int findOID(byte[] compareOID, int offset, int len) {
        if (compareOID == null) {
            return 23;
        }
        for (int index = 0; index < 23; ++index) {
            int oidIndex;
            if (len != OID_LIST[index].length) continue;
            for (oidIndex = 0; oidIndex < len && (compareOID[oidIndex + offset] & 0xFF) == (OID_LIST[index][oidIndex] & 0xFF); ++oidIndex) {
            }
            if (oidIndex < len) continue;
            return index;
        }
        return 23;
    }

    public String getAttributeTypeString() {
        return this.attributeTypeString;
    }

    protected abstract void decodeValue(byte[] var1, int var2) throws AttributeException;

    public byte[] getOID() {
        if (this.theOID == null) {
            return null;
        }
        return (byte[])this.theOID.clone();
    }

    public boolean compareOID(byte[] oid) {
        if (oid == null) {
            return false;
        }
        if (oid.length != this.theOID.length) {
            return false;
        }
        for (int index = 0; index < oid.length; ++index) {
            if (oid[index] == this.theOID[index]) continue;
            return false;
        }
        return true;
    }

    public int getAttributeType() {
        return this.attributeTypeFlag;
    }

    public int getDERLen(int special) {
        return this.derEncodeAttributeLen(special, this.derEncodeValueInit());
    }

    protected abstract int derEncodeValueInit();

    public static int getNextBEROffset(byte[] attributeBER, int offset) throws AttributeException {
        if (attributeBER == null) {
            throw new AttributeException("Encoding is null.");
        }
        try {
            return offset + ASN1Lengths.determineLength((byte[])attributeBER, (int)offset);
        }
        catch (ASN_Exception asnException) {
            throw new AttributeException("Could not read the BER encoding.");
        }
    }

    public int getDEREncoding(byte[] encoding, int offset, int special) throws AttributeException {
        if (encoding == null) {
            throw new AttributeException("Passed array is null.");
        }
        return this.derEncodeAttribute(encoding, offset, special);
    }

    public boolean isAttributeType(int type) {
        return type == this.attributeTypeFlag;
    }

    public int derEncodeAttributeLen(int special, int valueLen) {
        if (valueLen == 0) {
            return 0;
        }
        this.special = special;
        try {
            SequenceContainer seq1 = new SequenceContainer(0, true, 0);
            EndContainer anEnd = new EndContainer();
            OIDContainer oid = new OIDContainer(0x1000000, true, 0, this.theOID, 0, this.theOID.length);
            EncodedContainer value = new EncodedContainer(12544, true, 0, null, 0, valueLen);
            ASN1Container[] asn1Def = new ASN1Container[]{seq1, oid, value, anEnd};
            this.asn1Template = new ASN1Template(asn1Def);
            return this.asn1Template.derEncodeInit();
        }
        catch (ASN_Exception asnException) {
            return 0;
        }
    }

    protected int derEncodeAttribute(byte[] encoding, int offset, int special) throws AttributeException {
        int totalLen;
        if (encoding == null) {
            throw new AttributeException("Passed array is null.");
        }
        if ((this.asn1Template == null || this.special != special) && this.getDERLen(special) == 0) {
            throw new AttributeException("Could not encode, missing data");
        }
        try {
            totalLen = this.asn1Template.derEncode(encoding, offset);
            this.asn1Template = null;
        }
        catch (ASN_Exception asnException) {
            this.asn1Template = null;
            return 0;
        }
        totalLen += this.derEncodeValue(encoding, offset + totalLen);
        return totalLen;
    }

    protected abstract int derEncodeValue(byte[] var1, int var2);

    protected void copyValues(X501Attribute otherSelf) {
        otherSelf.special = this.special;
        if (this.asn1Template == null) {
            return;
        }
        otherSelf.getDERLen(this.special);
    }

    public boolean equals(Object other) {
        if (!(other instanceof X501Attribute)) {
            return false;
        }
        int len = this.getDERLen(0);
        if (len == 0) {
            return false;
        }
        byte[] enc = new byte[len];
        try {
            this.getDEREncoding(enc, 0, 0);
        }
        catch (AttributeException e) {
            return false;
        }
        X501Attribute otherAttr = (X501Attribute)other;
        int otherLen = otherAttr.getDERLen(0);
        if (otherLen == 0) {
            return false;
        }
        byte[] otherEnc = new byte[len];
        try {
            otherAttr.getDEREncoding(otherEnc, 0, 0);
        }
        catch (AttributeException e) {
            return false;
        }
        return CertJUtils.byteArraysEqual(enc, otherEnc);
    }

    public int hashCode() {
        int len = this.getDERLen(0);
        if (len == 0) {
            return 0;
        }
        byte[] enc = new byte[len];
        try {
            this.getDEREncoding(enc, 0, 0);
        }
        catch (AttributeException e) {
            return 0;
        }
        return Arrays.hashCode(enc);
    }

    public abstract Object clone() throws CloneNotSupportedException;

    protected void reset() {
        this.asn1Template = null;
        this.special = 0;
    }

    protected byte[] utf8Encode(String string) throws AttributeException {
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(byteOut);
        try {
            out.writeUTF(string);
            out.flush();
        }
        catch (IOException e) {
            throw new AttributeException("pseudonym.utf8Encode: unable to utf8-encode " + string + ".", e);
        }
        return byteOut.toByteArray();
    }

    protected String utf8Decode(byte[] data, int offset, int len) throws AttributeException {
        byte[] buffer = new byte[len + 2];
        buffer[0] = (byte)(len >> 8 & 0xFF);
        buffer[1] = (byte)(len & 0xFF);
        System.arraycopy(data, offset, buffer, 2, len);
        try {
            ByteArrayInputStream byteIn = new ByteArrayInputStream(buffer, 0, buffer.length);
            DataInputStream in = new DataInputStream(byteIn);
            return in.readUTF();
        }
        catch (IOException ioException) {
            throw new AttributeException("Pseudonym.utf8Decode.", ioException);
        }
    }

    public void clearSensitiveData() {
        this.reset();
    }
}

