/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.cert.extensions;

import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN1Lengths;
import com.rsa.asn1.ASN1Template;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.AlgorithmID;
import com.rsa.asn1.ChoiceContainer;
import com.rsa.asn1.EncodedContainer;
import com.rsa.asn1.EndContainer;
import com.rsa.asn1.IA5StringContainer;
import com.rsa.asn1.IntegerContainer;
import com.rsa.asn1.OIDContainer;
import com.rsa.asn1.OctetStringContainer;
import com.rsa.asn1.SequenceContainer;
import com.rsa.certj.CertJUtils;
import com.rsa.certj.cert.NameException;
import java.io.Serializable;
import java.util.Arrays;

public class BiometricData
implements Cloneable,
Serializable {
    private byte[] dataHash;
    private String dataUri;
    private int biometricType = -1;
    private byte[] dataID;
    private byte[] hashAlgorithmBER;
    protected int special;
    private ASN1Template asn1Template;

    public BiometricData(byte[] infoBER, int offset, int special) throws NameException {
        if (infoBER == null || offset < 0) {
            throw new NameException("Encoding is null.");
        }
        try {
            SequenceContainer dataContainer = new SequenceContainer(special);
            EncodedContainer algContainer = new EncodedContainer(12288);
            OctetStringContainer hashContainer = new OctetStringContainer(0);
            EndContainer endContainer = new EndContainer();
            ChoiceContainer choiceContainer = new ChoiceContainer(0);
            IntegerContainer typeContainer = new IntegerContainer(0);
            OIDContainer oidContainer = new OIDContainer(0x1000000);
            IA5StringContainer uriContainer = new IA5StringContainer(65536);
            ASN1Container[] asn1Def = new ASN1Container[]{dataContainer, choiceContainer, typeContainer, oidContainer, endContainer, algContainer, hashContainer, uriContainer, endContainer};
            ASN1.berDecode((byte[])infoBER, (int)offset, (ASN1Container[])asn1Def);
            if (typeContainer.dataPresent) {
                this.biometricType = typeContainer.getValueAsInt();
            } else {
                this.dataID = new byte[oidContainer.dataLen];
                System.arraycopy(oidContainer.data, oidContainer.dataOffset, this.dataID, 0, oidContainer.dataLen);
            }
            this.hashAlgorithmBER = new byte[algContainer.dataLen];
            System.arraycopy(algContainer.data, algContainer.dataOffset, this.hashAlgorithmBER, 0, algContainer.dataLen);
            if (AlgorithmID.berDecodeAlgID((byte[])this.hashAlgorithmBER, (int)0, (int)11, null) == null) {
                throw new NameException("Unknown or invalid hash algorithm.");
            }
            this.dataHash = new byte[hashContainer.dataLen];
            System.arraycopy(hashContainer.data, hashContainer.dataOffset, this.dataHash, 0, hashContainer.dataLen);
            this.dataUri = uriContainer.getValueAsString();
        }
        catch (ASN_Exception asnException) {
            throw new NameException("Could not BER decode the Biometric Data info.", (Exception)((Object)asnException));
        }
    }

    public BiometricData() {
    }

    public void setDataHash(byte[] dataHash, int offset, int len) {
        if (dataHash != null && len > 0 && offset >= 0 && dataHash.length >= len + offset) {
            this.dataHash = new byte[len];
            System.arraycopy(dataHash, offset, this.dataHash, 0, len);
        } else {
            this.dataHash = null;
        }
    }

    public byte[] getDataHash() {
        if (this.dataHash == null) {
            return null;
        }
        byte[] returnValue = new byte[this.dataHash.length];
        System.arraycopy(this.dataHash, 0, returnValue, 0, this.dataHash.length);
        return returnValue;
    }

    public void setDataURI(String dataUri) {
        this.dataUri = dataUri;
    }

    public String getDataURI() {
        return this.dataUri;
    }

    public void setBiometricType(int biometricType) {
        this.biometricType = biometricType;
        this.dataID = null;
    }

    public int getBiometricType() {
        return this.biometricType;
    }

    public void setDataID(byte[] dataID, int offset, int len) {
        if (dataID != null && len > 0 && offset >= 0 && dataID.length >= len + offset) {
            this.dataID = new byte[len];
            System.arraycopy(dataID, offset, this.dataID, 0, len);
            this.biometricType = -1;
        } else {
            this.dataID = null;
        }
    }

    public byte[] getDataID() {
        if (this.dataID == null) {
            return null;
        }
        byte[] returnValue = new byte[this.dataID.length];
        System.arraycopy(this.dataID, 0, returnValue, 0, this.dataID.length);
        return returnValue;
    }

    public void setHashAlgorithm(String hashAlg) throws NameException {
        try {
            this.hashAlgorithmBER = AlgorithmID.derEncodeAlgID((String)hashAlg, (int)11, null, (int)0, (int)0);
        }
        catch (ASN_Exception asnException) {
            throw new NameException("Invalid hash algorithm. ", (Exception)((Object)asnException));
        }
    }

    public String getHashAlgorithm() throws NameException {
        try {
            return AlgorithmID.berDecodeAlgID((byte[])this.hashAlgorithmBER, (int)0, (int)11, null);
        }
        catch (ASN_Exception asnException) {
            throw new NameException("Invalid hash algorithm. ", (Exception)((Object)asnException));
        }
    }

    public static int getNextBEROffset(byte[] valueBER, int offset) throws NameException {
        if (valueBER == null) {
            throw new NameException("Encoding is null.");
        }
        if (valueBER[offset] == 0 && valueBER[offset + 1] == 0) {
            return offset + 2;
        }
        try {
            return offset + 1 + ASN1Lengths.determineLengthLen((byte[])valueBER, (int)(offset + 1)) + ASN1Lengths.determineLength((byte[])valueBER, (int)(offset + 1));
        }
        catch (ASN_Exception asnException) {
            throw new NameException("Unable to determine length of the BER. ", (Exception)((Object)asnException));
        }
    }

    public int getDERLen(int special) throws NameException {
        if (this.dataHash == null || this.hashAlgorithmBER == null || this.dataID == null && this.biometricType == -1) {
            throw new NameException("Biometric data is not set.");
        }
        this.special = special;
        return this.derEncodeInit();
    }

    public int getDEREncoding(byte[] encoding, int offset, int special) throws NameException {
        if (encoding == null) {
            throw new NameException("Specified array is null.");
        }
        try {
            int len;
            if ((this.asn1Template == null || special != this.special) && (len = this.getDERLen(special)) == 0) {
                throw new NameException("Cannot encode BiometricData.");
            }
            int returnValue = this.asn1Template.derEncode(encoding, offset);
            this.asn1Template = null;
            return returnValue;
        }
        catch (ASN_Exception asnException) {
            this.asn1Template = null;
            throw new NameException("Unable to encode BiometricData.", (Exception)((Object)asnException));
        }
    }

    private int derEncodeInit() throws NameException {
        try {
            IntegerContainer typeContainer;
            SequenceContainer dataContainer = new SequenceContainer(this.special);
            EncodedContainer algContainer = new EncodedContainer(12288, true, 0, this.hashAlgorithmBER, 0, this.hashAlgorithmBER.length);
            OctetStringContainer hashContainer = new OctetStringContainer(0, true, 0, this.dataHash, 0, this.dataHash.length);
            ChoiceContainer choiceContainer = new ChoiceContainer(0);
            EndContainer endContainer = new EndContainer();
            if (this.biometricType != -1) {
                typeContainer = new IntegerContainer(0, true, 0, this.biometricType);
            } else if (this.dataID != null) {
                typeContainer = new OIDContainer(0x1000000, true, 0, this.dataID, 0, this.dataID.length);
            } else {
                throw new NameException("Type of Biometric Data is not set.");
            }
            IA5StringContainer uriContainer = this.dataUri != null ? new IA5StringContainer(65536, true, 0, this.dataUri) : new IA5StringContainer(65536, false, 0, null);
            ASN1Container[] asn1Def = new ASN1Container[]{dataContainer, choiceContainer, typeContainer, endContainer, algContainer, hashContainer, uriContainer, endContainer};
            this.asn1Template = new ASN1Template(asn1Def);
            return this.asn1Template.derEncodeInit();
        }
        catch (ASN_Exception asnException) {
            throw new NameException("cannot create the DER encoding. ", (Exception)((Object)asnException));
        }
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof BiometricData)) {
            return false;
        }
        BiometricData other = (BiometricData)obj;
        if (this.dataUri != null ? !this.dataUri.equals(other.dataUri) : other.dataUri != null) {
            return false;
        }
        if (!CertJUtils.byteArraysEqual(this.dataHash, other.dataHash)) {
            return false;
        }
        if (!CertJUtils.byteArraysEqual(this.dataID, other.dataID)) {
            return false;
        }
        if (!CertJUtils.byteArraysEqual(this.hashAlgorithmBER, other.hashAlgorithmBER)) {
            return false;
        }
        return this.biometricType == other.biometricType;
    }

    public int hashCode() {
        try {
            int len = this.getDERLen(0);
            if (len == 0) {
                return 0;
            }
            byte[] enc = new byte[len];
            this.getDEREncoding(enc, 0, 0);
            return Arrays.hashCode(enc);
        }
        catch (NameException e) {
            return 0;
        }
    }

    public Object clone() throws CloneNotSupportedException {
        BiometricData otherSelf = new BiometricData();
        if (this.dataHash != null) {
            otherSelf.dataHash = new byte[this.dataHash.length];
            System.arraycopy(this.dataHash, 0, otherSelf.dataHash, 0, this.dataHash.length);
        }
        if (this.dataID != null) {
            otherSelf.dataID = new byte[this.dataID.length];
            System.arraycopy(this.dataID, 0, otherSelf.dataID, 0, this.dataID.length);
        }
        if (this.hashAlgorithmBER != null) {
            otherSelf.hashAlgorithmBER = new byte[this.hashAlgorithmBER.length];
            System.arraycopy(this.hashAlgorithmBER, 0, otherSelf.hashAlgorithmBER, 0, this.hashAlgorithmBER.length);
        }
        otherSelf.biometricType = this.biometricType;
        otherSelf.special = this.biometricType;
        otherSelf.dataUri = this.dataUri;
        try {
            if (this.asn1Template != null) {
                otherSelf.derEncodeInit();
            }
        }
        catch (NameException nameExc) {
            throw new CloneNotSupportedException(nameExc.getMessage());
        }
        return otherSelf;
    }
}

