/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.cert.extensions;

import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN1Template;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.EncodedContainer;
import com.rsa.asn1.OfContainer;
import com.rsa.certj.CertJUtils;
import com.rsa.certj.cert.CertExtension;
import com.rsa.certj.cert.CertificateException;
import com.rsa.certj.cert.NameException;
import com.rsa.certj.cert.extensions.BiometricData;
import com.rsa.certj.cert.extensions.X509V3Extension;
import java.util.Arrays;
import java.util.Vector;

public class BiometricInfo
extends X509V3Extension
implements CertExtension {
    private Vector<BiometricData> bioData = new Vector();
    ASN1Template asn1TemplateValue;

    public BiometricInfo() {
        this.extensionTypeFlag = 124;
        this.criticality = false;
        this.setSpecialOID(BIO_INFO_OID);
        this.extensionTypeString = "Biometric_Info";
    }

    public BiometricInfo(BiometricData bioData, boolean criticality) {
        this.extensionTypeFlag = 124;
        this.criticality = criticality;
        this.setSpecialOID(BIO_INFO_OID);
        this.extensionTypeString = "Biometric_Info";
        if (bioData != null) {
            this.bioData.addElement(bioData);
        }
    }

    public void addBioData(BiometricData bioData) {
        if (bioData != null) {
            this.bioData.addElement(bioData);
        }
    }

    public int getBioDataCount() {
        return this.bioData.size();
    }

    public BiometricData getBioData(int index) throws CertificateException {
        if (this.bioData.size() <= index || index < 0) {
            throw new CertificateException("Specified index is invalid.");
        }
        return this.bioData.elementAt(index);
    }

    public void decodeValue(byte[] valueBER, int offset) throws CertificateException {
        if (valueBER == null || offset < 0) {
            throw new CertificateException("Encoding is null.");
        }
        try {
            OfContainer seqOf = new OfContainer(0, 12288, (ASN1Container)new EncodedContainer(12288));
            ASN1Container[] qcDef = new ASN1Container[]{seqOf};
            ASN1.berDecode((byte[])valueBER, (int)offset, (ASN1Container[])qcDef);
            int count = seqOf.getContainerCount();
            for (int index = 0; index < count; ++index) {
                ASN1Container encodedContainer = seqOf.containerAt(index);
                BiometricData data = new BiometricData(encodedContainer.data, encodedContainer.dataOffset, 0);
                this.bioData.addElement(data);
            }
        }
        catch (ASN_Exception asnException) {
            throw new CertificateException("Cannot decode the BER of this extension.", (Exception)((Object)asnException));
        }
        catch (NameException nameException) {
            throw new CertificateException("Cannot decode the BER of this etension.", nameException);
        }
    }

    public int derEncodeValueInit() {
        Vector<OfContainer> asn1Def = new Vector<OfContainer>();
        try {
            OfContainer seqOf = new OfContainer(0, true, 0, 12288, (ASN1Container)new EncodedContainer(12288));
            asn1Def.addElement(seqOf);
            for (BiometricData data : this.bioData) {
                try {
                    int dataLen = data.getDERLen(0);
                    byte[] dataDER = new byte[dataLen];
                    dataLen = data.getDEREncoding(dataDER, 0, 0);
                    EncodedContainer dataContainer = new EncodedContainer(0, true, 0, dataDER, 0, dataLen);
                    seqOf.addContainer((ASN1Container)dataContainer);
                }
                catch (ASN_Exception asnException) {
                    return 0;
                }
                catch (NameException nameException) {
                    return 0;
                }
            }
            Object[] asn1DefArray = new ASN1Container[asn1Def.size()];
            asn1Def.copyInto(asn1DefArray);
            this.asn1TemplateValue = new ASN1Template((ASN1Container[])asn1DefArray);
            return this.asn1TemplateValue.derEncodeInit();
        }
        catch (ASN_Exception asnException) {
            return 0;
        }
    }

    public int derEncodeValue(byte[] encoding, int offset) {
        if (encoding == null) {
            return 0;
        }
        if (this.asn1TemplateValue == null && this.derEncodeValueInit() == 0) {
            return 0;
        }
        try {
            int totalLen = this.asn1TemplateValue.derEncode(encoding, offset);
            this.asn1Template = null;
            return totalLen;
        }
        catch (ASN_Exception asnException) {
            this.asn1Template = null;
            return 0;
        }
    }

    public boolean equals(Object other) {
        if (!(other instanceof BiometricInfo)) {
            return false;
        }
        int len = this.getDERLen(0);
        if (len == 0) {
            return false;
        }
        byte[] enc = new byte[len];
        this.getDEREncoding(enc, 0, 0);
        BiometricInfo otherExt = (BiometricInfo)other;
        int otherLen = otherExt.getDERLen(0);
        if (otherLen == 0) {
            return false;
        }
        byte[] otherEnc = new byte[otherLen];
        otherExt.getDEREncoding(otherEnc, 0, 0);
        return CertJUtils.byteArraysEqual(enc, otherEnc);
    }

    public int hashCode() {
        int len = this.getDERLen(0);
        if (len == 0) {
            return 0;
        }
        byte[] enc = new byte[len];
        this.getDEREncoding(enc, 0, 0);
        return Arrays.hashCode(enc);
    }

    public Object clone() throws CloneNotSupportedException {
        BiometricInfo otherSelf = new BiometricInfo();
        for (BiometricData bioData : this.bioData) {
            otherSelf.bioData.add(bioData);
        }
        if (this.asn1TemplateValue != null) {
            otherSelf.derEncodeValueInit();
        }
        super.copyValues(otherSelf);
        return otherSelf;
    }

    protected void reset() {
        super.reset();
        this.bioData = new Vector();
        this.asn1TemplateValue = null;
    }
}

