/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.cert.extensions;

import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN1Template;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.EndContainer;
import com.rsa.asn1.GenTimeContainer;
import com.rsa.asn1.IA5StringContainer;
import com.rsa.asn1.IntegerContainer;
import com.rsa.asn1.SequenceContainer;
import com.rsa.certj.cert.CertificateException;
import com.rsa.certj.cert.OCSPSingleExtension;
import com.rsa.certj.cert.extensions.X509V3Extension;
import java.util.Date;

public class CRLReference
extends X509V3Extension
implements OCSPSingleExtension {
    private static final int ENCODING_TAG_SPECIAL = 0xA10000;
    ASN1Template asn1TemplateValue;
    private String crlUrl;
    private byte[] crlNum;
    private int crlNumLen;
    private Date crlTime;

    public CRLReference() {
        this.extensionTypeFlag = 119;
        this.criticality = false;
        this.setSpecialOID(CRL_REFERENCE_OID);
        this.extensionTypeString = "CRLReference";
        this.crlUrl = null;
        this.crlNum = null;
        this.crlNumLen = 0;
        this.crlTime = null;
    }

    public CRLReference(String crlUrl, byte[] crlNum, int crlNumOffset, int crlNumLen, Date crlTime) {
        this.extensionTypeFlag = 119;
        this.criticality = false;
        this.setSpecialOID(CRL_REFERENCE_OID);
        this.extensionTypeString = "CRLReference";
        this.setURL(crlUrl);
        this.setCRLTime(crlTime);
        this.setCRLNumber(crlNum, crlNumOffset, crlNumLen);
    }

    public int derEncodeValueInit() {
        try {
            ASN1Container[] asn1Def;
            SequenceContainer seq = new SequenceContainer(0, true, 0);
            EndContainer anEnd = new EndContainer();
            IA5StringContainer urlValue = null;
            IntegerContainer numValue = null;
            GenTimeContainer genTimeValue = null;
            boolean crlUrlFlag = false;
            boolean crlNumFlag = false;
            boolean crlTimeFlag = false;
            if (this.crlUrl != null) {
                urlValue = new IA5StringContainer(0xA10000, true, 0, this.crlUrl);
                crlUrlFlag = true;
            }
            if (this.crlNum != null) {
                numValue = new IntegerContainer(0xA10001, true, 0, this.crlNum, 0, this.crlNumLen, true);
                crlNumFlag = true;
            }
            if (this.crlTime != null) {
                genTimeValue = new GenTimeContainer(10551298, true, 0, this.crlTime);
                crlTimeFlag = true;
            }
            if (!(crlUrlFlag || crlNumFlag || crlTimeFlag)) {
                throw new CertificateException("Could not encode CRLReference extension, values not set.");
            }
            if (crlUrlFlag && crlNumFlag && crlTimeFlag) {
                throw new CertificateException("Could not encode CRLReference extension.");
            }
            if (crlUrlFlag) {
                asn1Def = new ASN1Container[]{seq, urlValue, anEnd};
                this.asn1TemplateValue = new ASN1Template(asn1Def);
            }
            if (crlNumFlag) {
                asn1Def = new ASN1Container[]{seq, numValue, anEnd};
                this.asn1TemplateValue = new ASN1Template(asn1Def);
            }
            if (crlTimeFlag) {
                asn1Def = new ASN1Container[]{seq, genTimeValue, anEnd};
                this.asn1TemplateValue = new ASN1Template(asn1Def);
            }
            return this.asn1TemplateValue.derEncodeInit();
        }
        catch (ASN_Exception asnException) {
            return 0;
        }
        catch (CertificateException certException) {
            return 0;
        }
    }

    public int derEncodeValue(byte[] encoding, int offset) {
        if (encoding == null) {
            return 0;
        }
        if (this.asn1TemplateValue == null && this.derEncodeValueInit() == 0) {
            return 0;
        }
        try {
            int totalLen = this.asn1TemplateValue.derEncode(encoding, offset);
            this.asn1Template = null;
            return totalLen;
        }
        catch (ASN_Exception asnException) {
            this.asn1Template = null;
            return 0;
        }
    }

    public void decodeValue(byte[] valueBER, int offset) throws CertificateException {
        if (valueBER == null) {
            throw new CertificateException("Encoding is null.");
        }
        try {
            SequenceContainer seq = new SequenceContainer(0);
            IA5StringContainer urlValue = new IA5StringContainer(0xA10000);
            IntegerContainer numValue = new IntegerContainer(0xA10001);
            GenTimeContainer genTimeValue = new GenTimeContainer(10551298);
            EndContainer anEnd = new EndContainer();
            ASN1Container[] asn1Def = new ASN1Container[]{seq, urlValue, numValue, genTimeValue, anEnd};
            ASN1.berDecode((byte[])valueBER, (int)offset, (ASN1Container[])asn1Def);
            if (urlValue.dataPresent) {
                this.setURL(urlValue.getValueAsString());
            } else {
                this.crlUrl = null;
            }
            if (numValue.dataPresent) {
                this.crlNum = new byte[numValue.dataLen];
                System.arraycopy(numValue.data, numValue.dataOffset, this.crlNum, 0, numValue.dataLen);
                this.crlNumLen = numValue.dataLen;
            } else {
                this.crlNum = null;
            }
            if (genTimeValue.dataPresent) {
                this.setCRLTime(genTimeValue.theTime);
            } else {
                this.crlTime = null;
            }
        }
        catch (ASN_Exception asnException) {
            throw new CertificateException("Could not decode CRLReference extension.");
        }
    }

    public String getURL() {
        return this.crlUrl;
    }

    public void setURL(String crlUrl) {
        this.crlUrl = crlUrl == null ? null : crlUrl;
    }

    public byte[] getCRLNumber() {
        return this.crlNum;
    }

    public void setCRLNumber(byte[] data, int crlNumOffset, int crlNumLen) {
        if (this.crlNum == null || crlNumLen == 0) {
            this.crlNum = null;
            this.crlNumLen = 0;
        } else {
            this.crlNum = new byte[crlNumLen];
            System.arraycopy(data, crlNumOffset, this.crlNum, 0, crlNumLen);
            this.crlNumLen = crlNumLen;
        }
    }

    public Date getCRLTime() {
        return this.crlTime;
    }

    public void setCRLTime(Date crlTime) {
        this.crlTime = crlTime == null ? null : new Date(crlTime.getTime());
    }

    public Object clone() throws CloneNotSupportedException {
        CRLReference otherSelf = new CRLReference();
        if (this.crlUrl != null) {
            otherSelf.crlUrl = this.crlUrl;
        }
        if (this.crlTime != null) {
            otherSelf.crlTime = new Date(this.crlTime.getTime());
        }
        if (this.crlNum != null) {
            otherSelf.crlNumLen = this.crlNumLen;
            otherSelf.crlNum = new byte[otherSelf.crlNumLen];
            System.arraycopy(this.crlNum, 0, otherSelf.crlNum, 0, otherSelf.crlNumLen);
        }
        if (this.asn1TemplateValue != null) {
            otherSelf.derEncodeValueInit();
        }
        super.copyValues(otherSelf);
        return otherSelf;
    }
}

