/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.cert.extensions;

import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN1Template;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.IntegerContainer;
import com.rsa.certj.cert.CRLExtension;
import com.rsa.certj.cert.CertificateException;
import com.rsa.certj.cert.extensions.X509V3Extension;

public class DeltaCRLIndicator
extends X509V3Extension
implements CRLExtension {
    private byte[] indicator;
    ASN1Template asn1TemplateValue;

    private DeltaCRLIndicator(boolean criticality) {
        this.extensionTypeFlag = 27;
        this.criticality = criticality;
        this.setStandardOID(27);
        this.extensionTypeString = "DeltaCRLIndicator";
    }

    public DeltaCRLIndicator() {
        this(false);
        this.setDeltaCRLIndicator(0);
    }

    public DeltaCRLIndicator(int indicator, boolean criticality) {
        this(criticality);
        this.setDeltaCRLIndicator(indicator);
    }

    public DeltaCRLIndicator(byte[] indicator, int offset, int length, boolean criticality) {
        this(criticality);
        this.setDeltaCRLIndicator(indicator, offset, length);
    }

    public void decodeValue(byte[] valueBER, int offset) throws CertificateException {
        if (valueBER == null) {
            throw new CertificateException("Encoding is null.");
        }
        IntegerContainer number = new IntegerContainer(0);
        ASN1Container[] asn1Def = new ASN1Container[]{number};
        try {
            ASN1.berDecode((byte[])valueBER, (int)offset, (ASN1Container[])asn1Def);
            this.indicator = new byte[number.dataLen];
            System.arraycopy(number.data, number.dataOffset, this.indicator, 0, number.dataLen);
        }
        catch (ASN_Exception asnException) {
            throw new CertificateException("Could not decode DeltaCRLIndicator extension.");
        }
    }

    public void setDeltaCRLIndicator(int indicator) {
        this.indicator = this.intToByteArray(indicator);
    }

    public void setDeltaCRLIndicator(byte[] indicator, int offset, int length) {
        this.indicator = new byte[length];
        System.arraycopy(indicator, offset, this.indicator, 0, length);
    }

    public int getDeltaCRLIndicator() throws CertificateException {
        if (this.indicator.length > 4) {
            throw new CertificateException("Can not represent integer in 32 bits.");
        }
        return this.byteArrayToInt(this.indicator);
    }

    public byte[] getDeltaCRLIndicatorAsByteArray() {
        return this.indicator;
    }

    public int derEncodeValueInit() {
        try {
            IntegerContainer number = new IntegerContainer(0, true, 0, this.indicator, 0, this.indicator.length, true);
            ASN1Container[] asn1Def = new ASN1Container[]{number};
            this.asn1TemplateValue = new ASN1Template(asn1Def);
            return this.asn1TemplateValue.derEncodeInit();
        }
        catch (ASN_Exception asnException) {
            return 0;
        }
    }

    public int derEncodeValue(byte[] encoding, int offset) {
        if (encoding == null) {
            return 0;
        }
        if (this.asn1TemplateValue == null && this.derEncodeValueInit() == 0) {
            return 0;
        }
        try {
            int totalLen = this.asn1TemplateValue.derEncode(encoding, offset);
            this.asn1Template = null;
            return totalLen;
        }
        catch (ASN_Exception asnException) {
            this.asn1Template = null;
            return 0;
        }
    }

    public Object clone() throws CloneNotSupportedException {
        DeltaCRLIndicator otherSelf = new DeltaCRLIndicator();
        if (this.indicator != null) {
            otherSelf.indicator = (byte[])this.indicator.clone();
        }
        if (this.asn1TemplateValue != null) {
            otherSelf.derEncodeValueInit();
        }
        super.copyValues(otherSelf);
        return otherSelf;
    }

    protected void reset() {
        super.reset();
        this.setDeltaCRLIndicator(0);
        this.asn1TemplateValue = null;
    }
}

