/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.cert.extensions;

import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN1Template;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.EncodedContainer;
import com.rsa.asn1.OIDContainer;
import com.rsa.asn1.OfContainer;
import com.rsa.certj.cert.CertExtension;
import com.rsa.certj.cert.CertificateException;
import com.rsa.certj.cert.NameException;
import com.rsa.certj.cert.extensions.X509V3Extension;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtendedKeyUsage
extends X509V3Extension
implements CertExtension {
    public static final byte[] ID_KP_SERVER_AUTH = new byte[]{43, 6, 1, 5, 5, 7, 3, 1};
    public static final byte[] ID_KP_CLIENT_AUTH = new byte[]{43, 6, 1, 5, 5, 7, 3, 2};
    public static final byte[] ID_KP_CODE_SIGNING = new byte[]{43, 6, 1, 5, 5, 7, 3, 3};
    public static final byte[] ID_KP_EMAIL_PROTECTION = new byte[]{43, 6, 1, 5, 5, 7, 3, 4};
    public static final byte[] ID_KP_TIME_STAMPING = new byte[]{43, 6, 1, 5, 5, 7, 3, 8};
    public static final byte[] ID_KP_OCSP_SIGNING = new byte[]{43, 6, 1, 5, 5, 7, 3, 9};
    private Vector<Object>[] keyPurposeID = this.createVectorArray(3);
    ASN1Template asn1TemplateValue;

    public ExtendedKeyUsage() {
        this.extensionTypeFlag = 37;
        this.criticality = false;
        this.setStandardOID(37);
        this.extensionTypeString = "ExtendedKeyUsage";
    }

    public ExtendedKeyUsage(byte[] keyPurpose, int offset, int len, boolean criticality) {
        this.extensionTypeFlag = 37;
        this.criticality = criticality;
        this.setStandardOID(37);
        if (keyPurpose != null && len != 0) {
            this.keyPurposeID[0].addElement(keyPurpose);
            this.keyPurposeID[1].addElement(new Integer(offset));
            this.keyPurposeID[2].addElement(new Integer(len));
        }
        this.extensionTypeString = "ExtendedKeyUsage";
    }

    private Vector<Object>[] createVectorArray(int size) {
        Vector[] vectorArray = new Vector[size];
        for (int index = 0; index < size; ++index) {
            vectorArray[index] = new Vector();
        }
        return vectorArray;
    }

    @Override
    public void decodeValue(byte[] valueBER, int offset) throws CertificateException {
        if (valueBER == null) {
            throw new CertificateException("Encoding is null.");
        }
        try {
            OfContainer seqOf = new OfContainer(this.special, 12288, (ASN1Container)new EncodedContainer(1536));
            ASN1Container[] oidDef = new ASN1Container[]{seqOf};
            ASN1.berDecode((byte[])valueBER, (int)offset, (ASN1Container[])oidDef);
            int oidCount = seqOf.getContainerCount();
            for (int index = 0; index < oidCount; ++index) {
                ASN1Container encodedOIDContainer = seqOf.containerAt(index);
                OIDContainer keyPurpose = new OIDContainer(0x1000000);
                ASN1Container[] asn1Def = new ASN1Container[]{keyPurpose};
                ASN1.berDecode((byte[])encodedOIDContainer.data, (int)encodedOIDContainer.dataOffset, (ASN1Container[])asn1Def);
                this.keyPurposeID[0].addElement(keyPurpose.data);
                this.keyPurposeID[1].addElement(new Integer(keyPurpose.dataOffset));
                this.keyPurposeID[2].addElement(new Integer(keyPurpose.dataLen));
            }
        }
        catch (ASN_Exception asnException) {
            throw new CertificateException("Could not decode Extended Key Usage extension.");
        }
    }

    public void addExtendedKeyUsage(byte[] data, int offset, int len) {
        if (data != null && len != 0) {
            this.keyPurposeID[0].addElement(data);
            this.keyPurposeID[1].addElement(new Integer(offset));
            this.keyPurposeID[2].addElement(new Integer(len));
        }
    }

    public byte[] getExtendedKeyUsage(int index) throws CertificateException {
        if (index >= this.keyPurposeID[0].size()) {
            throw new CertificateException(" Invalid Index ");
        }
        if (this.keyPurposeID[0].elementAt(index) == null) {
            return null;
        }
        Integer offset = (Integer)this.keyPurposeID[1].elementAt(index);
        Integer len = (Integer)this.keyPurposeID[2].elementAt(index);
        byte[] returnValue = new byte[len.intValue()];
        System.arraycopy(this.keyPurposeID[0].elementAt(index), offset, returnValue, 0, len);
        return returnValue;
    }

    public int getKeyUsageCount() {
        return this.keyPurposeID[0].size();
    }

    @Override
    public int derEncodeValueInit() {
        Vector<OfContainer> asn1Def = new Vector<OfContainer>();
        try {
            OfContainer seqOf = new OfContainer(this.special, true, 0, 12288, (ASN1Container)new EncodedContainer(1536));
            asn1Def.addElement(seqOf);
            for (int index = 0; index < this.keyPurposeID[0].size(); ++index) {
                try {
                    EncodedContainer oidContainer = this.encodeOID(index);
                    seqOf.addContainer((ASN1Container)oidContainer);
                    continue;
                }
                catch (Exception anyExc) {
                    return 0;
                }
            }
            Object[] asn1DefArray = new ASN1Container[asn1Def.size()];
            asn1Def.copyInto(asn1DefArray);
            this.asn1TemplateValue = new ASN1Template((ASN1Container[])asn1DefArray);
            return this.asn1TemplateValue.derEncodeInit();
        }
        catch (ASN_Exception asnException) {
            return 0;
        }
    }

    private EncodedContainer encodeOID(int index) throws NameException {
        try {
            int offset = (Integer)this.keyPurposeID[1].elementAt(index);
            int len = (Integer)this.keyPurposeID[2].elementAt(index);
            OIDContainer keyPurpose = new OIDContainer(0x1000000, true, 0, (byte[])this.keyPurposeID[0].elementAt(index), offset, len);
            ASN1Container[] asn1Def = new ASN1Container[]{keyPurpose};
            ASN1Template templ = new ASN1Template(asn1Def);
            int encodingLen = templ.derEncodeInit();
            byte[] encoding = new byte[encodingLen];
            encodingLen = templ.derEncode(encoding, 0);
            return new EncodedContainer(1536, true, 0, encoding, 0, encodingLen);
        }
        catch (ASN_Exception asnException) {
            throw new NameException(" Can't encode Extended Key Usage");
        }
    }

    @Override
    public int derEncodeValue(byte[] encoding, int offset) {
        if (encoding == null) {
            return 0;
        }
        if (this.asn1TemplateValue == null && this.derEncodeValueInit() == 0) {
            return 0;
        }
        try {
            int totalLen = this.asn1TemplateValue.derEncode(encoding, offset);
            this.asn1Template = null;
            return totalLen;
        }
        catch (ASN_Exception asnException) {
            this.asn1Template = null;
            return 0;
        }
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        ExtendedKeyUsage otherSelf = new ExtendedKeyUsage();
        for (int index = 0; index < this.keyPurposeID.length; ++index) {
            for (int oidIndex = 0; oidIndex < this.keyPurposeID[index].size(); ++oidIndex) {
                otherSelf.keyPurposeID[index].addElement(this.keyPurposeID[index].elementAt(oidIndex));
            }
        }
        if (this.asn1TemplateValue != null) {
            otherSelf.derEncodeValueInit();
        }
        super.copyValues(otherSelf);
        return otherSelf;
    }

    @Override
    protected void reset() {
        super.reset();
        this.keyPurposeID = null;
        this.asn1TemplateValue = null;
    }
}

