/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.cert.extensions;

import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN1Lengths;
import com.rsa.asn1.ASN1Template;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.EncodedContainer;
import com.rsa.asn1.OfContainer;
import com.rsa.certj.cert.NameException;
import com.rsa.certj.cert.extensions.ExtensionAttribute;
import java.io.Serializable;
import java.util.Vector;

public class ExtensionAttributes
implements Cloneable,
Serializable {
    private Vector<ExtensionAttribute> attributes = new Vector();
    protected int special;
    protected ASN1Template asn1Template;

    public ExtensionAttributes(byte[] valueBER, int offset, int special) throws NameException {
        this.special = special;
        if (valueBER == null) {
            throw new NameException("Encoding is null.");
        }
        try {
            OfContainer setOf = new OfContainer(special, 12544, (ASN1Container)new EncodedContainer(12288));
            ASN1Container[] nameDef = new ASN1Container[]{setOf};
            ASN1.berDecode((byte[])valueBER, (int)offset, (ASN1Container[])nameDef);
            int nameCount = setOf.getContainerCount();
            for (int nameIndex = 0; nameIndex < nameCount; ++nameIndex) {
                ASN1Container encodedNameContainer = setOf.containerAt(nameIndex);
                this.attributes.addElement(new ExtensionAttribute(encodedNameContainer.data, encodedNameContainer.dataOffset, 0));
            }
        }
        catch (ASN_Exception asnException) {
            throw new NameException("Cannot decode the BER of ExtensionAttributes.");
        }
    }

    public ExtensionAttributes() {
    }

    public void addAttribute(ExtensionAttribute attr) {
        if (attr != null) {
            this.attributes.addElement(attr);
        }
    }

    public ExtensionAttribute getAttribute(int index) throws NameException {
        if (index >= this.attributes.size()) {
            throw new NameException(" Invalid index ");
        }
        return this.attributes.elementAt(index);
    }

    public int getAttributeCount() {
        return this.attributes.size();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        int length = this.attributes.size() - 1;
        for (int index = 0; index < length; ++index) {
            buffer.append(this.attributes.elementAt(index).toString());
            buffer.append(",");
        }
        buffer.append(this.attributes.elementAt(length).toString());
        return buffer.toString();
    }

    public static int getNextBEROffset(byte[] nameBER, int offset) throws NameException {
        if (nameBER == null) {
            throw new NameException("Encoding is null.");
        }
        if (nameBER[offset] == 0 && nameBER[offset + 1] == 0) {
            return offset + 2;
        }
        try {
            return offset + 1 + ASN1Lengths.determineLengthLen((byte[])nameBER, (int)(offset + 1)) + ASN1Lengths.determineLength((byte[])nameBER, (int)(offset + 1));
        }
        catch (ASN_Exception asnException) {
            throw new NameException("Unable to determine length of the BER");
        }
    }

    public int getDERLen(int special) throws NameException {
        this.special = special;
        return this.derEncodeInit();
    }

    public int getDEREncoding(byte[] encoding, int offset, int special) throws NameException {
        if (encoding == null) {
            throw new NameException("Specified array is null.");
        }
        try {
            if (this.asn1Template == null || special != this.special) {
                this.getDERLen(special);
            }
            int returnValue = this.asn1Template.derEncode(encoding, offset);
            this.asn1Template = null;
            return returnValue;
        }
        catch (ASN_Exception asnException) {
            this.asn1Template = null;
            throw new NameException("Unable to encode ExtensionAttributes");
        }
    }

    private int derEncodeInit() {
        if (this.asn1Template != null) {
            return 0;
        }
        try {
            Vector<OfContainer> asn1Def = new Vector<OfContainer>();
            OfContainer setOf = new OfContainer(this.special, true, 0, 12544, (ASN1Container)new EncodedContainer(12288));
            asn1Def.addElement(setOf);
            for (int index = 0; index < this.attributes.size(); ++index) {
                int derLen = this.attributes.elementAt(index).getDERLen(0);
                byte[] attrBER = new byte[derLen];
                int attrLen = this.attributes.elementAt(index).getDEREncoding(attrBER, 0, 0);
                EncodedContainer attrContainer = new EncodedContainer(0, true, 0, attrBER, 0, attrLen);
                setOf.addContainer((ASN1Container)attrContainer);
            }
            Object[] asn1DefArray = new ASN1Container[asn1Def.size()];
            asn1Def.copyInto(asn1DefArray);
            this.asn1Template = new ASN1Template((ASN1Container[])asn1DefArray);
            return this.asn1Template.derEncodeInit();
        }
        catch (ASN_Exception asnException) {
            return 0;
        }
        catch (NameException nameException) {
            return 0;
        }
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof ExtensionAttributes)) {
            return false;
        }
        ExtensionAttributes other = (ExtensionAttributes)obj;
        if (this.attributes.size() != other.attributes.size()) {
            return false;
        }
        for (int index = 0; index < this.attributes.size(); ++index) {
            if (this.attributes.elementAt(index).equals(other.attributes.elementAt(index))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hashcode = 0;
        for (int index = 0; index < this.attributes.size(); ++index) {
            hashcode ^= this.attributes.elementAt(index).hashCode();
            hashcode *= 17;
        }
        return hashcode;
    }

    public Object clone() throws CloneNotSupportedException {
        ExtensionAttributes otherSelf = new ExtensionAttributes();
        for (int index = 0; index < this.attributes.size(); ++index) {
            otherSelf.attributes.addElement(this.attributes.elementAt(index));
        }
        otherSelf.special = this.special;
        if (this.asn1Template != null) {
            otherSelf.derEncodeInit();
        }
        return otherSelf;
    }
}

