/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.cert.extensions;

import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN1Lengths;
import com.rsa.asn1.ASN1Template;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.EncodedContainer;
import com.rsa.asn1.OfContainer;
import com.rsa.certj.cert.NameException;
import com.rsa.certj.cert.extensions.GeneralName;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeneralNames
implements Cloneable,
Serializable {
    private Vector<GeneralName> nameVector = new Vector();
    protected int special;
    private ASN1Template asn1Template;

    public GeneralNames(byte[] nameBER, int offset, int special) throws NameException {
        if (nameBER == null) {
            throw new NameException("Encoding is null.");
        }
        try {
            OfContainer sequenceOfContainer = new OfContainer(special, 12288, (ASN1Container)new EncodedContainer(65280));
            ASN1Container[] nameDef = new ASN1Container[]{sequenceOfContainer};
            ASN1.berDecode((byte[])nameBER, (int)offset, (ASN1Container[])nameDef);
            int nameCount = sequenceOfContainer.getContainerCount();
            for (int nameIndex = 0; nameIndex < nameCount; ++nameIndex) {
                ASN1Container nameContainer = sequenceOfContainer.containerAt(nameIndex);
                GeneralName name = new GeneralName(nameContainer.data, nameContainer.dataOffset, 0);
                this.nameVector.addElement(name);
            }
        }
        catch (ASN_Exception asnException) {
            throw new NameException("Cannot decode the BER of the name.");
        }
        catch (NameException asnException) {
            throw new NameException("Cannot decode the BER of the name.");
        }
    }

    public GeneralNames() {
    }

    public void addGeneralName(GeneralName name) {
        if (name != null) {
            this.nameVector.addElement(name);
        }
    }

    public Vector<GeneralName> getGeneralNames() {
        return this.nameVector;
    }

    public GeneralName getGeneralName(int index) throws NameException {
        if (index < this.nameVector.size()) {
            return this.nameVector.elementAt(index);
        }
        throw new NameException("Invalid index.");
    }

    public void removeGeneralName(int index) throws NameException {
        if (index >= this.nameVector.size()) {
            throw new NameException("Invalid Index.");
        }
        this.nameVector.removeElementAt(index);
    }

    public void addGeneralName(GeneralName name, int index) throws NameException {
        if (name == null) {
            throw new NameException("Specified name is null.");
        }
        if (index >= this.nameVector.size()) {
            throw new NameException("Invalid index.");
        }
        this.nameVector.setElementAt(name, index);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        for (GeneralName name : this.nameVector) {
            String element = name.toString();
            buffer.append(element);
            buffer.append(",");
        }
        if (buffer.length() > 0) {
            buffer.setLength(buffer.length() - 1);
        }
        return buffer.toString();
    }

    public int getNameCount() {
        return this.nameVector.size();
    }

    public static int getNextBEROffset(byte[] nameBER, int offset) throws NameException {
        if (nameBER == null) {
            throw new NameException("Encoding is null.");
        }
        if (nameBER[offset] == 0 && nameBER[offset + 1] == 0) {
            return offset + 2;
        }
        try {
            return offset + 1 + ASN1Lengths.determineLengthLen((byte[])nameBER, (int)(offset + 1)) + ASN1Lengths.determineLength((byte[])nameBER, (int)(offset + 1));
        }
        catch (ASN_Exception asnException) {
            throw new NameException("Unable to determine length of the BER");
        }
    }

    public int getDERLen(int special) throws NameException {
        this.special = special;
        return this.derEncodeInit();
    }

    public int getDEREncoding(byte[] encoding, int offset, int special) throws NameException {
        if (encoding == null) {
            throw new NameException("Specified array is null.");
        }
        try {
            int len;
            if ((this.asn1Template == null || special != this.special) && (len = this.getDERLen(special)) == 0) {
                throw new NameException("Cannot encode GeneralNames.");
            }
            int returnValue = this.asn1Template.derEncode(encoding, offset);
            this.asn1Template = null;
            return returnValue;
        }
        catch (ASN_Exception asnException) {
            this.asn1Template = null;
            throw new NameException("Unable to encode GeneralNames.");
        }
    }

    private int derEncodeInit() {
        Vector<OfContainer> asn1Def = new Vector<OfContainer>();
        try {
            OfContainer seqOf = new OfContainer(this.special, true, 0, 12288, (ASN1Container)new EncodedContainer(65280));
            asn1Def.addElement(seqOf);
            for (GeneralName name : this.nameVector) {
                try {
                    int nameLen = name.getDERLen(0);
                    byte[] nameDER = new byte[nameLen];
                    nameLen = name.getDEREncoding(nameDER, 0, 0);
                    EncodedContainer nameContainer = new EncodedContainer(0, true, 0, nameDER, 0, nameLen);
                    seqOf.addContainer((ASN1Container)nameContainer);
                }
                catch (ASN_Exception asnException) {
                    return 0;
                }
                catch (NameException nameException) {
                    return 0;
                }
            }
            Object[] asn1DefArray = new ASN1Container[asn1Def.size()];
            asn1Def.copyInto(asn1DefArray);
            this.asn1Template = new ASN1Template((ASN1Container[])asn1DefArray);
            return this.asn1Template.derEncodeInit();
        }
        catch (ASN_Exception asnException) {
            return 0;
        }
    }

    public boolean equals(Object obj) {
        int otherVectorLen;
        if (obj == null || !(obj instanceof GeneralNames)) {
            return false;
        }
        GeneralNames other = (GeneralNames)obj;
        int thisVectorLen = this.nameVector.size();
        if (thisVectorLen != (otherVectorLen = other.nameVector.size())) {
            return false;
        }
        for (int vectorIndex = 0; vectorIndex < thisVectorLen; ++vectorIndex) {
            if (this.nameVector.elementAt(vectorIndex).equals(other.nameVector.elementAt(vectorIndex))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int result = 0;
        Iterator<GeneralName> namesIter = this.nameVector.iterator();
        while (namesIter.hasNext()) {
            result ^= namesIter.next().hashCode();
        }
        return result;
    }

    public boolean contains(GeneralName name) {
        if (name == null) {
            return false;
        }
        try {
            for (int i = 0; i < this.getNameCount(); ++i) {
                if (!name.equals(this.getGeneralName(i))) continue;
                return true;
            }
            return false;
        }
        catch (NameException e) {
            return false;
        }
    }

    public Object clone() throws CloneNotSupportedException {
        GeneralNames otherSelf = new GeneralNames();
        otherSelf.nameVector = new Vector<GeneralName>(this.nameVector);
        otherSelf.special = this.special;
        if (this.asn1Template != null) {
            otherSelf.derEncodeInit();
        }
        return otherSelf;
    }
}

