/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.cert.extensions;

import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN1Lengths;
import com.rsa.asn1.ASN1Template;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.EncodedContainer;
import com.rsa.asn1.EndContainer;
import com.rsa.asn1.IntegerContainer;
import com.rsa.asn1.OfContainer;
import com.rsa.asn1.SequenceContainer;
import com.rsa.certj.cert.NameException;
import com.rsa.certj.cert.extensions.GeneralName;
import java.io.Serializable;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeneralSubtrees
implements Cloneable,
Serializable {
    private static final int MINIMUM_SPECIAL = 0x820000;
    private static final int MAXIMUM_SPECIAL = 0x810001;
    private Vector<Object>[] subtree = GeneralSubtrees.createVectorArray(3);
    protected int special;
    private ASN1Template asn1Template;

    public GeneralSubtrees() {
    }

    public GeneralSubtrees(byte[] valueBER, int offset, int special) throws NameException {
        if (valueBER == null) {
            throw new NameException("Encoding is null.");
        }
        try {
            OfContainer seqOf = new OfContainer(special, 12288, (ASN1Container)new EncodedContainer(12288));
            ASN1Container[] nameDef = new ASN1Container[]{seqOf};
            ASN1.berDecode((byte[])valueBER, (int)offset, (ASN1Container[])nameDef);
            int nameCount = seqOf.getContainerCount();
            for (int nameIndex = 0; nameIndex < nameCount; ++nameIndex) {
                ASN1Container encodedNameContainer = seqOf.containerAt(nameIndex);
                SequenceContainer seq = new SequenceContainer(0);
                EndContainer anEnd = new EndContainer();
                EncodedContainer base = new EncodedContainer(65280);
                IntegerContainer minimum = new IntegerContainer(0x820000);
                IntegerContainer maximum = new IntegerContainer(0x810001);
                ASN1Container[] asn1Def = new ASN1Container[]{seq, base, minimum, maximum, anEnd};
                ASN1.berDecode((byte[])encodedNameContainer.data, (int)encodedNameContainer.dataOffset, (ASN1Container[])asn1Def);
                this.subtree[0].addElement(new GeneralName(base.data, base.dataOffset, 0));
                if (minimum.dataPresent) {
                    int minInt = this.bytesToInt(minimum.data, minimum.dataOffset, minimum.dataLen);
                    this.subtree[1].addElement(new Integer(minInt));
                } else {
                    this.subtree[1].addElement(new Integer(0));
                }
                if (maximum.dataPresent) {
                    int maxInt = this.bytesToInt(maximum.data, maximum.dataOffset, maximum.dataLen);
                    this.subtree[2].addElement(new Integer(maxInt));
                    continue;
                }
                this.subtree[2].addElement(new Integer(-1));
            }
        }
        catch (Exception certException) {
            throw new NameException("Cannot decode the BER of GeneralSubtrees.");
        }
    }

    private int bytesToInt(byte[] data, int offset, int len) throws NameException {
        if (len == 0 || data == null) {
            return 0;
        }
        if (len > 4) {
            throw new NameException("Could not decode General Subtrees.");
        }
        int returnValue = 0;
        for (int index = offset; index < len + offset; ++index) {
            returnValue <<= 8;
            returnValue |= data[index] & 0xFF;
        }
        return returnValue;
    }

    public void addSubtree(GeneralName base, int minimum, int maximum) {
        if (base != null) {
            this.subtree[0].addElement(base);
            if (minimum < 0) {
                minimum = 0;
            }
            this.subtree[1].addElement(new Integer(minimum));
            if (maximum < 0) {
                maximum = -1;
            }
            this.subtree[2].addElement(new Integer(maximum));
        }
    }

    public GeneralName getBase(int index) throws NameException {
        if (this.subtree[0].size() <= index) {
            throw new NameException("Specified index is invalid.");
        }
        return (GeneralName)this.subtree[0].elementAt(index);
    }

    public int getMinimum(int index) throws NameException {
        if (this.subtree[1].size() <= index) {
            throw new NameException("Specified index is invalid.");
        }
        Integer min = (Integer)this.subtree[1].elementAt(index);
        return min;
    }

    public int getMaximum(int index) throws NameException {
        if (this.subtree[2].size() <= index) {
            throw new NameException("Specified index is invalid.");
        }
        Integer max = (Integer)this.subtree[2].elementAt(index);
        return max;
    }

    private static Vector<Object>[] createVectorArray(int size) {
        Vector[] vectorArray = new Vector[size];
        for (int index = 0; index < size; ++index) {
            vectorArray[index] = new Vector();
        }
        return vectorArray;
    }

    public int getSubtreeCount() {
        return this.subtree[0].size();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        if (this.subtree[0].isEmpty()) {
            return "";
        }
        for (int index = 0; index < this.subtree[0].size(); ++index) {
            String name = this.subtree[0].elementAt(index).toString();
            buffer.append(name);
            buffer.append("   min = ");
            buffer.append(this.subtree[1].elementAt(index));
            buffer.append(", max = ");
            buffer.append(this.subtree[2].elementAt(index));
            buffer.append(" \n");
        }
        return buffer.toString();
    }

    public static int getNextBEROffset(byte[] valueBER, int offset) throws NameException {
        if (valueBER == null) {
            throw new NameException("Encoding is null.");
        }
        if (valueBER[offset] == 0 && valueBER[offset + 1] == 0) {
            return offset + 2;
        }
        try {
            return offset + 1 + ASN1Lengths.determineLengthLen((byte[])valueBER, (int)(offset + 1)) + ASN1Lengths.determineLength((byte[])valueBER, (int)(offset + 1));
        }
        catch (ASN_Exception asnException) {
            throw new NameException("Unable to determine length of the BER");
        }
    }

    public int getDERLen(int special) throws NameException {
        this.special = special;
        return this.derEncodeInit();
    }

    public int getDEREncoding(byte[] encoding, int offset, int special) throws NameException {
        if (encoding == null) {
            throw new NameException("Specified array is null.");
        }
        try {
            if (this.asn1Template == null || special != this.special) {
                this.getDERLen(special);
            }
            int returnValue = this.asn1Template.derEncode(encoding, offset);
            this.asn1Template = null;
            return returnValue;
        }
        catch (ASN_Exception asnException) {
            this.asn1Template = null;
            throw new NameException("Unable to encode GeneralTrees.");
        }
    }

    private int derEncodeInit() {
        Vector<OfContainer> asn1Def = new Vector<OfContainer>();
        try {
            OfContainer sequenceOfContainer = new OfContainer(this.special, true, 0, 12288, (ASN1Container)new EncodedContainer(12288));
            asn1Def.addElement(sequenceOfContainer);
            for (int index = 0; index < this.subtree[0].size(); ++index) {
                try {
                    EncodedContainer treeContainer = this.encodeSubtree(index);
                    sequenceOfContainer.addContainer((ASN1Container)treeContainer);
                    continue;
                }
                catch (ASN_Exception asnException) {
                    return 0;
                }
                catch (NameException nameException) {
                    return 0;
                }
            }
            Object[] asn1DefArray = new ASN1Container[asn1Def.size()];
            asn1Def.copyInto(asn1DefArray);
            this.asn1Template = new ASN1Template((ASN1Container[])asn1DefArray);
            return this.asn1Template.derEncodeInit();
        }
        catch (ASN_Exception asnException) {
            return 0;
        }
    }

    private EncodedContainer encodeSubtree(int index) throws NameException {
        EncodedContainer next;
        SequenceContainer seq = new SequenceContainer(0, true, 0);
        EndContainer end = new EndContainer();
        int baseDERLen = ((GeneralName)this.subtree[0].elementAt(index)).getDERLen(0);
        byte[] baseDER = new byte[baseDERLen];
        int offset = 0;
        int returnLen = ((GeneralName)this.subtree[0].elementAt(index)).getDEREncoding(baseDER, offset, 0);
        try {
            ASN1Template templ;
            EncodedContainer base = new EncodedContainer(65280, true, 0, baseDER, offset, returnLen);
            int min = (Integer)this.subtree[1].elementAt(index);
            IntegerContainer minimum = min == 0 ? new IntegerContainer(0x820000, false, 0, 0) : new IntegerContainer(0x820000, true, 0, min);
            int max = (Integer)this.subtree[2].elementAt(index);
            if (max == -1) {
                ASN1Container[] asn1Def = new ASN1Container[]{seq, base, minimum, end};
                templ = new ASN1Template(asn1Def);
            } else {
                IntegerContainer maximum = new IntegerContainer(0x810001, true, 0, max);
                ASN1Container[] asn1Def1 = new ASN1Container[]{seq, base, minimum, maximum, end};
                templ = new ASN1Template(asn1Def1);
            }
            int encodingLen = templ.derEncodeInit();
            byte[] encoding = new byte[encodingLen];
            encodingLen = templ.derEncode(encoding, 0);
            next = new EncodedContainer(12288, true, 0, encoding, 0, encodingLen);
        }
        catch (ASN_Exception asnException) {
            throw new NameException(" Can't encode GeneralSubtrees");
        }
        return next;
    }

    public boolean equals(Object obj) {
        int vectorIndex;
        if (obj == null || !(obj instanceof GeneralSubtrees)) {
            return false;
        }
        GeneralSubtrees other = (GeneralSubtrees)obj;
        int thisVectorSize = this.subtree[0].size();
        if (thisVectorSize != other.subtree[0].size()) {
            return false;
        }
        for (vectorIndex = 0; vectorIndex < thisVectorSize; ++vectorIndex) {
            GeneralName otherName;
            GeneralName thisName = (GeneralName)this.subtree[0].elementAt(vectorIndex);
            if (thisName.equals(otherName = (GeneralName)other.subtree[0].elementAt(vectorIndex))) continue;
            return false;
        }
        thisVectorSize = this.subtree[1].size();
        if (thisVectorSize != other.subtree[1].size()) {
            return false;
        }
        for (vectorIndex = 0; vectorIndex < thisVectorSize; ++vectorIndex) {
            int otherMin;
            int thisMin = (Integer)this.subtree[1].elementAt(vectorIndex);
            if (thisMin == (otherMin = ((Integer)other.subtree[1].elementAt(vectorIndex)).intValue())) continue;
            return false;
        }
        thisVectorSize = this.subtree[2].size();
        if (thisVectorSize != other.subtree[2].size()) {
            return false;
        }
        for (vectorIndex = 0; vectorIndex < thisVectorSize; ++vectorIndex) {
            int otherMax;
            int thisMax = (Integer)this.subtree[2].elementAt(vectorIndex);
            if (thisMax == (otherMax = ((Integer)other.subtree[2].elementAt(vectorIndex)).intValue())) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int index;
        int hashcode = 0;
        for (index = 0; index < this.subtree[0].size(); ++index) {
            GeneralName name = (GeneralName)this.subtree[0].elementAt(index);
            hashcode ^= name.hashCode();
        }
        for (index = 0; index < this.subtree[1].size(); ++index) {
            int min = (Integer)this.subtree[1].elementAt(index);
            hashcode ^= min * 17;
        }
        for (index = 0; index < this.subtree[2].size(); ++index) {
            int max = (Integer)this.subtree[2].elementAt(index);
            hashcode ^= max * 33;
        }
        return hashcode;
    }

    public Object clone() throws CloneNotSupportedException {
        GeneralSubtrees otherSelf = new GeneralSubtrees();
        for (int index = 0; index < this.subtree.length; ++index) {
            for (int treeIndex = 0; treeIndex < this.subtree[index].size(); ++treeIndex) {
                otherSelf.subtree[index].addElement(this.subtree[index].elementAt(treeIndex));
            }
        }
        otherSelf.special = this.special;
        if (this.asn1Template != null) {
            otherSelf.derEncodeInit();
        }
        return otherSelf;
    }
}

