/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.cert.extensions;

import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN1Lengths;
import com.rsa.asn1.ASN1Template;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.OIDContainer;
import com.rsa.certj.cert.CRLEntryExtension;
import com.rsa.certj.cert.CertificateException;
import com.rsa.certj.cert.OCSPSingleExtension;
import com.rsa.certj.cert.extensions.X509V3Extension;

public class HoldInstructionCode
extends X509V3Extension
implements CRLEntryExtension,
OCSPSingleExtension {
    private byte[] holdInstruction;
    private int holdInstructionOffset;
    private int holdInstructionLen;
    ASN1Template asn1TemplateValue;

    public HoldInstructionCode() {
        this.extensionTypeFlag = 23;
        this.criticality = false;
        this.setStandardOID(23);
        this.extensionTypeString = "HoldInstructionCode";
    }

    public HoldInstructionCode(byte[] holdInstruction, int offset, int len, boolean criticality) {
        this.extensionTypeFlag = 23;
        this.criticality = criticality;
        if (holdInstruction != null && len != 0) {
            this.setCode(holdInstruction, offset, len);
        }
        this.setStandardOID(23);
        this.extensionTypeString = "HoldInstructionCode";
    }

    public void setCode(byte[] holdInstruction, int offset, int len) {
        if (holdInstruction == null || len == 0) {
            return;
        }
        try {
            OIDContainer codeValue = new OIDContainer(0, true, 0, holdInstruction, offset, len);
            ASN1Container[] asn1Def = new ASN1Container[]{codeValue};
            this.holdInstruction = ASN1.derEncode((ASN1Container[])asn1Def);
            this.holdInstructionOffset = 1 + ASN1Lengths.determineLengthLen((byte[])this.holdInstruction, (int)1);
            this.holdInstructionLen = this.holdInstruction.length - this.holdInstructionOffset;
        }
        catch (ASN_Exception asnException) {
            this.holdInstruction = null;
            this.holdInstructionOffset = 0;
            this.holdInstructionLen = 0;
        }
    }

    public void decodeValue(byte[] valueBER, int offset) throws CertificateException {
        if (valueBER == null) {
            throw new CertificateException("Encoding is null.");
        }
        OIDContainer codeValue = new OIDContainer(0);
        ASN1Container[] asn1Def = new ASN1Container[]{codeValue};
        try {
            ASN1.berDecode((byte[])valueBER, (int)offset, (ASN1Container[])asn1Def);
        }
        catch (ASN_Exception asnException) {
            this.holdInstruction = null;
            throw new CertificateException("Could not decode HoldInstructionCode extension.");
        }
        this.setCode(codeValue.data, codeValue.dataOffset, codeValue.dataLen);
    }

    public byte[] getCode() {
        if (this.holdInstruction == null) {
            return null;
        }
        byte[] returnValue = new byte[this.holdInstructionLen];
        System.arraycopy(this.holdInstruction, this.holdInstructionOffset, returnValue, 0, this.holdInstructionLen);
        return returnValue;
    }

    public int derEncodeValueInit() {
        try {
            OIDContainer codeValue = new OIDContainer(0, true, 0, this.holdInstruction, this.holdInstructionOffset, this.holdInstructionLen);
            ASN1Container[] asn1Def = new ASN1Container[]{codeValue};
            this.asn1TemplateValue = new ASN1Template(asn1Def);
            return this.asn1TemplateValue.derEncodeInit();
        }
        catch (ASN_Exception asnException) {
            return 0;
        }
    }

    public int derEncodeValue(byte[] encoding, int offset) {
        if (encoding == null) {
            return 0;
        }
        if (this.asn1TemplateValue == null && this.derEncodeValueInit() == 0) {
            return 0;
        }
        try {
            int totalLen = this.asn1TemplateValue.derEncode(encoding, offset);
            this.asn1Template = null;
            return totalLen;
        }
        catch (ASN_Exception asnException) {
            this.asn1Template = null;
            return 0;
        }
    }

    public Object clone() throws CloneNotSupportedException {
        HoldInstructionCode otherSelf = new HoldInstructionCode();
        if (this.holdInstruction != null) {
            otherSelf.holdInstruction = (byte[])this.holdInstruction.clone();
            otherSelf.holdInstructionOffset = this.holdInstructionOffset;
            otherSelf.holdInstructionLen = this.holdInstructionLen;
        }
        super.copyValues(otherSelf);
        return otherSelf;
    }

    protected void reset() {
        super.reset();
        this.holdInstruction = null;
        this.holdInstructionLen = 0;
        this.holdInstructionOffset = 0;
    }
}

