/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.cert.extensions;

import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN1Template;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.EncodedContainer;
import com.rsa.asn1.EndContainer;
import com.rsa.asn1.OIDContainer;
import com.rsa.asn1.OfContainer;
import com.rsa.asn1.SequenceContainer;
import com.rsa.certj.cert.CertExtension;
import com.rsa.certj.cert.CertificateException;
import com.rsa.certj.cert.NameException;
import com.rsa.certj.cert.extensions.GeneralName;
import com.rsa.certj.cert.extensions.X509V3Extension;
import java.util.Vector;

public abstract class InfoAccess
extends X509V3Extension
implements CertExtension {
    private Vector<GeneralName> accessLocation = new Vector();
    private Vector<byte[]> accessMethod = new Vector();
    ASN1Template asn1TemplateValue;

    InfoAccess(int extensionTypeFlag, boolean criticality, byte[] oid, String extensionType) {
        this.extensionTypeFlag = extensionTypeFlag;
        this.criticality = criticality;
        this.setSpecialOID(oid);
        this.extensionTypeString = extensionType;
    }

    public void addAccessDescription(byte[] accessMethod, int offset, int len, GeneralName accessLocation) throws CertificateException {
        if (accessMethod == null || len <= 0 || accessLocation == null) {
            throw new CertificateException("Missing values");
        }
        byte[] method = new byte[len];
        System.arraycopy(accessMethod, offset, method, 0, len);
        this.accessMethod.addElement(method);
        this.accessLocation.addElement(accessLocation);
    }

    public GeneralName getAccessLocation(int index) throws CertificateException {
        if (index < this.accessLocation.size()) {
            return this.accessLocation.elementAt(index);
        }
        throw new CertificateException("Index is invalid.");
    }

    public byte[] getAccessMethod(int index) throws CertificateException {
        if (index < this.accessMethod.size()) {
            return this.accessMethod.elementAt(index);
        }
        throw new CertificateException("Index is invalid.");
    }

    public int getAccessDescriptionCount() {
        return this.accessMethod.size();
    }

    public void decodeValue(byte[] valueBER, int offset) throws CertificateException {
        if (valueBER == null) {
            throw new CertificateException("Encoding is null.");
        }
        try {
            OfContainer seqOf = new OfContainer(0, 12288, (ASN1Container)new EncodedContainer(12288));
            ASN1Container[] asnDef = new ASN1Container[]{seqOf};
            ASN1.berDecode((byte[])valueBER, (int)offset, (ASN1Container[])asnDef);
            int count = seqOf.getContainerCount();
            for (int index = 0; index < count; ++index) {
                ASN1Container encodedContainer = seqOf.containerAt(index);
                SequenceContainer seq = new SequenceContainer(0);
                EndContainer anEnd = new EndContainer();
                OIDContainer method = new OIDContainer(0x1000000);
                EncodedContainer location = new EncodedContainer(65280);
                ASN1Container[] asn1Def = new ASN1Container[]{seq, method, location, anEnd};
                ASN1.berDecode((byte[])encodedContainer.data, (int)encodedContainer.dataOffset, (ASN1Container[])asn1Def);
                if (method.data != null && method.dataLen != 0) {
                    byte[] oid = new byte[method.dataLen];
                    System.arraycopy(method.data, method.dataOffset, oid, 0, method.dataLen);
                    this.accessMethod.addElement(oid);
                }
                this.accessLocation.addElement(new GeneralName(location.data, location.dataOffset, 0));
            }
        }
        catch (ASN_Exception asnException) {
            throw new CertificateException("Could not decode AuthorityInfoAccess extension.");
        }
        catch (NameException nameException) {
            throw new CertificateException("Could not decode AuthorityInfoAccess extension.");
        }
    }

    public int derEncodeValueInit() {
        if (this.accessLocation.isEmpty()) {
            return 0;
        }
        try {
            Vector<OfContainer> asn1Def = new Vector<OfContainer>();
            OfContainer seqOf = new OfContainer(0, true, 0, 12288, (ASN1Container)new EncodedContainer(12288));
            asn1Def.addElement(seqOf);
            for (int index = 0; index < this.accessMethod.size(); ++index) {
                EncodedContainer encContainer = this.encodeDescription(index);
                seqOf.addContainer((ASN1Container)encContainer);
            }
            Object[] asn1DefArray = new ASN1Container[asn1Def.size()];
            asn1Def.copyInto(asn1DefArray);
            this.asn1TemplateValue = new ASN1Template((ASN1Container[])asn1DefArray);
            return this.asn1TemplateValue.derEncodeInit();
        }
        catch (Exception anyExc) {
            return 0;
        }
    }

    private EncodedContainer encodeDescription(int index) throws CertificateException {
        EncodedContainer next;
        SequenceContainer seq = new SequenceContainer(0, true, 0);
        EndContainer end = new EndContainer();
        byte[] oid = this.accessMethod.elementAt(index);
        try {
            OIDContainer id = new OIDContainer(0x1000000, true, 0, oid, 0, oid.length);
            GeneralName location = this.accessLocation.elementAt(index);
            byte[] encoding = new byte[location.getDERLen(0)];
            int len = location.getDEREncoding(encoding, 0, 0);
            EncodedContainer loc = new EncodedContainer(0, true, 0, encoding, 0, len);
            ASN1Container[] asn1Def = new ASN1Container[]{seq, id, loc, end};
            ASN1Template templ = new ASN1Template(asn1Def);
            int encodingLen = templ.derEncodeInit();
            byte[] desc = new byte[encodingLen];
            encodingLen = templ.derEncode(desc, 0);
            next = new EncodedContainer(12288, true, 0, desc, 0, encodingLen);
        }
        catch (ASN_Exception asnException) {
            throw new CertificateException(" Can't encode Access Description");
        }
        catch (NameException nameException) {
            throw new CertificateException("Could not encode Access Description ");
        }
        return next;
    }

    public int derEncodeValue(byte[] encoding, int offset) {
        if (this.asn1TemplateValue == null && this.derEncodeValueInit() == 0) {
            return 0;
        }
        try {
            return this.asn1TemplateValue.derEncode(encoding, offset);
        }
        catch (ASN_Exception asnException) {
            return 0;
        }
    }

    protected void copyValues(X509V3Extension otherSelf) {
        InfoAccess other = (InfoAccess)otherSelf;
        for (int index = 0; index < this.accessMethod.size(); ++index) {
            other.accessMethod.addElement(this.accessMethod.elementAt(index));
            other.accessLocation.addElement(this.accessLocation.elementAt(index));
        }
        if (this.asn1TemplateValue != null) {
            other.derEncodeValueInit();
        }
        super.copyValues(other);
    }

    protected void reset() {
        super.reset();
        this.accessMethod = new Vector();
        this.accessLocation = new Vector();
    }
}

