/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.cert.extensions;

import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN1Template;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.GenTimeContainer;
import com.rsa.certj.cert.CRLEntryExtension;
import com.rsa.certj.cert.CertificateException;
import com.rsa.certj.cert.OCSPSingleExtension;
import com.rsa.certj.cert.extensions.X509V3Extension;
import java.util.Date;

public class InvalidityDate
extends X509V3Extension
implements CRLEntryExtension,
OCSPSingleExtension {
    private Date date;
    ASN1Template asn1TemplateValue;

    public InvalidityDate() {
        this.extensionTypeFlag = 24;
        this.criticality = false;
        this.setStandardOID(24);
        this.extensionTypeString = "InvalidityDate";
    }

    public InvalidityDate(Date date, boolean criticality) {
        this.extensionTypeFlag = 24;
        this.criticality = criticality;
        if (date != null) {
            this.date = new Date(date.getTime());
        }
        this.setStandardOID(24);
        this.extensionTypeString = "InvalidityDate";
    }

    public void decodeValue(byte[] valueBER, int offset) throws CertificateException {
        if (valueBER == null) {
            throw new CertificateException("Encoding is null.");
        }
        GenTimeContainer dateValue = new GenTimeContainer(0);
        ASN1Container[] asn1Def = new ASN1Container[]{dateValue};
        try {
            ASN1.berDecode((byte[])valueBER, (int)offset, (ASN1Container[])asn1Def);
        }
        catch (ASN_Exception asnException) {
            throw new CertificateException("Could not decode InvalidityDate extension.");
        }
        this.date = dateValue.theTime;
    }

    public void setDate(Date date) {
        if (date != null) {
            this.date = new Date(date.getTime());
        }
    }

    public Date getDate() {
        if (this.date == null) {
            return null;
        }
        return new Date(this.date.getTime());
    }

    public int derEncodeValueInit() {
        GenTimeContainer dateValue = new GenTimeContainer(0, true, 0, this.date);
        ASN1Container[] asn1Def = new ASN1Container[]{dateValue};
        this.asn1TemplateValue = new ASN1Template(asn1Def);
        try {
            return this.asn1TemplateValue.derEncodeInit();
        }
        catch (ASN_Exception asnException) {
            return 0;
        }
    }

    public int derEncodeValue(byte[] encoding, int offset) {
        if (encoding == null) {
            return 0;
        }
        if (this.asn1TemplateValue == null && this.derEncodeValueInit() == 0) {
            return 0;
        }
        try {
            int totalLen = this.asn1TemplateValue.derEncode(encoding, offset);
            this.asn1Template = null;
            return totalLen;
        }
        catch (ASN_Exception asnException) {
            this.asn1Template = null;
            return 0;
        }
    }

    public Object clone() throws CloneNotSupportedException {
        InvalidityDate otherSelf = new InvalidityDate();
        if (this.date != null) {
            otherSelf.date = new Date(this.date.getTime());
        }
        if (this.asn1TemplateValue != null) {
            otherSelf.derEncodeValueInit();
        }
        super.copyValues(otherSelf);
        return otherSelf;
    }

    protected void reset() {
        super.reset();
        this.date = null;
        this.asn1TemplateValue = null;
    }
}

