/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.cert.extensions;

import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN1Template;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.EncodedContainer;
import com.rsa.certj.cert.CRLExtension;
import com.rsa.certj.cert.CertExtension;
import com.rsa.certj.cert.CertificateException;
import com.rsa.certj.cert.NameException;
import com.rsa.certj.cert.extensions.GeneralName;
import com.rsa.certj.cert.extensions.GeneralNames;
import com.rsa.certj.cert.extensions.X509V3Extension;

public class IssuerAltName
extends X509V3Extension
implements CertExtension,
CRLExtension {
    private GeneralNames generalNames = new GeneralNames();
    ASN1Template asn1TemplateValue;

    public IssuerAltName() {
        this.extensionTypeFlag = 18;
        this.criticality = false;
        this.setStandardOID(18);
        this.extensionTypeString = "IssuerAltName";
    }

    public IssuerAltName(GeneralNames name, boolean criticality) throws CertificateException {
        this.extensionTypeFlag = 18;
        this.criticality = criticality;
        if (name == null) {
            throw new CertificateException("Encoding is null.");
        }
        try {
            this.generalNames = (GeneralNames)name.clone();
        }
        catch (CloneNotSupportedException cloneExc) {
            throw new CertificateException("Can't initialize IssuerAltName");
        }
        this.setStandardOID(18);
        this.extensionTypeString = "IssuerAltName";
    }

    public void addGeneralName(GeneralName name) {
        if (name != null) {
            this.generalNames.addGeneralName(name);
        }
    }

    public void setGeneralNames(GeneralNames names) throws CertificateException {
        try {
            if (names != null) {
                this.generalNames = (GeneralNames)names.clone();
            }
        }
        catch (CloneNotSupportedException cloneExc) {
            throw new CertificateException("Can't add new name to IssuerAltName");
        }
    }

    public GeneralNames getGeneralNames() {
        return this.generalNames;
    }

    public void decodeValue(byte[] valueBER, int offset) throws CertificateException {
        if (valueBER == null) {
            throw new CertificateException("Encoding is null.");
        }
        try {
            this.generalNames = new GeneralNames(valueBER, offset, 0);
        }
        catch (NameException nameExc) {
            throw new CertificateException("Could not decode IssuerAltName extension.");
        }
    }

    public int derEncodeValueInit() {
        try {
            byte[] encoding = new byte[this.generalNames.getDERLen(0)];
            int len = this.generalNames.getDEREncoding(encoding, 0, 0);
            EncodedContainer nameContainer = new EncodedContainer(12288, true, 0, encoding, 0, len);
            ASN1Container[] asn1Def = new ASN1Container[]{nameContainer};
            this.asn1TemplateValue = new ASN1Template(asn1Def);
        }
        catch (Exception anyExc) {
            return 0;
        }
        try {
            return this.asn1TemplateValue.derEncodeInit();
        }
        catch (ASN_Exception asnException) {
            return 0;
        }
    }

    public int derEncodeValue(byte[] encoding, int offset) {
        if (encoding == null) {
            return 0;
        }
        if (this.asn1TemplateValue == null && this.derEncodeValueInit() == 0) {
            return 0;
        }
        try {
            return this.asn1TemplateValue.derEncode(encoding, offset);
        }
        catch (ASN_Exception asnException) {
            return 0;
        }
    }

    public Object clone() throws CloneNotSupportedException {
        IssuerAltName otherSelf = new IssuerAltName();
        if (this.generalNames != null) {
            otherSelf.generalNames = (GeneralNames)this.generalNames.clone();
        }
        if (this.asn1TemplateValue != null) {
            otherSelf.derEncodeValueInit();
        }
        super.copyValues(otherSelf);
        return otherSelf;
    }

    protected void reset() {
        super.reset();
        this.generalNames = new GeneralNames();
    }
}

