/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.cert.extensions;

import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN1Template;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.EncodedContainer;
import com.rsa.asn1.EndContainer;
import com.rsa.asn1.SequenceContainer;
import com.rsa.certj.cert.CertExtension;
import com.rsa.certj.cert.CertificateException;
import com.rsa.certj.cert.NameException;
import com.rsa.certj.cert.extensions.GeneralSubtrees;
import com.rsa.certj.cert.extensions.X509V3Extension;

public class NameConstraints
extends X509V3Extension
implements CertExtension {
    private GeneralSubtrees permittedSubtrees;
    private static final int PERMITTED_SPECIAL = 0x810000;
    private GeneralSubtrees excludedSubtrees;
    private static final int EXCLUDED_SPECIAL = 0x810001;
    ASN1Template asn1TemplateValue;

    public NameConstraints() {
        this.extensionTypeFlag = 30;
        this.criticality = false;
        this.permittedSubtrees = new GeneralSubtrees();
        this.excludedSubtrees = new GeneralSubtrees();
        this.setStandardOID(30);
        this.extensionTypeString = "NameConstraints";
    }

    public NameConstraints(GeneralSubtrees permittedSubtrees, GeneralSubtrees excludedSubtrees, boolean criticality) {
        this.extensionTypeFlag = 30;
        this.criticality = criticality;
        if (permittedSubtrees != null) {
            this.permittedSubtrees = permittedSubtrees;
        }
        if (excludedSubtrees != null) {
            this.excludedSubtrees = excludedSubtrees;
        }
        this.setStandardOID(30);
        this.extensionTypeString = "NameConstraints";
    }

    public void decodeValue(byte[] valueBER, int offset) throws CertificateException {
        if (valueBER == null) {
            throw new CertificateException("Encoding is null.");
        }
        SequenceContainer seq = new SequenceContainer(0);
        EndContainer anEnd = new EndContainer();
        EncodedContainer permitted = new EncodedContainer(8466432);
        EncodedContainer excluded = new EncodedContainer(8466433);
        ASN1Container[] asn1Def = new ASN1Container[]{seq, permitted, excluded, anEnd};
        try {
            ASN1.berDecode((byte[])valueBER, (int)offset, (ASN1Container[])asn1Def);
        }
        catch (ASN_Exception asnException) {
            throw new CertificateException("Could not decode Name Contraints extension.");
        }
        try {
            if (permitted.dataPresent) {
                this.permittedSubtrees = new GeneralSubtrees(permitted.data, permitted.dataOffset, 0x810000);
            }
            if (excluded.dataPresent) {
                this.excludedSubtrees = new GeneralSubtrees(excluded.data, excluded.dataOffset, 0x810001);
            }
        }
        catch (NameException nameException) {
            throw new CertificateException("Could not decode Name Constraints extension!!!.");
        }
    }

    public void setPermittedSubtrees(GeneralSubtrees subTree) {
        if (subTree != null) {
            this.permittedSubtrees = subTree;
        }
    }

    public void setExcludedSubtrees(GeneralSubtrees subTree) {
        if (subTree != null) {
            this.excludedSubtrees = subTree;
        }
    }

    public GeneralSubtrees getPermittedSubtrees() {
        return this.permittedSubtrees;
    }

    public GeneralSubtrees getExcludedSubtrees() {
        return this.excludedSubtrees;
    }

    public int derEncodeValueInit() {
        SequenceContainer seq = new SequenceContainer(0, true, 0);
        EndContainer anEnd = new EndContainer();
        EncodedContainer permitted = null;
        EncodedContainer excluded = null;
        try {
            int returnLen;
            int offset;
            byte[] subtreeDER;
            int derLen;
            if (this.permittedSubtrees != null) {
                derLen = this.permittedSubtrees.getDERLen(0x810000);
                subtreeDER = new byte[derLen];
                offset = 0;
                returnLen = this.permittedSubtrees.getDEREncoding(subtreeDER, offset, 0x810000);
                permitted = new EncodedContainer(8466432, true, 0, subtreeDER, offset, returnLen);
            }
            if (this.excludedSubtrees != null) {
                derLen = this.excludedSubtrees.getDERLen(0x810001);
                subtreeDER = new byte[derLen];
                offset = 0;
                returnLen = this.excludedSubtrees.getDEREncoding(subtreeDER, offset, 0x810001);
                excluded = new EncodedContainer(8466433, true, 0, subtreeDER, offset, returnLen);
            }
        }
        catch (ASN_Exception e) {
            return 0;
        }
        catch (NameException nameException) {
            return 0;
        }
        if (permitted != null) {
            if (excluded != null) {
                ASN1Container[] asn1Def = new ASN1Container[]{seq, permitted, excluded, anEnd};
                this.asn1TemplateValue = new ASN1Template(asn1Def);
            } else {
                ASN1Container[] asn1Def = new ASN1Container[]{seq, permitted, anEnd};
                this.asn1TemplateValue = new ASN1Template(asn1Def);
            }
        } else if (excluded != null) {
            ASN1Container[] asn1Def = new ASN1Container[]{seq, excluded, anEnd};
            this.asn1TemplateValue = new ASN1Template(asn1Def);
        } else {
            ASN1Container[] asn1Def = new ASN1Container[]{seq, anEnd};
            this.asn1TemplateValue = new ASN1Template(asn1Def);
        }
        try {
            return this.asn1TemplateValue.derEncodeInit();
        }
        catch (ASN_Exception asnException) {
            return 0;
        }
    }

    public int derEncodeValue(byte[] encoding, int offset) {
        if (encoding == null) {
            return 0;
        }
        if (this.asn1TemplateValue == null && this.derEncodeValueInit() == 0) {
            return 0;
        }
        try {
            int totalLen = this.asn1TemplateValue.derEncode(encoding, offset);
            this.asn1Template = null;
            return totalLen;
        }
        catch (ASN_Exception asnException) {
            this.asn1Template = null;
            return 0;
        }
    }

    public Object clone() throws CloneNotSupportedException {
        GeneralSubtrees permittedSubtrees = null;
        if (this.permittedSubtrees != null) {
            permittedSubtrees = (GeneralSubtrees)this.permittedSubtrees.clone();
        }
        GeneralSubtrees excludedSubtrees = null;
        if (this.excludedSubtrees != null) {
            excludedSubtrees = (GeneralSubtrees)this.excludedSubtrees.clone();
        }
        NameConstraints otherSelf = new NameConstraints(permittedSubtrees, excludedSubtrees, this.criticality);
        if (this.asn1TemplateValue != null) {
            otherSelf.derEncodeValueInit();
        }
        super.copyValues(otherSelf);
        return otherSelf;
    }

    protected void reset() {
        super.reset();
        this.permittedSubtrees = null;
        this.excludedSubtrees = null;
        this.asn1TemplateValue = null;
    }
}

