/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.cert.extensions;

import com.rsa.certj.cert.NameException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.StringTokenizer;

final class NameUtils {
    private NameUtils() {
    }

    public static void validateURLName(String name) throws NameException {
        block6: {
            if (name.length() > 6 && name.substring(0, 6).equalsIgnoreCase("mailto")) {
                try {
                    URI uri = new URI(name);
                    if (!uri.isAbsolute()) {
                        throw new NameException("Invalid URL");
                    }
                    break block6;
                }
                catch (URISyntaxException e) {
                    throw new NameException(e);
                }
            }
            try {
                new URL(name);
            }
            catch (MalformedURLException e) {
                throw new NameException(e);
            }
        }
    }

    public static void validateRFC822Name(String name) throws NameException {
        if (name == null) {
            throw new NameException("Name is null!");
        }
        int indexOfAt = name.indexOf(64);
        if (indexOfAt == -1) {
            throw new NameException("An RFC822 name must contain the @ symbol.");
        }
        if (name.indexOf(64, indexOfAt + 1) != -1) {
            throw new NameException("An RFC822 name can contain only one @ symbol.");
        }
        NameUtils.validateLocalPart(name.substring(0, indexOfAt));
        NameUtils.validateDomain(name.substring(indexOfAt + 1));
    }

    private static void validateDomain(String domainName) throws NameException {
        if (domainName.length() == 0) {
            throw new NameException("Illegal empty domain name!");
        }
        int numSubdomainParts = 4;
        int lastPartIndex = 3;
        TokenizerWithEmptyStrings tokenizer = new TokenizerWithEmptyStrings(domainName);
        while (tokenizer.hasMoreTokens()) {
            String nextSubdomain = tokenizer.nextToken();
            if (nextSubdomain.startsWith("[")) {
                String[] subdomainParts = new String[4];
                subdomainParts[0] = nextSubdomain.substring(1);
                for (int i = 1; i < subdomainParts.length; ++i) {
                    if (!tokenizer.hasMoreTokens()) {
                        throw new NameException("Illegal domain name: " + domainName);
                    }
                    subdomainParts[i] = tokenizer.nextToken();
                }
                if (!subdomainParts[3].endsWith("]")) {
                    throw new NameException("Illegal domain name: " + domainName);
                }
                String lastPart = subdomainParts[3];
                subdomainParts[3] = lastPart.substring(0, lastPart.length() - 1);
                NameUtils.validateDomainLiteral(subdomainParts);
                continue;
            }
            NameUtils.validateAtom(nextSubdomain);
        }
    }

    private static void validateDomainLiteral(String[] literalParts) throws NameException {
        boolean minByteValue = false;
        int maxByteValue = 255;
        for (int i = 0; i < literalParts.length; ++i) {
            int byteValue = Integer.parseInt(literalParts[i]);
            if (byteValue >= 0 && byteValue <= 255) continue;
            throw new NameException("Invalid domain literal part: " + literalParts[i]);
        }
    }

    private static void validateLocalPart(String localPart) throws NameException {
        if (localPart.length() == 0) {
            throw new NameException("Empty local part is not allowed in an RFC822 name");
        }
        TokenizerWithEmptyStrings tokenizer = new TokenizerWithEmptyStrings(localPart);
        while (tokenizer.hasMoreTokens()) {
            String nextWord = tokenizer.nextToken();
            if (nextWord.startsWith("\"")) {
                while (tokenizer.hasMoreTokens() && !nextWord.endsWith("\"")) {
                    nextWord = nextWord + tokenizer.nextToken();
                }
            }
            NameUtils.validateWord(nextWord);
        }
    }

    private static void validateWord(String nextWord) throws NameException {
        if (nextWord.length() == 0) {
            throw new NameException("Invalid word in local part of RFC822 name: " + nextWord);
        }
        if (nextWord.startsWith("\"")) {
            NameUtils.validateQuotedString(nextWord);
        } else {
            NameUtils.validateAtom(nextWord);
        }
    }

    private static void validateAtom(String atom) throws NameException {
        if (atom.length() == 0) {
            throw new NameException("An atom must be at least 1 character long!");
        }
        String specials = " ()<>@,;:\\/\".[]";
        int ctlCharsUpperLimit = 32;
        int delChar = 127;
        for (int i = 0; i < atom.length(); ++i) {
            char nextChar = atom.charAt(i);
            if (nextChar < ' ' || nextChar == '\u007f') {
                throw new NameException("Illegal character in atom " + atom);
            }
            if (" ()<>@,;:\\/\".[]".indexOf(nextChar) == -1) continue;
            throw new NameException("Atom " + atom + " contains the special character " + nextChar);
        }
    }

    private static void validateQuotedString(String quotedString) throws NameException {
        int lastIndex = quotedString.length() - 1;
        if (quotedString.length() < 2 || quotedString.charAt(0) != '\"' || quotedString.charAt(lastIndex) != '\"') {
            throw new NameException("Illegal quoted string: " + quotedString);
        }
        for (int i = 1; i < lastIndex; ++i) {
            char currentChar = quotedString.charAt(i);
            if (currentChar == '\\') {
                if (++i != lastIndex) continue;
                throw new NameException("\\ escapes the closing quote in " + quotedString);
            }
            if (currentChar == '\"') {
                throw new NameException("Illegal character " + currentChar + " in " + quotedString);
            }
            if (currentChar != '\r') continue;
            if ((currentChar = quotedString.charAt(++i)) != '\n') {
                throw new NameException("Illegal CR character in " + quotedString);
            }
            if ((currentChar = quotedString.charAt(++i)) == ' ' || currentChar == '\t') continue;
            throw new NameException("CRLF sequence in " + quotedString + " must be followed by a space or a tab.");
        }
    }

    public static void validateDnsName(String name) throws NameException {
        if (name == null) {
            throw new NameException("Name is null!");
        }
        if (name.equals(" ")) {
            return;
        }
        TokenizerWithEmptyStrings tokenizer = new TokenizerWithEmptyStrings(name);
        while (tokenizer.hasMoreTokens()) {
            String dnslabel = tokenizer.nextToken();
            NameUtils.validateDnsLabel(dnslabel);
        }
    }

    private static boolean isAsciiLetter(char ch) {
        return ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z';
    }

    private static boolean isDigit(char ch) {
        return ch >= '0' && ch <= '9';
    }

    private static void validateDnsLabel(String dnsLabel) throws NameException {
        if (dnsLabel.length() == 0) {
            throw new NameException("A subdomain cannot be an empty string!");
        }
        if (!NameUtils.isAsciiLetter(dnsLabel.charAt(0))) {
            throw new NameException("A subdomain must start with a letter!");
        }
        if (dnsLabel.charAt(dnsLabel.length() - 1) == '-') {
            throw new NameException("The last character in a subdomain cannot be a hyphen!");
        }
        for (int i = 0; i < dnsLabel.length(); ++i) {
            if (NameUtils.isValidDnsChar(dnsLabel.charAt(i))) continue;
            throw new NameException("Invalid character in domain name: " + dnsLabel.charAt(i));
        }
    }

    private static boolean isValidDnsChar(char ch) {
        return ch == '-' || NameUtils.isAsciiLetter(ch) || NameUtils.isDigit(ch);
    }

    private static class TokenizerWithEmptyStrings {
        private static final String DOT_TOKEN = ".";
        private static final String EMPTY_STRING_TOKEN = "";
        private StringTokenizer tokenizer;
        private boolean hasMoreTokens;

        TokenizerWithEmptyStrings(String string) {
            this.tokenizer = new StringTokenizer(string, DOT_TOKEN, true);
            this.hasMoreTokens = this.tokenizer.hasMoreTokens();
        }

        public String nextToken() {
            if (this.hasMoreTokens && !this.tokenizer.hasMoreTokens()) {
                this.hasMoreTokens = false;
                return EMPTY_STRING_TOKEN;
            }
            String next = this.tokenizer.nextToken();
            if (DOT_TOKEN.equals(next)) {
                return EMPTY_STRING_TOKEN;
            }
            if (!this.tokenizer.hasMoreTokens()) {
                this.hasMoreTokens = false;
            } else {
                this.tokenizer.nextToken();
            }
            return next;
        }

        public boolean hasMoreTokens() {
            return this.hasMoreTokens;
        }
    }
}

