/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.cert.extensions;

import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN1Template;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.IA5StringContainer;
import com.rsa.certj.cert.CertExtension;
import com.rsa.certj.cert.CertificateException;
import com.rsa.certj.cert.extensions.X509V3Extension;

public class NetscapeSSLServerName
extends X509V3Extension
implements CertExtension {
    private String serverName;
    ASN1Template asn1TemplateValue;

    public NetscapeSSLServerName() {
        this.extensionTypeFlag = 107;
        this.criticality = false;
        this.setSpecialOID(NETSCAPE_SSL_SERVER_NAME_OID);
        this.extensionTypeString = "NetscapeSSLServerName";
    }

    public NetscapeSSLServerName(String serverName, boolean criticality) {
        this.extensionTypeFlag = 107;
        this.criticality = criticality;
        this.setSpecialOID(NETSCAPE_SSL_SERVER_NAME_OID);
        if (serverName != null) {
            this.serverName = serverName;
        }
        this.extensionTypeString = "NetscapeSSLServerName";
    }

    public void decodeValue(byte[] valueBER, int offset) throws CertificateException {
        if (valueBER == null) {
            throw new CertificateException("Encoding is null.");
        }
        try {
            IA5StringContainer urlString = new IA5StringContainer(0);
            ASN1Container[] asn1Def = new ASN1Container[]{urlString};
            ASN1.berDecode((byte[])valueBER, (int)offset, (ASN1Container[])asn1Def);
            this.serverName = urlString.getValueAsString();
        }
        catch (ASN_Exception asnException) {
            throw new CertificateException("Could not decode NetscapeSSLServerName extension.");
        }
    }

    public void setSSLServerName(String serverName) {
        if (serverName != null) {
            this.serverName = serverName;
        }
    }

    public String getSSLServerName() {
        return this.serverName;
    }

    public int derEncodeValueInit() {
        try {
            IA5StringContainer urlString = new IA5StringContainer(0, true, 0, this.serverName);
            ASN1Container[] asn1Def = new ASN1Container[]{urlString};
            this.asn1TemplateValue = new ASN1Template(asn1Def);
            return this.asn1TemplateValue.derEncodeInit();
        }
        catch (ASN_Exception asnException) {
            return 0;
        }
    }

    public int derEncodeValue(byte[] encoding, int offset) {
        if (encoding == null) {
            return 0;
        }
        if (this.asn1TemplateValue == null && this.derEncodeValueInit() == 0) {
            return 0;
        }
        try {
            int totalLen = this.asn1TemplateValue.derEncode(encoding, offset);
            this.asn1Template = null;
            return totalLen;
        }
        catch (ASN_Exception asnException) {
            this.asn1Template = null;
            return 0;
        }
    }

    public Object clone() throws CloneNotSupportedException {
        NetscapeSSLServerName otherSelf = new NetscapeSSLServerName();
        otherSelf.serverName = this.serverName;
        if (this.asn1TemplateValue != null) {
            otherSelf.derEncodeValueInit();
        }
        super.copyValues(otherSelf);
        return otherSelf;
    }

    protected void reset() {
        super.reset();
        this.serverName = null;
        this.asn1TemplateValue = null;
    }
}

