/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.cert.extensions;

import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN1Template;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.EncodedContainer;
import com.rsa.asn1.OIDContainer;
import com.rsa.asn1.OfContainer;
import com.rsa.certj.InvalidParameterException;
import com.rsa.certj.cert.CertificateException;
import com.rsa.certj.cert.OCSPRequestExtension;
import com.rsa.certj.cert.extensions.X509V3Extension;
import java.util.Vector;

public class OCSPAcceptableResponses
extends X509V3Extension
implements OCSPRequestExtension {
    ASN1Template asn1TemplateValue;
    Vector<byte[]> acceptableResponsesOID;
    public static final byte[] ID_PKIX_OCSP_BASIC = new byte[]{43, 6, 1, 5, 5, 7, 48, 1, 1};

    public OCSPAcceptableResponses() {
        this.extensionTypeFlag = 121;
        this.criticality = false;
        this.setSpecialOID(OCSP_ACCEPTABLE_RESPONSES_OID);
        this.extensionTypeString = "OCSPAcceptableResponses";
        this.acceptableResponsesOID = null;
    }

    public void addAcceptableResponse(byte[] acceptableResponseType, int typeOffset, int typeLen) throws CertificateException {
        if (acceptableResponseType == null || typeLen == 0) {
            throw new CertificateException("Missing values");
        }
        byte[] responseTypeOID = new byte[typeLen];
        System.arraycopy(acceptableResponseType, typeOffset, responseTypeOID, 0, typeLen);
        if (this.acceptableResponsesOID == null) {
            this.acceptableResponsesOID = new Vector();
        }
        this.acceptableResponsesOID.addElement(responseTypeOID);
    }

    public int getAcceptableResponseCount() {
        if (this.acceptableResponsesOID != null) {
            return this.acceptableResponsesOID.size();
        }
        return 0;
    }

    public byte[] getAcceptableResponse(int index) throws InvalidParameterException {
        if (this.acceptableResponsesOID == null) {
            return null;
        }
        if (this.acceptableResponsesOID.size() <= index) {
            throw new InvalidParameterException("Specified index is invalid.");
        }
        return this.acceptableResponsesOID.elementAt(index);
    }

    public void decodeValue(byte[] valueBER, int offset) throws CertificateException {
        if (valueBER == null) {
            throw new CertificateException("Encoding is null.");
        }
        try {
            OfContainer seqOf = new OfContainer(this.special, 12288, (ASN1Container)new EncodedContainer(1536));
            ASN1Container[] oidDef = new ASN1Container[]{seqOf};
            ASN1.berDecode((byte[])valueBER, (int)offset, (ASN1Container[])oidDef);
            int oidCount = seqOf.getContainerCount();
            for (int index = 0; index < oidCount; ++index) {
                ASN1Container encodedOIDContainer = seqOf.containerAt(index);
                OIDContainer acceptableRespOID = new OIDContainer(0x1000000);
                ASN1Container[] asn1Def = new ASN1Container[]{acceptableRespOID};
                ASN1.berDecode((byte[])encodedOIDContainer.data, (int)encodedOIDContainer.dataOffset, (ASN1Container[])asn1Def);
                if (this.acceptableResponsesOID == null) {
                    this.acceptableResponsesOID = new Vector();
                }
                byte[] responseTypeOID = new byte[acceptableRespOID.dataLen];
                System.arraycopy(acceptableRespOID.data, acceptableRespOID.dataOffset, responseTypeOID, 0, acceptableRespOID.dataLen);
                this.acceptableResponsesOID.addElement(responseTypeOID);
            }
        }
        catch (ASN_Exception asnException) {
            throw new CertificateException("Could not decode Extended Key Usage extension.");
        }
    }

    public int derEncodeValueInit() {
        if (this.acceptableResponsesOID == null) {
            return 0;
        }
        int oidListSize = this.acceptableResponsesOID.size();
        if (oidListSize == 0) {
            return 0;
        }
        Vector<OfContainer> asn1Def = new Vector<OfContainer>();
        try {
            OfContainer seqOf = new OfContainer(0, true, 0, 12288, (ASN1Container)new EncodedContainer(1536));
            asn1Def.addElement(seqOf);
            for (int index = 0; index < oidListSize; ++index) {
                try {
                    EncodedContainer oidContainer = this.encodeOID(index);
                    seqOf.addContainer((ASN1Container)oidContainer);
                    continue;
                }
                catch (Exception anyExc) {
                    return 0;
                }
            }
            Object[] asn1DefArray = new ASN1Container[asn1Def.size()];
            asn1Def.copyInto(asn1DefArray);
            this.asn1TemplateValue = new ASN1Template((ASN1Container[])asn1DefArray);
            return this.asn1TemplateValue.derEncodeInit();
        }
        catch (ASN_Exception asnException) {
            return 0;
        }
    }

    public int derEncodeValue(byte[] encoding, int offset) {
        if (encoding == null) {
            return 0;
        }
        if (this.asn1TemplateValue == null && this.derEncodeValueInit() == 0) {
            return 0;
        }
        try {
            int totalLen = this.asn1TemplateValue.derEncode(encoding, offset);
            this.asn1Template = null;
            return totalLen;
        }
        catch (ASN_Exception asnException) {
            this.asn1Template = null;
            return 0;
        }
    }

    private EncodedContainer encodeOID(int index) throws CertificateException {
        try {
            byte[] acceptableResponseTypeByte = this.acceptableResponsesOID.elementAt(index);
            int len = acceptableResponseTypeByte.length;
            OIDContainer acceptableResptype = new OIDContainer(0x1000000, true, 0, acceptableResponseTypeByte, 0, len);
            ASN1Container[] asn1Def = new ASN1Container[]{acceptableResptype};
            ASN1Template templ = new ASN1Template(asn1Def);
            int encodingLen = templ.derEncodeInit();
            byte[] encoding = new byte[encodingLen];
            encodingLen = templ.derEncode(encoding, 0);
            return new EncodedContainer(1536, true, 0, encoding, 0, encodingLen);
        }
        catch (ASN_Exception asnException) {
            throw new CertificateException(" Can't encode Acceptable Response Type");
        }
    }

    public Object clone() throws CloneNotSupportedException {
        OCSPAcceptableResponses otherSelf = new OCSPAcceptableResponses();
        if (this.acceptableResponsesOID != null) {
            otherSelf.acceptableResponsesOID = new Vector<byte[]>(this.acceptableResponsesOID);
        }
        if (this.asn1TemplateValue != null) {
            otherSelf.derEncodeValueInit();
        }
        super.copyValues(otherSelf);
        return otherSelf;
    }

    protected void reset() {
        super.reset();
        this.asn1TemplateValue = null;
    }
}

