/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.cert.extensions;

import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN1Lengths;
import com.rsa.asn1.ASN1Template;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.EndContainer;
import com.rsa.asn1.PrintStringContainer;
import com.rsa.asn1.SetContainer;
import com.rsa.certj.cert.NameException;
import java.io.Serializable;
import java.util.Arrays;

public class PersonalName
implements Cloneable,
Serializable {
    private String surname;
    private String givenName;
    private String initials;
    private String generation;
    protected int special;
    protected ASN1Template asn1Template;
    private static final int SURNAME_SPECIAL = 0x800000;
    private static final int GIVEN_NAME_SPECIAL = 0x810001;
    private static final int INITIALS_SPECIAL = 8454146;
    private static final int GENERATION_SPECIAL = 8454147;

    public PersonalName(byte[] nameBER, int offset, int special) throws NameException {
        this.special = special;
        if (nameBER == null) {
            throw new NameException("Encoding is null.");
        }
        try {
            SetContainer setContainer = new SetContainer(special);
            PrintStringContainer surnameContainer = new PrintStringContainer(0x800000, 1, 40);
            PrintStringContainer givenContainer = new PrintStringContainer(0x810001, 1, 16);
            PrintStringContainer initContainer = new PrintStringContainer(8454146, 1, 5);
            PrintStringContainer generationContainer = new PrintStringContainer(8454147, 1, 3);
            EndContainer end = new EndContainer();
            ASN1Container[] asn1Def = new ASN1Container[]{setContainer, surnameContainer, givenContainer, initContainer, generationContainer, end};
            ASN1.berDecode((byte[])nameBER, (int)offset, (ASN1Container[])asn1Def);
            if (!surnameContainer.dataPresent) {
                throw new NameException("Surname is missing.");
            }
            this.surname = surnameContainer.getValueAsString();
            if (givenContainer.dataPresent) {
                this.givenName = givenContainer.getValueAsString();
            }
            if (initContainer.dataPresent) {
                this.initials = initContainer.getValueAsString();
            }
            if (generationContainer.dataPresent) {
                this.generation = generationContainer.getValueAsString();
            }
        }
        catch (ASN_Exception asnException) {
            throw new NameException("Cannot decode the BER of the Personal name.");
        }
    }

    public PersonalName() {
    }

    public void setSurname(String name) {
        if (name != null) {
            this.surname = name;
        }
    }

    public void setGivenName(String name) {
        if (name != null) {
            this.givenName = name;
        }
    }

    public void setInitials(String name) {
        if (name != null) {
            this.initials = name;
        }
    }

    public void setGenerationQualifier(String name) {
        if (name != null) {
            this.generation = name;
        }
    }

    public String getSurname() {
        return this.surname;
    }

    public String getGivenName() {
        return this.givenName;
    }

    public String getInitials() {
        return this.initials;
    }

    public String getGenerationQualifier() {
        return this.generation;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        if (this.surname != null) {
            buffer.append(this.surname);
        }
        if (this.givenName != null) {
            if (buffer.length() != 0) {
                buffer.append(",");
            }
            buffer.append(this.givenName);
        }
        if (this.initials != null) {
            if (buffer.length() != 0) {
                buffer.append(",");
            }
            buffer.append(this.initials);
        }
        if (this.generation != null) {
            if (buffer.length() != 0) {
                buffer.append(",");
            }
            buffer.append(this.generation);
        }
        return buffer.toString();
    }

    public static int getNextBEROffset(byte[] nameBER, int offset) throws NameException {
        if (nameBER == null) {
            throw new NameException("Encoding is null.");
        }
        if (nameBER[offset] == 0 && nameBER[offset + 1] == 0) {
            return offset + 2;
        }
        try {
            return offset + 1 + ASN1Lengths.determineLengthLen((byte[])nameBER, (int)(offset + 1)) + ASN1Lengths.determineLength((byte[])nameBER, (int)(offset + 1));
        }
        catch (ASN_Exception asnException) {
            throw new NameException("Unable to determine length of the BER");
        }
    }

    public int getDERLen(int special) {
        this.special = special;
        return this.derEncodeInit();
    }

    public int getDEREncoding(byte[] encoding, int offset, int special) throws NameException {
        if (encoding == null) {
            throw new NameException("Specified array is null.");
        }
        try {
            int len;
            if ((this.asn1Template == null || special != this.special) && (len = this.getDERLen(special)) == 0) {
                throw new NameException("Unable to encode PersonalName.");
            }
            int returnValue = this.asn1Template.derEncode(encoding, offset);
            this.asn1Template = null;
            return returnValue;
        }
        catch (ASN_Exception asnException) {
            this.asn1Template = null;
            throw new NameException("Unable to encode PersonalName.");
        }
    }

    private int derEncodeInit() {
        try {
            int flag = 0;
            SetContainer setContainer = new SetContainer(this.special, true, 0);
            EndContainer end = new EndContainer();
            if (this.surname == null) {
                return 0;
            }
            PrintStringContainer surnameContainer = new PrintStringContainer(0x800000, true, 0, this.surname, 1, 40);
            PrintStringContainer generationContainer = null;
            PrintStringContainer initContainer = null;
            PrintStringContainer givenContainer = null;
            if (this.givenName != null) {
                givenContainer = new PrintStringContainer(0x810001, true, 0, this.givenName, 1, 16);
                flag = 1;
            }
            if (this.initials != null) {
                initContainer = new PrintStringContainer(8454146, true, 0, this.initials, 1, 5);
                flag = flag == 0 ? 2 : 3;
            }
            if (this.generation != null) {
                generationContainer = new PrintStringContainer(8454147, true, 0, this.generation, 1, 3);
                flag = flag == 0 ? 4 : (flag == 1 ? 5 : (flag == 2 ? 6 : 7));
            }
            switch (flag) {
                case 0: {
                    ASN1Container[] asn1Def0 = new ASN1Container[]{setContainer, surnameContainer, end};
                    this.asn1Template = new ASN1Template(asn1Def0);
                    break;
                }
                case 1: {
                    ASN1Container[] asn1Def1 = new ASN1Container[]{setContainer, surnameContainer, givenContainer, end};
                    this.asn1Template = new ASN1Template(asn1Def1);
                    break;
                }
                case 2: {
                    ASN1Container[] asn1Def2 = new ASN1Container[]{setContainer, surnameContainer, initContainer, end};
                    this.asn1Template = new ASN1Template(asn1Def2);
                    break;
                }
                case 3: {
                    ASN1Container[] asn1Def3 = new ASN1Container[]{setContainer, surnameContainer, givenContainer, initContainer, end};
                    this.asn1Template = new ASN1Template(asn1Def3);
                    break;
                }
                case 4: {
                    ASN1Container[] asn1Def4 = new ASN1Container[]{setContainer, surnameContainer, generationContainer, end};
                    this.asn1Template = new ASN1Template(asn1Def4);
                    break;
                }
                case 5: {
                    ASN1Container[] asn1Def5 = new ASN1Container[]{setContainer, surnameContainer, givenContainer, generationContainer, end};
                    this.asn1Template = new ASN1Template(asn1Def5);
                    break;
                }
                case 6: {
                    ASN1Container[] asn1Def6 = new ASN1Container[]{setContainer, surnameContainer, initContainer, generationContainer, end};
                    this.asn1Template = new ASN1Template(asn1Def6);
                    break;
                }
                case 7: {
                    ASN1Container[] asn1Def7 = new ASN1Container[]{setContainer, surnameContainer, givenContainer, initContainer, generationContainer, end};
                    this.asn1Template = new ASN1Template(asn1Def7);
                    break;
                }
                default: {
                    return 0;
                }
            }
            return this.asn1Template.derEncodeInit();
        }
        catch (ASN_Exception asnException) {
            return 0;
        }
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof PersonalName)) {
            return false;
        }
        PersonalName other = (PersonalName)obj;
        if (this.surname != null ? !this.surname.equals(other.surname) : other.surname != null) {
            return false;
        }
        if (this.givenName != null ? !this.givenName.equals(other.givenName) : other.givenName != null) {
            return false;
        }
        if (this.initials != null ? !this.initials.equals(other.initials) : other.initials != null) {
            return false;
        }
        return !(this.generation != null ? !this.generation.equals(other.generation) : other.generation != null);
    }

    public int hashCode() {
        int len = this.getDERLen(0);
        if (len == 0) {
            return 0;
        }
        byte[] enc = new byte[len];
        try {
            this.getDEREncoding(enc, 0, 0);
        }
        catch (NameException e) {
            return 0;
        }
        return Arrays.hashCode(enc);
    }

    public Object clone() throws CloneNotSupportedException {
        PersonalName otherSelf = new PersonalName();
        if (this.surname != null) {
            otherSelf.surname = this.surname;
        }
        if (this.givenName != null) {
            otherSelf.givenName = this.givenName;
        }
        if (this.initials != null) {
            otherSelf.initials = this.initials;
        }
        if (this.generation != null) {
            otherSelf.generation = this.generation;
        }
        otherSelf.special = this.special;
        if (this.asn1Template != null) {
            otherSelf.derEncodeInit();
        }
        return otherSelf;
    }
}

