/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.cert.extensions;

import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN1Template;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.EndContainer;
import com.rsa.asn1.IntegerContainer;
import com.rsa.asn1.SequenceContainer;
import com.rsa.certj.cert.CertExtension;
import com.rsa.certj.cert.CertificateException;
import com.rsa.certj.cert.extensions.X509V3Extension;

public class PolicyConstraints
extends X509V3Extension
implements CertExtension {
    private int requireExplicitPolicy = -1;
    private int inhibitPolicyMapping = -1;
    ASN1Template asn1TemplateValue;
    private static final int POLICY_SPECIAL = 0x810000;
    private static final int MAPPING_SPECIAL = 0x810001;

    public PolicyConstraints() {
        this.extensionTypeFlag = 36;
        this.criticality = false;
        this.setStandardOID(36);
        this.extensionTypeString = "PolicyConstraints";
    }

    public PolicyConstraints(int requireExplicitPolicy, int inhibitPolicyMapping, boolean criticality) {
        this.extensionTypeFlag = 36;
        this.criticality = criticality;
        this.setStandardOID(36);
        this.requireExplicitPolicy = requireExplicitPolicy;
        this.inhibitPolicyMapping = inhibitPolicyMapping;
        this.extensionTypeString = "PolicyConstraints";
    }

    public void decodeValue(byte[] valueBER, int offset) throws CertificateException {
        if (valueBER == null) {
            throw new CertificateException("Encoding is null.");
        }
        SequenceContainer seq = new SequenceContainer(0);
        EndContainer anEnd = new EndContainer();
        IntegerContainer int1 = new IntegerContainer(0x810000);
        IntegerContainer int2 = new IntegerContainer(0x810001);
        ASN1Container[] asn1Def = new ASN1Container[]{seq, int1, int2, anEnd};
        try {
            ASN1.berDecode((byte[])valueBER, (int)offset, (ASN1Container[])asn1Def);
        }
        catch (ASN_Exception asnException) {
            throw new CertificateException("Could not decode Policy Constraints extension.");
        }
        if (int1.dataPresent) {
            this.requireExplicitPolicy = this.bytesToInt(int1.data, int1.dataOffset, int1.dataLen);
        }
        if (int2.dataPresent) {
            this.inhibitPolicyMapping = this.bytesToInt(int2.data, int2.dataOffset, int2.dataLen);
        }
    }

    private int bytesToInt(byte[] data, int offset, int len) throws CertificateException {
        if (data == null || len == 0) {
            return 0;
        }
        if (len > 4) {
            throw new CertificateException("Could not decode AuthorityKeyID extension.");
        }
        int returnValue = 0;
        for (int index = offset; index < len + offset; ++index) {
            returnValue <<= 8;
            returnValue |= data[index] & 0xFF;
        }
        return returnValue;
    }

    public void setExplicitPolicy(int value) {
        this.requireExplicitPolicy = value;
    }

    public void setPolicyMapping(int value) {
        this.inhibitPolicyMapping = value;
    }

    public int getExplicitPolicy() {
        return this.requireExplicitPolicy;
    }

    public int getPolicyMapping() {
        return this.inhibitPolicyMapping;
    }

    public int derEncodeValueInit() {
        SequenceContainer seq = new SequenceContainer(0, true, 0);
        EndContainer anEnd = new EndContainer();
        IntegerContainer int1 = null;
        if (this.requireExplicitPolicy != -1) {
            int1 = new IntegerContainer(0x810000, true, 0, this.requireExplicitPolicy);
        }
        IntegerContainer int2 = null;
        if (this.inhibitPolicyMapping != -1) {
            int2 = new IntegerContainer(0x810001, true, 0, this.inhibitPolicyMapping);
        }
        if (int1 != null) {
            if (int2 != null) {
                ASN1Container[] asn1Def = new ASN1Container[]{seq, int1, int2, anEnd};
                this.asn1TemplateValue = new ASN1Template(asn1Def);
            } else {
                ASN1Container[] asn1Def = new ASN1Container[]{seq, int1, anEnd};
                this.asn1TemplateValue = new ASN1Template(asn1Def);
            }
        } else if (int2 != null) {
            ASN1Container[] asn1Def = new ASN1Container[]{seq, int2, anEnd};
            this.asn1TemplateValue = new ASN1Template(asn1Def);
        } else {
            ASN1Container[] asn1Def = new ASN1Container[]{seq, anEnd};
            this.asn1TemplateValue = new ASN1Template(asn1Def);
        }
        try {
            return this.asn1TemplateValue.derEncodeInit();
        }
        catch (ASN_Exception asnException) {
            return 0;
        }
    }

    public int derEncodeValue(byte[] encoding, int offset) {
        if (encoding == null) {
            return 0;
        }
        if (this.asn1TemplateValue == null && this.derEncodeValueInit() == 0) {
            return 0;
        }
        try {
            int totalLen = this.asn1TemplateValue.derEncode(encoding, offset);
            this.asn1Template = null;
            return totalLen;
        }
        catch (ASN_Exception asnException) {
            this.asn1Template = null;
            return 0;
        }
    }

    public Object clone() throws CloneNotSupportedException {
        PolicyConstraints otherSelf = new PolicyConstraints();
        otherSelf.requireExplicitPolicy = this.requireExplicitPolicy;
        otherSelf.inhibitPolicyMapping = this.inhibitPolicyMapping;
        if (this.asn1TemplateValue != null) {
            otherSelf.derEncodeValueInit();
        }
        super.copyValues(otherSelf);
        return otherSelf;
    }

    protected void reset() {
        super.reset();
        this.requireExplicitPolicy = 0;
        this.inhibitPolicyMapping = 0;
        this.asn1TemplateValue = null;
    }
}

