/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.cert.extensions;

import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN1Lengths;
import com.rsa.asn1.ASN1Template;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.EncodedContainer;
import com.rsa.asn1.EndContainer;
import com.rsa.asn1.OIDContainer;
import com.rsa.asn1.OfContainer;
import com.rsa.asn1.SequenceContainer;
import com.rsa.certj.CertJUtils;
import com.rsa.certj.cert.CertificateException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PolicyQualifiers
implements Cloneable,
Serializable {
    private Vector<byte[]>[] policy = this.createVectorArray(2);
    protected int special;
    private ASN1Template asn1Template;

    public PolicyQualifiers() {
    }

    public PolicyQualifiers(byte[] valueBER, int offset, int special) throws CertificateException {
        this.special = special;
        if (valueBER == null) {
            throw new CertificateException("Data is missing.");
        }
        try {
            OfContainer seqOf = new OfContainer(special, 12288, (ASN1Container)new EncodedContainer(12288));
            ASN1Container[] nameDef = new ASN1Container[]{seqOf};
            ASN1.berDecode((byte[])valueBER, (int)offset, (ASN1Container[])nameDef);
            int nameCount = seqOf.getContainerCount();
            for (int nameIndex = 0; nameIndex < nameCount; ++nameIndex) {
                ASN1Container encodedNameContainer = seqOf.containerAt(nameIndex);
                SequenceContainer seq = new SequenceContainer(0);
                EndContainer anEnd = new EndContainer();
                EncodedContainer qualifier = new EncodedContainer(65280);
                OIDContainer oid = new OIDContainer(0);
                ASN1Container[] asn1Def = new ASN1Container[]{seq, oid, qualifier, anEnd};
                ASN1.berDecode((byte[])encodedNameContainer.data, (int)encodedNameContainer.dataOffset, (ASN1Container[])asn1Def);
                byte[] id = new byte[oid.dataLen];
                System.arraycopy(oid.data, oid.dataOffset, id, 0, oid.dataLen);
                this.policy[0].addElement(id);
                byte[] qualif = new byte[qualifier.dataLen];
                System.arraycopy(qualifier.data, qualifier.dataOffset, qualif, 0, qualifier.dataLen);
                this.policy[1].addElement(qualif);
            }
        }
        catch (Exception certException) {
            throw new CertificateException("Cannot decode the BER of PolicyQualifiers.");
        }
    }

    public void addPolicyQualifier(byte[] id, int idOffset, int idLen, byte[] data, int dataOffset, int dataLen) throws CertificateException {
        if (id == null || data == null) {
            throw new CertificateException(" Null data in setPolicyQualifierInfo");
        }
        byte[] oid = new byte[idLen];
        System.arraycopy(id, idOffset, oid, 0, idLen);
        this.policy[0].addElement(oid);
        byte[] qualifier = new byte[dataLen];
        System.arraycopy(data, dataOffset, qualifier, 0, dataLen);
        this.policy[1].addElement(qualifier);
    }

    public byte[] getPolicyQualifierId(int index) throws CertificateException {
        if (this.policy[0].size() <= index) {
            throw new CertificateException("Specified index is invalid.");
        }
        return this.policy[0].elementAt(index);
    }

    public byte[] getQualifier(int index) throws CertificateException {
        if (this.policy[1].size() <= index) {
            throw new CertificateException("Specified index is invalid.");
        }
        return this.policy[1].elementAt(index);
    }

    private Vector<byte[]>[] createVectorArray(int size) {
        Vector[] vectorArray = new Vector[size];
        for (int index = 0; index < size; ++index) {
            vectorArray[index] = new Vector();
        }
        return vectorArray;
    }

    public int getQualifiersCount() {
        return this.policy[0].size();
    }

    public static int getNextBEROffset(byte[] valueBER, int offset) throws CertificateException {
        if (valueBER == null) {
            throw new CertificateException("Encoding is null.");
        }
        if (valueBER[offset] == 0 && valueBER[offset + 1] == 0) {
            return offset + 2;
        }
        try {
            return offset + 1 + ASN1Lengths.determineLengthLen((byte[])valueBER, (int)(offset + 1)) + ASN1Lengths.determineLength((byte[])valueBER, (int)(offset + 1));
        }
        catch (ASN_Exception asnException) {
            throw new CertificateException("Unable to determine length of the BER");
        }
    }

    public int getDERLen(int special) throws CertificateException {
        this.special = special;
        return this.derEncodeInit();
    }

    public int getDEREncoding(byte[] encoding, int offset, int special) throws CertificateException {
        if (encoding == null) {
            throw new CertificateException("Specified array is null.");
        }
        try {
            if (this.asn1Template == null || special != this.special) {
                this.getDERLen(special);
            }
            int returnValue = this.asn1Template.derEncode(encoding, offset);
            this.asn1Template = null;
            return returnValue;
        }
        catch (ASN_Exception asnException) {
            this.asn1Template = null;
            throw new CertificateException("Unable to encode PolicyQualifiers");
        }
    }

    private int derEncodeInit() {
        if (this.asn1Template != null) {
            return 0;
        }
        try {
            Vector<OfContainer> asn1Def = new Vector<OfContainer>();
            OfContainer sequenceOfContainer = new OfContainer(this.special, true, 0, 12288, (ASN1Container)new EncodedContainer(12288));
            asn1Def.addElement(sequenceOfContainer);
            for (int index = 0; index < this.policy[0].size(); ++index) {
                EncodedContainer qContainer = this.encodeQualifier(index);
                sequenceOfContainer.addContainer((ASN1Container)qContainer);
            }
            Object[] asn1DefArray = new ASN1Container[asn1Def.size()];
            asn1Def.copyInto(asn1DefArray);
            this.asn1Template = new ASN1Template((ASN1Container[])asn1DefArray);
            return this.asn1Template.derEncodeInit();
        }
        catch (ASN_Exception asnException) {
            return 0;
        }
        catch (CertificateException certException) {
            return 0;
        }
    }

    private EncodedContainer encodeQualifier(int index) throws CertificateException {
        EncodedContainer next;
        SequenceContainer seq = new SequenceContainer(0, true, 0);
        EndContainer end = new EndContainer();
        byte[] oid = this.policy[0].elementAt(index);
        byte[] data = this.policy[1].elementAt(index);
        try {
            EncodedContainer qualifier = new EncodedContainer(65280, true, 0, data, 0, data.length);
            OIDContainer id = new OIDContainer(0x1000000, true, 0, oid, 0, oid.length);
            ASN1Container[] asn1Def = new ASN1Container[]{seq, id, qualifier, end};
            ASN1Template templ = new ASN1Template(asn1Def);
            int encodingLen = templ.derEncodeInit();
            byte[] encoding = new byte[encodingLen];
            encodingLen = templ.derEncode(encoding, 0);
            next = new EncodedContainer(12288, true, 0, encoding, 0, encodingLen);
        }
        catch (ASN_Exception asnException) {
            throw new CertificateException(" Can't encode PolicyQualifier");
        }
        return next;
    }

    public boolean equals(Object obj) {
        int vectorIndex;
        if (obj == null || !(obj instanceof PolicyQualifiers)) {
            return false;
        }
        PolicyQualifiers other = (PolicyQualifiers)obj;
        int thisVectorSize = this.policy[0].size();
        if (thisVectorSize != other.policy[0].size()) {
            return false;
        }
        for (vectorIndex = 0; vectorIndex < thisVectorSize; ++vectorIndex) {
            byte[] otherOid;
            byte[] thisOid = this.policy[0].elementAt(vectorIndex);
            if (CertJUtils.byteArraysEqual(thisOid, otherOid = other.policy[0].elementAt(vectorIndex))) continue;
            return false;
        }
        thisVectorSize = this.policy[1].size();
        if (thisVectorSize != other.policy[1].size()) {
            return false;
        }
        for (vectorIndex = 0; vectorIndex < thisVectorSize; ++vectorIndex) {
            byte[] otherData;
            byte[] thisData = this.policy[1].elementAt(vectorIndex);
            if (CertJUtils.byteArraysEqual(thisData, otherData = other.policy[1].elementAt(vectorIndex))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int vectorIndex;
        int hashcode = 0;
        int thisVectorSize = this.policy[0].size();
        for (vectorIndex = 0; vectorIndex < thisVectorSize; ++vectorIndex) {
            byte[] oid = this.policy[0].elementAt(vectorIndex);
            hashcode ^= Arrays.hashCode(oid);
        }
        hashcode *= 17;
        thisVectorSize = this.policy[1].size();
        for (vectorIndex = 0; vectorIndex < thisVectorSize; ++vectorIndex) {
            byte[] data = this.policy[1].elementAt(vectorIndex);
            hashcode ^= Arrays.hashCode(data);
        }
        return hashcode;
    }

    public Object clone() throws CloneNotSupportedException {
        PolicyQualifiers otherSelf = new PolicyQualifiers();
        for (int index = 0; index < this.policy.length; ++index) {
            for (int vectorIndex = 0; vectorIndex < this.policy[index].size(); ++vectorIndex) {
                otherSelf.policy[index].addElement(this.policy[index].elementAt(vectorIndex));
            }
        }
        otherSelf.special = this.special;
        if (this.asn1Template != null) {
            otherSelf.derEncodeInit();
        }
        return otherSelf;
    }
}

