/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.cert.extensions;

import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN1Template;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.EncodedContainer;
import com.rsa.asn1.EndContainer;
import com.rsa.asn1.OIDContainer;
import com.rsa.asn1.OfContainer;
import com.rsa.asn1.SequenceContainer;
import com.rsa.certj.cert.CertExtension;
import com.rsa.certj.cert.CertificateException;
import com.rsa.certj.cert.extensions.X509V3Extension;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QCStatements
extends X509V3Extension
implements CertExtension {
    private Vector<byte[]>[] qcStatements = this.createVectorArray();
    ASN1Template asn1TemplateValue;

    public QCStatements() {
        this.extensionTypeFlag = 123;
        this.criticality = false;
        this.setSpecialOID(QC_STATEMENTS_OID);
        this.extensionTypeString = "QC_Statements";
    }

    public QCStatements(byte[] statementID, int idOffset, int idLen, byte[] statementInfo, int infoOffset, int infoLen, boolean criticality) throws CertificateException {
        this.addQCStatement(statementID, idOffset, idLen, statementInfo, infoOffset, infoLen);
        this.extensionTypeFlag = 123;
        this.criticality = criticality;
        this.setSpecialOID(QC_STATEMENTS_OID);
        this.extensionTypeString = "QC_Statements";
    }

    private Vector<byte[]>[] createVectorArray() {
        Vector[] vectorArray = new Vector[3];
        for (int index = 0; index < 3; ++index) {
            vectorArray[index] = new Vector();
        }
        return vectorArray;
    }

    @Override
    public void decodeValue(byte[] valueBER, int offset) throws CertificateException {
        if (valueBER == null || offset < 0) {
            throw new CertificateException("Encoding is null.");
        }
        try {
            OfContainer seqOf = new OfContainer(0, 12288, (ASN1Container)new EncodedContainer(12288));
            ASN1Container[] qcDef = new ASN1Container[]{seqOf};
            ASN1.berDecode((byte[])valueBER, (int)offset, (ASN1Container[])qcDef);
            int qcCount = seqOf.getContainerCount();
            for (int qcIndex = 0; qcIndex < qcCount; ++qcIndex) {
                ASN1Container encodedNameContainer = seqOf.containerAt(qcIndex);
                SequenceContainer seq = new SequenceContainer(0);
                EndContainer anEnd = new EndContainer();
                OIDContainer oidContainer = new OIDContainer(0x1000000);
                EncodedContainer infoContainer = new EncodedContainer(130816);
                ASN1Container[] asnDef = new ASN1Container[]{seq, oidContainer, infoContainer, anEnd};
                ASN1.berDecode((byte[])encodedNameContainer.data, (int)encodedNameContainer.dataOffset, (ASN1Container[])asnDef);
                if (infoContainer.dataPresent) {
                    this.addQCStatement(oidContainer.data, oidContainer.dataOffset, oidContainer.dataLen, infoContainer.data, infoContainer.dataOffset, infoContainer.dataLen);
                    continue;
                }
                this.addQCStatement(oidContainer.data, oidContainer.dataOffset, oidContainer.dataLen, null, 0, 0);
            }
        }
        catch (ASN_Exception asnException) {
            throw new CertificateException("Could not decode QCStatements extension. ", (Exception)((Object)asnException));
        }
    }

    public void addQCStatement(byte[] statementID, int idOffset, int idLen, byte[] statementInfo, int infoOffset, int infoLen) throws CertificateException {
        if (statementID != null && idLen > 0 && idOffset >= 0 && statementID.length >= idLen + idOffset) {
            byte[] id = new byte[idLen];
            System.arraycopy(statementID, idOffset, id, 0, idLen);
            this.qcStatements[0].addElement(id);
            if (statementInfo != null && infoLen > 0 && infoOffset >= 0 && statementInfo.length >= infoLen + infoOffset) {
                byte[] info = new byte[infoLen];
                System.arraycopy(statementInfo, infoOffset, info, 0, infoLen);
                this.qcStatements[1].addElement(info);
            } else {
                this.qcStatements[1].addElement(null);
            }
        } else {
            if (statementID == null) {
                throw new CertificateException("Statement ID cannot be null.");
            }
            throw new CertificateException("Invalid parameter");
        }
    }

    public byte[] getQCStatementID(int index) throws CertificateException {
        if (this.qcStatements[0].size() <= index) {
            throw new CertificateException("Specified index is invalid.");
        }
        return this.qcStatements[0].elementAt(index);
    }

    public byte[] getQCStatementInfo(int index) throws CertificateException {
        if (this.qcStatements[1].size() <= index) {
            throw new CertificateException("Specified index is invalid.");
        }
        return this.qcStatements[1].elementAt(index);
    }

    public int getQCStatementCount() {
        return this.qcStatements[0].size();
    }

    @Override
    public int derEncodeValueInit() {
        Vector<OfContainer> asn1Def = new Vector<OfContainer>();
        try {
            OfContainer seqOf = new OfContainer(0, true, 0, 12288, (ASN1Container)new EncodedContainer(12288));
            asn1Def.addElement(seqOf);
            for (int index = 0; index < this.qcStatements[0].size(); ++index) {
                byte[] id = this.qcStatements[0].elementAt(index);
                byte[] info = index < this.qcStatements[1].size() ? this.qcStatements[1].elementAt(index) : null;
                try {
                    SequenceContainer seq = new SequenceContainer(0);
                    EndContainer anEnd = new EndContainer();
                    OIDContainer oidContainer = new OIDContainer(0x1000000, true, 0, id, 0, id.length);
                    EncodedContainer infoContainer = info != null ? new EncodedContainer(130816, true, 0, info, 0, info.length) : new EncodedContainer(130816, false, 0, null, 0, 0);
                    ASN1Container[] asnDef = new ASN1Container[]{seq, oidContainer, infoContainer, anEnd};
                    this.asn1Template = new ASN1Template(asnDef);
                    int encodingLen = this.asn1Template.derEncodeInit();
                    byte[] encoding = new byte[encodingLen];
                    encodingLen = this.asn1Template.derEncode(encoding, 0);
                    EncodedContainer next = new EncodedContainer(12288, true, 0, encoding, 0, encodingLen);
                    seqOf.addContainer((ASN1Container)next);
                    continue;
                }
                catch (ASN_Exception asnException) {
                    return 0;
                }
            }
            Object[] asn1DefArray = new ASN1Container[asn1Def.size()];
            asn1Def.copyInto(asn1DefArray);
            this.asn1TemplateValue = new ASN1Template((ASN1Container[])asn1DefArray);
            return this.asn1TemplateValue.derEncodeInit();
        }
        catch (ASN_Exception asnException) {
            return 0;
        }
    }

    @Override
    public int derEncodeValue(byte[] encoding, int offset) {
        if (encoding == null) {
            return 0;
        }
        if (this.asn1TemplateValue == null && this.derEncodeValueInit() == 0) {
            return 0;
        }
        try {
            int totalLen = this.asn1TemplateValue.derEncode(encoding, offset);
            this.asn1Template = null;
            return totalLen;
        }
        catch (ASN_Exception asnException) {
            this.asn1Template = null;
            return 0;
        }
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        int index;
        QCStatements otherSelf = new QCStatements();
        for (index = 0; index < this.qcStatements[0].size(); ++index) {
            otherSelf.qcStatements[0].addElement((byte[])this.qcStatements[0].elementAt(index).clone());
        }
        for (index = 0; index < this.qcStatements[1].size(); ++index) {
            if (this.qcStatements[1].elementAt(index) == null) {
                otherSelf.qcStatements[1].addElement(null);
                continue;
            }
            otherSelf.qcStatements[1].addElement((byte[])this.qcStatements[1].elementAt(index).clone());
        }
        if (this.asn1TemplateValue != null) {
            otherSelf.derEncodeValueInit();
        }
        super.copyValues(otherSelf);
        return otherSelf;
    }

    @Override
    protected void reset() {
        super.reset();
        this.qcStatements = this.createVectorArray();
        this.asn1TemplateValue = null;
    }
}

