/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.cert.extensions;

import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN1Template;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.IA5StringContainer;
import com.rsa.certj.cert.CertExtension;
import com.rsa.certj.cert.CertificateException;
import com.rsa.certj.cert.extensions.X509V3Extension;

public class VeriSignJurisdictionHash
extends X509V3Extension
implements CertExtension {
    private String value;
    ASN1Template asn1TemplateValue;

    public VeriSignJurisdictionHash() {
        this.extensionTypeFlag = 113;
        this.criticality = false;
        this.setSpecialOID(VERISIGN_JURISDICTION_HASH_OID);
        this.extensionTypeString = "VeriSignJurisdictionHash";
    }

    public VeriSignJurisdictionHash(String value, boolean criticality) {
        this.extensionTypeFlag = 113;
        criticality = false;
        this.setSpecialOID(VERISIGN_JURISDICTION_HASH_OID);
        this.criticality = criticality;
        if (value != null) {
            this.value = value;
        }
        this.extensionTypeString = "VeriSignJurisdictionHash";
    }

    public void setJurisdictionHash(String value) {
        if (value != null) {
            this.value = value;
        }
    }

    public String getJurisdictionHash() {
        return this.value;
    }

    public void decodeValue(byte[] valueBER, int offset) throws CertificateException {
        if (valueBER == null) {
            throw new CertificateException("Encoding is null.");
        }
        try {
            IA5StringContainer hash = new IA5StringContainer(0);
            ASN1Container[] asn1Def = new ASN1Container[]{hash};
            ASN1.berDecode((byte[])valueBER, (int)offset, (ASN1Container[])asn1Def);
            this.value = hash.getValueAsString();
        }
        catch (ASN_Exception asnException) {
            throw new CertificateException("Could not decode VeriSignJurisdictionHash extension.");
        }
    }

    public int derEncodeValueInit() {
        try {
            IA5StringContainer hash = new IA5StringContainer(0, true, 0, this.value);
            ASN1Container[] asn1Def = new ASN1Container[]{hash};
            this.asn1TemplateValue = new ASN1Template(asn1Def);
            return this.asn1TemplateValue.derEncodeInit();
        }
        catch (ASN_Exception asnException) {
            return 0;
        }
    }

    public int derEncodeValue(byte[] encoding, int offset) {
        if (encoding == null) {
            return 0;
        }
        if (this.asn1TemplateValue == null && this.derEncodeValueInit() == 0) {
            return 0;
        }
        try {
            int totalLen = this.asn1TemplateValue.derEncode(encoding, offset);
            this.asn1Template = null;
            return totalLen;
        }
        catch (ASN_Exception asnException) {
            this.asn1Template = null;
            return 0;
        }
    }

    public Object clone() throws CloneNotSupportedException {
        VeriSignJurisdictionHash otherSelf = new VeriSignJurisdictionHash();
        otherSelf.value = this.value;
        if (this.asn1TemplateValue != null) {
            otherSelf.derEncodeValueInit();
        }
        super.copyValues(otherSelf);
        return otherSelf;
    }

    protected void reset() {
        super.reset();
        this.value = null;
        this.asn1TemplateValue = null;
    }
}

