/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.cms;

import com.rsa.certj.DatabaseService;
import com.rsa.certj.cert.X501Attributes;
import com.rsa.certj.cert.X509V3Extensions;
import com.rsa.certj.cert.extensions.GeneralName;
import com.rsa.certj.cms.Accuracy;
import com.rsa.certj.cms.CMSException;
import com.rsa.certj.cms.CMSUtils;
import com.rsa.certj.cms.RecipientInfo;
import com.rsa.certj.cms.SignerInfo;
import com.rsa.jsafe.JSAFE_SecretKey;
import com.rsa.jsafe.JSAFE_SecureRandom;
import com.rsa.jsafe.cert.Attribute;
import com.rsa.jsafe.cert.X509ExtensionSpec;
import com.rsa.jsafe.cms.ParameterFactory;
import com.rsa.jsafe.crypto.FIPS140Context;
import com.rsa.jsafe.provider.JsafeJCE;
import java.math.BigInteger;
import java.security.SecureRandom;
import java.security.cert.CertStore;
import java.util.Date;
import javax.crypto.SecretKey;

public abstract class CMSParameters {
    com.rsa.jsafe.cms.CMSParameters jceParams;

    abstract com.rsa.jsafe.cms.CMSParameters getJceParameters(FIPS140Context var1) throws CMSException;

    static final class TimeStampTokenParameters
    extends CMSParameters {
        private String policyId;
        private String digestAlgorithm;
        private byte[] digest;
        private BigInteger serialNumber;
        private Date generationTime;
        private Accuracy accuracy;
        private boolean ordering;
        private BigInteger nonce;
        private GeneralName authorityName;
        private X509V3Extensions extensions;

        public TimeStampTokenParameters(String policyId, String digestAlgorithm, byte[] digest, byte[] serialNumber, Date generationTime, Accuracy accuracy, boolean ordering, byte[] nonce, GeneralName authorityName, X509V3Extensions extensions) {
            this.policyId = policyId;
            this.digestAlgorithm = digestAlgorithm;
            this.digest = digest == null ? null : (byte[])digest.clone();
            this.serialNumber = serialNumber == null ? null : new BigInteger(serialNumber);
            this.generationTime = generationTime == null ? null : new Date(generationTime.getTime());
            this.accuracy = accuracy;
            this.ordering = ordering;
            this.nonce = nonce == null ? null : new BigInteger(nonce);
            try {
                this.authorityName = authorityName == null ? null : (GeneralName)authorityName.clone();
                this.extensions = extensions == null ? null : (X509V3Extensions)extensions.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new IllegalArgumentException(e);
            }
        }

        com.rsa.jsafe.cms.CMSParameters getJceParameters(FIPS140Context jceCtx) throws CMSException {
            if (this.jceParams == null) {
                com.rsa.jsafe.cms.Accuracy jceAccuracy = CMSUtils.convertToJceAccuracy(this.accuracy);
                com.rsa.jsafe.cert.GeneralName jceAuthName = CMSUtils.convertToJceGeneralName(this.authorityName);
                X509ExtensionSpec extensionSpecs = CMSUtils.convertToJceExtensionSpecs(this.extensions);
                this.jceParams = ParameterFactory.newTimeStampTokenParameters((String)this.policyId, (String)this.digestAlgorithm, (byte[])this.digest, (BigInteger)this.serialNumber, (Date)this.generationTime, (com.rsa.jsafe.cms.Accuracy)jceAccuracy, (boolean)this.ordering, (BigInteger)this.nonce, (com.rsa.jsafe.cert.GeneralName)jceAuthName, (X509ExtensionSpec)extensionSpecs);
            }
            return this.jceParams;
        }
    }

    static final class SignedDataParameters
    extends CMSParameters {
        private SignerInfo[] signerInfos;
        private DatabaseService database;
        private JSAFE_SecureRandom random;

        public SignedDataParameters(SignerInfo[] signerInfos, DatabaseService database, JSAFE_SecureRandom random) {
            this.signerInfos = signerInfos;
            this.database = database;
            this.random = random;
        }

        com.rsa.jsafe.cms.CMSParameters getJceParameters(FIPS140Context jceCtx) throws CMSException {
            if (this.jceParams == null) {
                JsafeJCE jceProv = CMSUtils.createJceProvider(jceCtx);
                com.rsa.jsafe.cms.SignerInfo[] jceSignerInfos = CMSUtils.convertToJceSignerInfos(this.signerInfos, jceProv);
                CertStore certStore = CMSUtils.convertToJceCertStore(this.database, jceProv);
                this.jceParams = ParameterFactory.newSignedDataParameters((com.rsa.jsafe.cms.SignerInfo[])jceSignerInfos, (CertStore)certStore, (SecureRandom)this.random);
            }
            return this.jceParams;
        }
    }

    static final class EnvelopedDataParameters
    extends CMSParameters {
        private RecipientInfo[] recipientInfos;
        private String encryptAlgorithm;
        private int keyBitLength;
        private DatabaseService database;
        private X501Attributes unprotectedAttrs;
        private JSAFE_SecureRandom random;

        public EnvelopedDataParameters(RecipientInfo[] recipientInfos, String encryptAlgorithm, int keyBitLength, DatabaseService database, X501Attributes unprotectedAttrs, JSAFE_SecureRandom random) {
            this.recipientInfos = (RecipientInfo[])recipientInfos.clone();
            this.encryptAlgorithm = encryptAlgorithm;
            this.keyBitLength = keyBitLength;
            this.database = database;
            try {
                this.unprotectedAttrs = unprotectedAttrs == null ? null : (X501Attributes)unprotectedAttrs.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new IllegalArgumentException(e);
            }
            this.random = random;
        }

        com.rsa.jsafe.cms.CMSParameters getJceParameters(FIPS140Context jceCtx) throws CMSException {
            if (this.jceParams == null) {
                JsafeJCE jceProv = CMSUtils.createJceProvider(jceCtx);
                com.rsa.jsafe.cms.RecipientInfo[] jceRecipientInfos = CMSUtils.convertToJceRecipientInfos(this.recipientInfos, jceProv);
                CertStore certStore = CMSUtils.convertToJceCertStore(this.database, jceProv);
                Attribute[] jceUnprotectedAttrs = CMSUtils.convertToJceAttributes(this.unprotectedAttrs);
                String jceEncryptionAlg = CMSUtils.convertToJceEncryptionAlg(this.encryptAlgorithm);
                this.jceParams = ParameterFactory.newEnvelopedDataParameters((com.rsa.jsafe.cms.RecipientInfo[])jceRecipientInfos, (String)jceEncryptionAlg, (int)this.keyBitLength, (CertStore)certStore, (Attribute[])jceUnprotectedAttrs, (SecureRandom)this.random);
            }
            return this.jceParams;
        }
    }

    static final class EncryptedDataParameters
    extends CMSParameters {
        private String encryptAlgorithm;
        private JSAFE_SecretKey secretKey;
        private X501Attributes unprotectedAttrs;
        private JSAFE_SecureRandom random;

        EncryptedDataParameters(String encryptAlgorithm, JSAFE_SecretKey secretKey, X501Attributes unprotectedAttrs, JSAFE_SecureRandom random) {
            this.encryptAlgorithm = encryptAlgorithm;
            try {
                this.secretKey = secretKey == null ? null : (JSAFE_SecretKey)secretKey.clone();
                this.unprotectedAttrs = unprotectedAttrs == null ? null : (X501Attributes)unprotectedAttrs.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new IllegalArgumentException(e);
            }
            this.random = random;
        }

        com.rsa.jsafe.cms.CMSParameters getJceParameters(FIPS140Context jceCtx) throws CMSException {
            if (this.jceParams == null) {
                JsafeJCE jceProv = CMSUtils.createJceProvider(jceCtx);
                SecretKey jceSecretKey = CMSUtils.convertToJceSecretKey(this.secretKey, jceProv);
                Attribute[] jceUnprotectedAttrs = CMSUtils.convertToJceAttributes(this.unprotectedAttrs);
                String jceEncryptionAlg = CMSUtils.convertToJceEncryptionAlg(this.encryptAlgorithm);
                this.jceParams = ParameterFactory.newEncryptedDataParameters((String)jceEncryptionAlg, (SecretKey)jceSecretKey, (Attribute[])jceUnprotectedAttrs, (SecureRandom)this.random);
            }
            return this.jceParams;
        }
    }

    static final class DigestedDataParameters
    extends CMSParameters {
        private String digestAlgorithm;

        DigestedDataParameters(String digestAlgorithm) {
            this.digestAlgorithm = digestAlgorithm;
        }

        com.rsa.jsafe.cms.CMSParameters getJceParameters(FIPS140Context jceCtx) throws CMSException {
            if (this.jceParams == null) {
                this.jceParams = ParameterFactory.newDigestedDataParameters((String)this.digestAlgorithm);
            }
            return this.jceParams;
        }
    }

    static final class AuthenticatedDataParameters
    extends CMSParameters {
        private RecipientInfo[] recipientInfos;
        private String macAlgorithm;
        private int keyBitLength;
        private DatabaseService database;
        private X501Attributes authAttrs;
        private X501Attributes unAuthAttrs;
        private JSAFE_SecureRandom random;

        AuthenticatedDataParameters(RecipientInfo[] recipientInfos, String macAlgorithm, int keyBitLength, DatabaseService database, X501Attributes authAttrs, X501Attributes unAuthAttrs, JSAFE_SecureRandom random) {
            this.validate(recipientInfos, macAlgorithm);
            this.recipientInfos = (RecipientInfo[])recipientInfos.clone();
            this.macAlgorithm = macAlgorithm;
            this.keyBitLength = keyBitLength;
            this.database = database;
            try {
                this.authAttrs = authAttrs == null ? null : (X501Attributes)authAttrs.clone();
                this.unAuthAttrs = unAuthAttrs == null ? null : (X501Attributes)unAuthAttrs.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new IllegalArgumentException(e);
            }
            this.random = random;
        }

        private void validate(RecipientInfo[] recipientInfos, String macAlgorithm) {
            if (recipientInfos == null || recipientInfos.length < 1) {
                throw new IllegalArgumentException("At least one recipient info object expected.");
            }
            if (macAlgorithm == null) {
                throw new IllegalArgumentException("MAC algorithm cannot be null.");
            }
        }

        com.rsa.jsafe.cms.CMSParameters getJceParameters(FIPS140Context jceCtx) throws CMSException {
            if (this.jceParams == null) {
                JsafeJCE jceProv = CMSUtils.createJceProvider(jceCtx);
                com.rsa.jsafe.cms.RecipientInfo[] jceRecipientInfos = CMSUtils.convertToJceRecipientInfos(this.recipientInfos, jceProv);
                CertStore certStore = CMSUtils.convertToJceCertStore(this.database, jceProv);
                Attribute[] jceAuthAttrs = CMSUtils.convertToJceAttributes(this.authAttrs);
                Attribute[] jceUnauthAttrs = CMSUtils.convertToJceAttributes(this.unAuthAttrs);
                this.jceParams = ParameterFactory.newAuthenticatedDataParameters((com.rsa.jsafe.cms.RecipientInfo[])jceRecipientInfos, (String)this.macAlgorithm, (int)this.keyBitLength, (CertStore)certStore, (Attribute[])jceAuthAttrs, (Attribute[])jceUnauthAttrs, (SecureRandom)this.random);
            }
            return this.jceParams;
        }
    }
}

