/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.cms;

import com.rsa.certj.cms.CMSException;
import com.rsa.certj.cms.ContentType;
import com.rsa.certj.cms.Decoder;
import com.rsa.jsafe.crypto.FIPS140Context;
import java.io.IOException;
import java.io.OutputStream;

public final class Encoder {
    private final com.rsa.jsafe.cms.Encoder jceEncoder;
    private final FIPS140Context jceCtx;

    Encoder(com.rsa.jsafe.cms.Encoder jceEncoder, FIPS140Context jceCtx) {
        this.jceEncoder = jceEncoder;
        this.jceCtx = jceCtx;
    }

    public ContentType getType() {
        return ContentType.getContentType(this.jceEncoder.getType().getIdentifier());
    }

    public OutputStream getContentOutputStream(ContentType contentType) throws CMSException {
        try {
            return this.jceEncoder.getContentOutputStream(contentType.getJceContextType());
        }
        catch (IOException e) {
            throw new CMSException(e);
        }
    }

    public void copyContent(Decoder decoder) throws CMSException {
        try {
            this.jceEncoder.copyContent(decoder.getJceDecoder());
        }
        catch (IOException e) {
            throw new CMSException(e);
        }
    }

    FIPS140Context getFIPS140Context() {
        return this.jceCtx;
    }
}

