/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.cms;

import com.rsa.certj.cert.X501Attributes;
import com.rsa.certj.cert.X509CRL;
import com.rsa.certj.cert.X509Certificate;
import com.rsa.certj.cms.CMSException;
import com.rsa.certj.cms.CMSUtils;
import com.rsa.certj.cms.Decoder;
import com.rsa.certj.cms.KeyContainer;
import com.rsa.certj.cms.RecipientInfo;
import com.rsa.jsafe.crypto.FIPS140Context;
import com.rsa.jsafe.provider.JsafeJCE;

public final class EnvelopedDataDecoder
extends Decoder {
    EnvelopedDataDecoder(com.rsa.jsafe.cms.Decoder jceDecoder, FIPS140Context jceCtx) {
        super(jceDecoder, jceCtx);
    }

    public RecipientInfo[] getRecipientInfos() {
        com.rsa.jsafe.cms.EnvelopedDataDecoder jceEnvDecoder = (com.rsa.jsafe.cms.EnvelopedDataDecoder)this.jceDecoder;
        return CMSUtils.convertToJsafeRecipientInfo(jceEnvDecoder.getRecipientInfos());
    }

    public X509Certificate[] getOriginatorCertificates() {
        com.rsa.jsafe.cms.EnvelopedDataDecoder jceEnvDecoder = (com.rsa.jsafe.cms.EnvelopedDataDecoder)this.jceDecoder;
        return CMSUtils.convertToJsafeCertificates(jceEnvDecoder.getOriginatorCertificates());
    }

    public X509CRL[] getOriginatorCRLs() {
        com.rsa.jsafe.cms.EnvelopedDataDecoder jceEnvDecoder = (com.rsa.jsafe.cms.EnvelopedDataDecoder)this.jceDecoder;
        return CMSUtils.convertToJsafeCRLs(jceEnvDecoder.getOriginatorCRLs());
    }

    public X501Attributes getUnprotectedAttributes() throws CMSException {
        com.rsa.jsafe.cms.EnvelopedDataDecoder jceEnvDecoder = (com.rsa.jsafe.cms.EnvelopedDataDecoder)this.jceDecoder;
        try {
            return CMSUtils.convertToJsafeAttributes(jceEnvDecoder.getUnprotectedAttributes());
        }
        catch (com.rsa.jsafe.cms.CMSException e) {
            throw new CMSException(e);
        }
    }

    public void decryptContentEncryptionKey(RecipientInfo info, KeyContainer decryptionKey) throws CMSException {
        if (info == null) {
            throw new CMSException("RecipientInfo cannot be null.");
        }
        com.rsa.jsafe.cms.EnvelopedDataDecoder jceEnvDecoder = (com.rsa.jsafe.cms.EnvelopedDataDecoder)this.jceDecoder;
        JsafeJCE jceProv = CMSUtils.createJceProvider(this.jceCtx);
        try {
            jceEnvDecoder.decryptContentEncryptionKey(info.getJceRecipientInfo(jceProv), CMSUtils.convertToJceKeyContainer(decryptionKey, jceProv));
        }
        catch (com.rsa.jsafe.cms.CMSException e) {
            throw new CMSException(e);
        }
    }
}

