/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.cms;

import com.rsa.certj.cert.X501Attributes;
import com.rsa.certj.cert.X509Certificate;
import com.rsa.certj.cms.CMSException;
import com.rsa.certj.cms.KekRecipientInfo;
import com.rsa.certj.cms.KeyAgreeRecipientInfo;
import com.rsa.certj.cms.KeyTransRecipientInfo;
import com.rsa.certj.cms.PasswordRecipientInfo;
import com.rsa.certj.cms.SignerInfo;
import com.rsa.jsafe.JSAFE_PrivateKey;
import com.rsa.jsafe.JSAFE_PublicKey;
import com.rsa.jsafe.JSAFE_SecretKey;
import java.util.Date;

public final class InfoObjectFactory {
    public static final String ENCRYPTION_RSA = "RSA";
    public static final String KDF_PBKDF2WITHSHA1 = "PBKDF2/SHA1/PKCS5V2PBE";
    public static final String KDF_PBKDF2WITHSHA224 = "PBKDF2/SHA224/PKCS5V2PBE";
    public static final String KDF_PBKDF2WITHSHA256 = "PBKDF2/SHA256/PKCS5V2PBE";
    public static final String KDF_PBKDF2WITHSHA384 = "PBKDF2/SHA384/PKCS5V2PBE";
    public static final String KDF_PBKDF2WITHSHA512 = "PBKDF2/SHA512/PKCS5V2PBE";
    public static final String KEYAGREE_ECDH = "ECDH";
    public static final String KEYAGREE_DH = "DH";
    public static final String DIGEST_SHA1 = "SHA1";
    public static final String DIGEST_SHA224 = "SHA224";
    public static final String DIGEST_SHA256 = "SHA256";
    public static final String DIGEST_SHA384 = "SHA384";
    public static final String DIGEST_SHA512 = "SHA512";

    private InfoObjectFactory() {
    }

    public static KeyTransRecipientInfo newKeyTransRecipientInfo(X509Certificate certificate, String encryptionAlgorithm) throws CMSException {
        return new KeyTransRecipientInfo(certificate, encryptionAlgorithm);
    }

    public static PasswordRecipientInfo newPasswordRecipientInfo(char[] password) throws CMSException {
        return new PasswordRecipientInfo(password, null, 100000);
    }

    public static PasswordRecipientInfo newPasswordRecipientInfo(char[] password, String kdfAlgorithm, int iterationCount) throws CMSException {
        return new PasswordRecipientInfo(password, kdfAlgorithm, iterationCount);
    }

    public static KekRecipientInfo newKekRecipientInfo(byte[] kekId, JSAFE_SecretKey secretKey) throws CMSException {
        return InfoObjectFactory.newKekRecipientInfo(kekId, secretKey, null);
    }

    public static KekRecipientInfo newKekRecipientInfo(byte[] kekId, JSAFE_SecretKey secretKey, Date date) throws CMSException {
        return new KekRecipientInfo(kekId, secretKey, date, null, null);
    }

    public static KekRecipientInfo newKekRecipientInfo(byte[] kekId, JSAFE_SecretKey secretKey, Date date, String otherKeyAttrOID, byte[] encodedOtherKeyAttr) throws CMSException {
        return new KekRecipientInfo(kekId, secretKey, date, otherKeyAttrOID, encodedOtherKeyAttr);
    }

    public static KeyAgreeRecipientInfo newKeyAgreeRecipientInfo(X509Certificate origCertificate, JSAFE_PrivateKey origPrivateKey, X509Certificate recipientCertificate) throws CMSException {
        return new KeyAgreeRecipientInfo(origCertificate, null, origPrivateKey, recipientCertificate);
    }

    public static KeyAgreeRecipientInfo newKeyAgreeRecipientInfo(JSAFE_PublicKey origPublicKey, JSAFE_PrivateKey origPrivateKey, X509Certificate recipientCertificate) throws CMSException {
        return new KeyAgreeRecipientInfo(null, origPublicKey, origPrivateKey, recipientCertificate);
    }

    public static SignerInfo newSignerInfo(JSAFE_PrivateKey key, X509Certificate cert, String digestAlg) throws CMSException {
        return InfoObjectFactory.newSignerInfo(key, cert, digestAlg, null, null);
    }

    public static SignerInfo newSignerInfo(JSAFE_PrivateKey key, X509Certificate cert, String digestAlg, X501Attributes signedAttrs, X501Attributes unsignedAttrs) throws CMSException {
        return new SignerInfo(key, cert, digestAlg, signedAttrs, unsignedAttrs);
    }
}

