/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.cms;

import com.rsa.certj.cert.X500Name;
import com.rsa.certj.cms.CMSException;
import com.rsa.certj.cms.CMSUtils;
import com.rsa.certj.cms.RecipientInfo;
import com.rsa.jsafe.cms.InfoObjectFactory;
import com.rsa.jsafe.provider.JsafeJCE;
import java.security.cert.X509Certificate;

public final class KeyTransRecipientInfo
extends RecipientInfo {
    private final com.rsa.certj.cert.X509Certificate cert;
    private final String encAlg;
    private com.rsa.jsafe.cms.KeyTransRecipientInfo jceInfoObj;

    KeyTransRecipientInfo(com.rsa.jsafe.cms.KeyTransRecipientInfo jceInfoObj) {
        this.jceInfoObj = jceInfoObj;
        this.cert = null;
        this.encAlg = null;
    }

    KeyTransRecipientInfo(com.rsa.certj.cert.X509Certificate certificate, String encryptionAlgorithm) throws CMSException {
        this.jceInfoObj = null;
        try {
            this.cert = certificate == null ? null : (com.rsa.certj.cert.X509Certificate)certificate.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new CMSException(e);
        }
        this.encAlg = encryptionAlgorithm;
    }

    public X500Name getIssuer() throws CMSException {
        if (this.jceInfoObj != null) {
            return CMSUtils.convertToJsafeIssuerName(this.jceInfoObj.getIssuer());
        }
        return this.cert == null ? null : this.cert.getIssuerName();
    }

    public byte[] getSerialNumber() {
        if (this.jceInfoObj != null) {
            return this.jceInfoObj.getSerialNumber().toByteArray();
        }
        return this.cert == null ? null : this.cert.getSerialNumber();
    }

    public byte[] getSubjectKeyIdentifier() {
        if (this.jceInfoObj != null) {
            return this.jceInfoObj.getSubjectKeyIdentifier();
        }
        return this.cert == null ? null : this.cert.getSubjectUniqueID();
    }

    com.rsa.jsafe.cms.RecipientInfo getJceRecipientInfo(JsafeJCE jceProv) throws CMSException {
        if (this.jceInfoObj == null) {
            X509Certificate jceCert = CMSUtils.convertToJceCertificate(this.cert, jceProv);
            try {
                this.jceInfoObj = InfoObjectFactory.newKeyTransRecipientInfo((X509Certificate)jceCert, (String)this.encAlg);
            }
            catch (com.rsa.jsafe.cms.CMSException e) {
                throw new CMSException(e);
            }
        }
        return this.jceInfoObj;
    }
}

