/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.cms;

import com.rsa.certj.DatabaseService;
import com.rsa.certj.cert.X501Attributes;
import com.rsa.certj.cert.X509V3Extensions;
import com.rsa.certj.cert.extensions.GeneralName;
import com.rsa.certj.cms.Accuracy;
import com.rsa.certj.cms.CMSException;
import com.rsa.certj.cms.CMSParameters;
import com.rsa.certj.cms.RecipientInfo;
import com.rsa.certj.cms.SignerInfo;
import com.rsa.jsafe.JSAFE_SecretKey;
import com.rsa.jsafe.JSAFE_SecureRandom;
import java.util.Date;

public final class ParameterFactory {
    public static final String MAC_HMAC_SHA1 = "HMACSHA1";
    public static final String MAC_HMAC_SHA224 = "HMACSHA224";
    public static final String MAC_HMAC_SHA256 = "HMACSHA256";
    public static final String MAC_HMAC_SHA384 = "HMACSHA384";
    public static final String MAC_HMAC_SHA512 = "HMACSHA512";
    public static final String DIGEST_SHA1 = "SHA1";
    public static final String DIGEST_SHA224 = "SHA224";
    public static final String DIGEST_SHA256 = "SHA256";
    public static final String DIGEST_SHA384 = "SHA384";
    public static final String DIGEST_SHA512 = "SHA512";
    public static final String ENCRYPTION_ALG_AES_CBC_PKCS5PAD = "AES/CBC/PKCS5Pad";
    public static final String ENCRYPTION_ALG_DES_CBC_PKCS5PAD = "DES/CBC/PKCS5Pad";
    public static final String ENCRYPTION_ALG_DESEDE_CBC_PKCS5PAD = "DESede/CBC/PKCS5Pad";
    public static final String ENCRYPTION_ALG_RC2_CBC_PKCS5PAD = "RC2/CBC/PKCS5Pad";

    private ParameterFactory() {
    }

    public static CMSParameters newAuthenticatedDataParameters(RecipientInfo[] recipientInfos, String macAlgorithm) throws CMSException {
        return ParameterFactory.newAuthenticatedDataParameters(recipientInfos, macAlgorithm, 0, null, null, null, null);
    }

    public static CMSParameters newAuthenticatedDataParameters(RecipientInfo[] recipientInfos, String macAlgorithm, int keyBitLength, DatabaseService database, X501Attributes authAttrs, X501Attributes unAuthAttrs, JSAFE_SecureRandom random) throws CMSException {
        return new CMSParameters.AuthenticatedDataParameters(recipientInfos, macAlgorithm, keyBitLength, database, authAttrs, unAuthAttrs, random);
    }

    public static CMSParameters newDigestedDataParameters(String digestAlgorithm) {
        return new CMSParameters.DigestedDataParameters(digestAlgorithm);
    }

    public static CMSParameters newEncryptedDataParameters(String encryptAlgorithm, JSAFE_SecretKey secretKey) throws CMSException {
        return ParameterFactory.newEncryptedDataParameters(encryptAlgorithm, secretKey, null, null);
    }

    public static CMSParameters newEncryptedDataParameters(String encryptAlgorithm, JSAFE_SecretKey secretKey, X501Attributes unprotectedAttrs, JSAFE_SecureRandom random) throws CMSException {
        return new CMSParameters.EncryptedDataParameters(encryptAlgorithm, secretKey, unprotectedAttrs, random);
    }

    public static CMSParameters newEnvelopedDataParameters(RecipientInfo[] recipientInfos, String encryptAlgorithm) throws CMSException {
        return ParameterFactory.newEnvelopedDataParameters(recipientInfos, encryptAlgorithm, 0, null, null, null);
    }

    public static CMSParameters newEnvelopedDataParameters(RecipientInfo[] recipientInfos, String encryptAlgorithm, int keyBitLength, DatabaseService database, X501Attributes unprotectedAttrs, JSAFE_SecureRandom random) throws CMSException {
        return new CMSParameters.EnvelopedDataParameters(recipientInfos, encryptAlgorithm, keyBitLength, database, unprotectedAttrs, random);
    }

    public static CMSParameters newSignedDataParameters(SignerInfo[] signerInfos, DatabaseService database) throws CMSException {
        return ParameterFactory.newSignedDataParameters(signerInfos, database, null);
    }

    public static CMSParameters newSignedDataParameters(SignerInfo[] signerInfos, DatabaseService database, JSAFE_SecureRandom random) throws CMSException {
        return new CMSParameters.SignedDataParameters(signerInfos, database, random);
    }

    public static CMSParameters newTimeStampTokenParameters(String policyId, String digestAlgorithm, byte[] digest, byte[] serialNumber, Date generationTime) throws CMSException {
        return ParameterFactory.newTimeStampTokenParameters(policyId, digestAlgorithm, digest, serialNumber, generationTime, null, false, null, null, null);
    }

    public static CMSParameters newTimeStampTokenParameters(String policyId, String digestAlgorithm, byte[] digest, byte[] serialNumber, Date generationTime, Accuracy accuracy, boolean ordering, byte[] nonce, GeneralName authorityName, X509V3Extensions extensions) throws CMSException {
        return new CMSParameters.TimeStampTokenParameters(policyId, digestAlgorithm, digest, serialNumber, generationTime, accuracy, ordering, nonce, authorityName, extensions);
    }
}

