/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.cms;

import com.rsa.certj.cert.X509CRL;
import com.rsa.certj.cert.X509Certificate;
import com.rsa.certj.cms.CMSException;
import com.rsa.certj.cms.CMSUtils;
import com.rsa.certj.cms.Decoder;
import com.rsa.certj.cms.SignerInfo;
import com.rsa.certj.spi.path.CertPathCtx;
import com.rsa.jsafe.crypto.FIPS140Context;
import com.rsa.jsafe.provider.JsafeJCE;
import java.security.cert.CertStore;

public final class SignedDataDecoder
extends Decoder {
    SignedDataDecoder(com.rsa.jsafe.cms.Decoder jceDecoder, FIPS140Context jceCtx) {
        super(jceDecoder, jceCtx);
    }

    public X509Certificate[] getCertificates() {
        com.rsa.jsafe.cms.SignedDataDecoder jceSignDecoder = (com.rsa.jsafe.cms.SignedDataDecoder)this.jceDecoder;
        return CMSUtils.convertToJsafeCertificates(jceSignDecoder.getCertificates());
    }

    public X509CRL[] getCRLs() {
        com.rsa.jsafe.cms.SignedDataDecoder jceSignDecoder = (com.rsa.jsafe.cms.SignedDataDecoder)this.jceDecoder;
        return CMSUtils.convertToJsafeCRLs(jceSignDecoder.getCRLs());
    }

    public SignerInfo[] getSignerInfos() {
        com.rsa.jsafe.cms.SignedDataDecoder jceSignDecoder = (com.rsa.jsafe.cms.SignedDataDecoder)this.jceDecoder;
        return CMSUtils.convertToJsafeSignerInfo(jceSignDecoder.getSignerInfos());
    }

    public boolean verify(SignerInfo signerInfo, CertPathCtx pathCtx) throws CMSException {
        com.rsa.jsafe.cms.SignedDataDecoder jceSignDecoder = (com.rsa.jsafe.cms.SignedDataDecoder)this.jceDecoder;
        JsafeJCE jceProv = CMSUtils.createJceProvider(this.jceCtx);
        CertStore certStore = null;
        if (pathCtx != null) {
            certStore = CMSUtils.convertToJceCertStore(pathCtx.getDatabase(), jceProv);
        }
        com.rsa.jsafe.cms.SignerInfo jceSignerInfo = null;
        if (signerInfo != null) {
            jceSignerInfo = signerInfo.getJceSignerInfo(jceProv);
        }
        if (pathCtx == null || pathCtx.getTrustedCerts() == null || pathCtx.getTrustedCerts().length == 0) {
            try {
                return jceSignDecoder.verify(jceSignerInfo, certStore);
            }
            catch (com.rsa.jsafe.cms.CMSException e) {
                throw new CMSException(e);
            }
        }
        CertStore trustStore = CMSUtils.convertToJceCertStore(pathCtx.getTrustedCerts(), jceProv);
        boolean revocationEnabled = pathCtx.isFlagRaised(4);
        try {
            return jceSignDecoder.verify(jceSignerInfo, trustStore, certStore, revocationEnabled);
        }
        catch (com.rsa.jsafe.cms.CMSException e) {
            throw new CMSException(e);
        }
    }
}

