/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.cms;

import com.rsa.certj.cert.X500Name;
import com.rsa.certj.cert.X501Attributes;
import com.rsa.certj.cms.CMSException;
import com.rsa.certj.cms.CMSUtils;
import com.rsa.jsafe.JSAFE_PrivateKey;
import com.rsa.jsafe.cert.Attribute;
import com.rsa.jsafe.cms.InfoObjectFactory;
import com.rsa.jsafe.provider.JsafeJCE;
import java.math.BigInteger;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;

public final class SignerInfo {
    private final JSAFE_PrivateKey key;
    private final com.rsa.certj.cert.X509Certificate cert;
    private final String digestAlg;
    private final X501Attributes signedAttrs;
    private final X501Attributes unsignedAttrs;
    private com.rsa.jsafe.cms.SignerInfo jceSignerInfo;

    SignerInfo(com.rsa.jsafe.cms.SignerInfo jceSignerInfo) {
        this.jceSignerInfo = jceSignerInfo;
        this.key = null;
        this.cert = null;
        this.digestAlg = null;
        this.signedAttrs = null;
        this.unsignedAttrs = null;
    }

    SignerInfo(JSAFE_PrivateKey key, com.rsa.certj.cert.X509Certificate cert, String digestAlg, X501Attributes signedAttrs, X501Attributes unsignedAttrs) {
        this.jceSignerInfo = null;
        try {
            this.key = key == null ? null : (JSAFE_PrivateKey)key.clone();
            this.cert = cert == null ? null : (com.rsa.certj.cert.X509Certificate)cert.clone();
            this.digestAlg = digestAlg;
            this.signedAttrs = signedAttrs == null ? null : (X501Attributes)signedAttrs.clone();
            this.unsignedAttrs = unsignedAttrs == null ? null : (X501Attributes)unsignedAttrs.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public X501Attributes getSignedAttributes() throws CMSException {
        if (this.jceSignerInfo == null) {
            return new X501Attributes();
        }
        return CMSUtils.convertToJsafeAttributes(this.jceSignerInfo.getSignedAttributes());
    }

    public X501Attributes getUnsignedAttributes() throws CMSException {
        if (this.jceSignerInfo == null) {
            return new X501Attributes();
        }
        return CMSUtils.convertToJsafeAttributes(this.jceSignerInfo.getUnsignedAttributes());
    }

    public X500Name getIssuer() throws CMSException {
        if (this.jceSignerInfo == null) {
            return null;
        }
        return CMSUtils.convertToJsafeIssuerName(this.jceSignerInfo.getIssuer());
    }

    public byte[] getSerialNumber() {
        if (this.jceSignerInfo == null) {
            return null;
        }
        BigInteger serialNumber = this.jceSignerInfo.getSerialNumber();
        return serialNumber == null ? null : serialNumber.toByteArray();
    }

    public byte[] getSubjectKeyIdentifier() {
        if (this.jceSignerInfo == null) {
            return null;
        }
        return this.jceSignerInfo.getSubjectKeyIdentifier();
    }

    com.rsa.jsafe.cms.SignerInfo getJceSignerInfo(JsafeJCE jceProv) throws CMSException {
        if (this.jceSignerInfo == null) {
            X509Certificate jceCert = CMSUtils.convertToJceCertificate(this.cert, jceProv);
            PrivateKey jcePrivateKey = CMSUtils.convertToJcePrivateKey(this.key, jceProv);
            Attribute[] jceSignedAttrs = CMSUtils.convertToJceAttributes(this.signedAttrs);
            Attribute[] jceUnsignedAttrs = CMSUtils.convertToJceAttributes(this.unsignedAttrs);
            try {
                this.jceSignerInfo = InfoObjectFactory.newSignerInfo((PrivateKey)jcePrivateKey, (X509Certificate)jceCert, (String)this.digestAlg, (Attribute[])jceSignedAttrs, (Attribute[])jceUnsignedAttrs);
            }
            catch (com.rsa.jsafe.cms.CMSException e) {
                throw new CMSException(e);
            }
        }
        return this.jceSignerInfo;
    }
}

