/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.crmf;

import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN1Lengths;
import com.rsa.asn1.ASN1Template;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.EncodedContainer;
import com.rsa.asn1.OfContainer;
import com.rsa.certj.CertJ;
import com.rsa.certj.CertJInternalHelper;
import com.rsa.certj.crmf.CRMFException;
import com.rsa.certj.crmf.Control;
import com.rsa.certj.spi.path.CertPathCtx;
import com.rsa.jsafe.JSAFE_PrivateKey;
import com.rsa.jsafe.JSAFE_PublicKey;
import java.io.Serializable;
import java.util.Vector;

public class Controls
implements Cloneable,
Serializable {
    private Vector<Control> theControls = new Vector();
    protected int special;
    private ASN1Template asn1Template;
    private CertPathCtx theCertPathCtx;
    private CertJ theCertJ;
    private JSAFE_PublicKey pubKey;
    private JSAFE_PrivateKey privKey;

    public void decodeControls(byte[] controlsBER, int offset, int special) throws CRMFException {
        if (controlsBER == null) {
            throw new CRMFException("Controls encoding is null.");
        }
        try {
            OfContainer seqOf = new OfContainer(special, 12288, (ASN1Container)new EncodedContainer(12288));
            ASN1Container[] asn1Def = new ASN1Container[]{seqOf};
            ASN1.berDecode((byte[])controlsBER, (int)offset, (ASN1Container[])asn1Def);
            int controlCount = seqOf.getContainerCount();
            for (int index = 0; index < controlCount; ++index) {
                ASN1Container nextContainer = seqOf.containerAt(index);
                Control nextControl = Control.getInstance(nextContainer.data, nextContainer.dataOffset, 0, this.theCertJ, this.theCertPathCtx, this.pubKey, this.privKey);
                this.theControls.addElement(nextControl);
            }
        }
        catch (ASN_Exception asnException) {
            throw new CRMFException("Could not read the BER of the Controls.");
        }
    }

    public static int getNextBEROffset(byte[] controlsBER, int offset) throws CRMFException {
        if (controlsBER == null) {
            throw new CRMFException("Controls Encoding is null.");
        }
        try {
            return offset + 1 + ASN1Lengths.determineLengthLen((byte[])controlsBER, (int)(offset + 1)) + ASN1Lengths.determineLength((byte[])controlsBER, (int)(offset + 1));
        }
        catch (ASN_Exception asnException) {
            throw new CRMFException("Could not read the BER encoding.");
        }
    }

    public int getDERLen(int special) throws CRMFException {
        return this.encodeInit(special);
    }

    private int encodeInit(int special) throws CRMFException {
        this.special = special;
        try {
            OfContainer seqOf = new OfContainer(special, true, 0, 12288, (ASN1Container)new EncodedContainer(12288));
            int controlCount = this.theControls.size();
            if (controlCount == 0) {
                return 2;
            }
            for (int index = 0; index < controlCount; ++index) {
                Control nextControl = this.theControls.elementAt(index);
                int nextLen = nextControl.getDERLen(0);
                byte[] encoding = new byte[nextLen];
                nextLen = nextControl.getDEREncoding(encoding, 0, 0);
                EncodedContainer nextContainer = new EncodedContainer(12288, true, 0, encoding, 0, nextLen);
                seqOf.addContainer((ASN1Container)nextContainer);
            }
            ASN1Container[] asn1Def = new ASN1Container[]{seqOf};
            this.asn1Template = new ASN1Template(asn1Def);
            return this.asn1Template.derEncodeInit();
        }
        catch (ASN_Exception asnException) {
            throw new CRMFException("Cannot encode Controls. ", (Exception)((Object)asnException));
        }
    }

    public int getDEREncoding(byte[] encoding, int offset, int special) throws CRMFException {
        if (encoding == null || encoding.length < 2) {
            throw new CRMFException("Specified Controls array is null or too short.");
        }
        if ((this.asn1Template == null || special != this.special) && this.encodeInit(special) == 0) {
            throw new CRMFException("Cannot compute the DER of the Controls");
        }
        if (this.theControls.isEmpty()) {
            encoding[offset] = -96;
            encoding[offset + 1] = 0;
            return 2;
        }
        try {
            return this.asn1Template.derEncode(encoding, offset);
        }
        catch (ASN_Exception asnException) {
            throw new CRMFException("Cannot encode Controls. ", (Exception)((Object)asnException));
        }
    }

    public int addControl(Control control) throws CRMFException {
        if (control == null) {
            throw new CRMFException("Specified Control is null.");
        }
        this.theControls.addElement(control);
        return this.theControls.indexOf(control);
    }

    public int getControlCount() {
        return this.theControls.size();
    }

    public Control getControlByIndex(int index) throws CRMFException {
        if (index >= this.theControls.size()) {
            throw new CRMFException("Specified Controls index is invalid.");
        }
        try {
            return (Control)this.theControls.elementAt(index).clone();
        }
        catch (CloneNotSupportedException cloneExc) {
            throw new CRMFException("Cannot get specified Control. ", cloneExc);
        }
    }

    public Control getControlByType(int controlType) {
        if (this.theControls.isEmpty()) {
            return null;
        }
        try {
            int count = this.getControlCount();
            for (int index = 0; index < count; ++index) {
                Control nextControl = this.getControlByIndex(index);
                if (nextControl.getControlType() != controlType) continue;
                return nextControl;
            }
        }
        catch (CRMFException crmfExc) {
            return null;
        }
        return null;
    }

    public Control getControlByOID(byte[] oid) {
        if (this.theControls.isEmpty()) {
            return null;
        }
        try {
            int count = this.getControlCount();
            for (int index = 0; index < count; ++index) {
                Control nextControl = this.getControlByIndex(index);
                if (!nextControl.compareOID(oid)) continue;
                return nextControl;
            }
        }
        catch (CRMFException crmfExc) {
            return null;
        }
        return null;
    }

    public void setEnvironment(CertJ certJ, CertPathCtx pathCtx, JSAFE_PublicKey pubKey, JSAFE_PrivateKey privKey) {
        this.theCertJ = certJ;
        this.theCertPathCtx = pathCtx;
        if (pubKey != null) {
            this.pubKey = pubKey;
        }
        if (privKey != null) {
            this.privKey = privKey;
        }
    }

    public Object clone() throws CloneNotSupportedException {
        Controls otherSelf = new Controls();
        try {
            otherSelf.setEnvironment(this.theCertJ, this.theCertPathCtx, this.pubKey, this.privKey);
            int count = this.theControls.size();
            for (int index = 0; index < count; ++index) {
                Control nextControl = (Control)this.getControlByIndex(index).clone();
                otherSelf.addControl(nextControl);
            }
            if (this.asn1Template != null) {
                otherSelf.getDERLen(this.special);
            }
        }
        catch (CRMFException crmfExc) {
            throw new CloneNotSupportedException(crmfExc.getMessage());
        }
        return otherSelf;
    }

    public boolean equals(Object obj) {
        int otherVectorLen;
        if (obj == null || !(obj instanceof Controls)) {
            return false;
        }
        Controls other = (Controls)obj;
        int thisVectorLen = this.theControls.size();
        if (thisVectorLen != (otherVectorLen = other.theControls.size())) {
            return false;
        }
        for (int index = 0; index < thisVectorLen; ++index) {
            if (!(this.theControls.elementAt(index) != null ? !this.theControls.elementAt(index).equals(other.theControls.elementAt(index)) : other.theControls.elementAt(index) != null)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return 31 + CertJInternalHelper.hashCodeValue(this.theControls);
    }
}

