/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.crmf;

import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN1Lengths;
import com.rsa.asn1.ASN1Template;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.ChoiceContainer;
import com.rsa.asn1.EncodedContainer;
import com.rsa.asn1.EndContainer;
import com.rsa.certj.CertJ;
import com.rsa.certj.CertJInternalHelper;
import com.rsa.certj.crmf.CRMFException;
import com.rsa.certj.crmf.EncryptedValue;
import com.rsa.certj.pkcs7.EnvelopedData;
import com.rsa.certj.pkcs7.PKCS7Exception;
import com.rsa.certj.spi.path.CertPathCtx;
import com.rsa.jsafe.JSAFE_PrivateKey;
import com.rsa.jsafe.JSAFE_PublicKey;
import java.io.Serializable;

public class EncryptedKey
implements Cloneable,
Serializable {
    public static final int ENCRYPTED_VALUE = 0;
    public static final int ENVELOPED_DATA = 1;
    private CertPathCtx theCertPathCtx;
    private CertJ theCertJ;
    private JSAFE_PublicKey pubKey;
    private JSAFE_PrivateKey privKey;
    private int type = -1;
    private EncryptedValue encryptValue;
    private EnvelopedData envelopData;
    private int special;
    private ASN1Template asn1Template;

    public EncryptedKey(CertJ certJ, CertPathCtx pathCtx, JSAFE_PublicKey pubKey, JSAFE_PrivateKey privKey) throws CRMFException {
        if (certJ == null) {
            throw new CRMFException("Specified CertJ value is NULL.");
        }
        this.theCertJ = certJ;
        this.theCertPathCtx = pathCtx;
        if (pubKey != null) {
            this.pubKey = pubKey;
        }
        if (privKey != null) {
            this.privKey = privKey;
        }
    }

    public void decodeEncryptedKey(byte[] keyBER, int offset, int special) throws CRMFException {
        block8: {
            if (keyBER == null) {
                throw new CRMFException("Encoding EncryptedKey is null.");
            }
            this.special = special;
            try {
                ChoiceContainer keyContainer = new ChoiceContainer(special);
                EncodedContainer encryptedValue = new EncodedContainer(12288);
                EncodedContainer envelopedData = new EncodedContainer(0x803000);
                EndContainer endContainer = new EndContainer();
                ASN1Container[] asn1Def = new ASN1Container[]{keyContainer, encryptedValue, envelopedData, endContainer};
                ASN1.berDecode((byte[])keyBER, (int)offset, (ASN1Container[])asn1Def);
                if (encryptedValue.dataPresent) {
                    this.encryptValue = new EncryptedValue(this.theCertJ, this.pubKey, this.privKey);
                    this.encryptValue.decodeEncryptedValue(encryptedValue.data, encryptedValue.dataOffset, 0);
                    this.type = 0;
                    break block8;
                }
                if (!envelopedData.dataPresent) break block8;
                this.type = 1;
                this.envelopData = new EnvelopedData(this.theCertJ, this.theCertPathCtx);
                try {
                    boolean check = this.envelopData.readInit(envelopedData.data, envelopedData.dataOffset, envelopedData.dataLen, 0x803000);
                    if (!check) {
                        throw new CRMFException("Not enough data in EnvelopedData.");
                    }
                    check = this.envelopData.readFinal();
                    if (!check) {
                        throw new CRMFException("Invalid data in EnvelopedData.");
                    }
                }
                catch (PKCS7Exception pkcs7Exception) {
                    throw new CRMFException(pkcs7Exception);
                }
            }
            catch (ASN_Exception asnException) {
                throw new CRMFException("Cannot decode the BER of the EncryptedKey.", (Exception)((Object)asnException));
            }
        }
    }

    public void setType(int type) throws CRMFException {
        if (type != 0 && type != 1) {
            throw new CRMFException("Invalid EncryptedKey type.");
        }
        this.type = type;
    }

    public int getType() {
        return this.type;
    }

    public void setEncryptedValue(EncryptedValue value) throws CRMFException {
        if (this.type == 1) {
            throw new CRMFException("Wrong type: this EncryptedKey object is of ENVELOPED_DATA type");
        }
        if (value == null) {
            throw new CRMFException("specified EncryptedValue object is null.");
        }
        try {
            this.encryptValue = (EncryptedValue)value.clone();
        }
        catch (CloneNotSupportedException cloneExc) {
            throw new CRMFException("Invalid Encrypted Value.", cloneExc);
        }
    }

    public EncryptedValue getEncryptedValue() throws CRMFException {
        if (this.type == 1) {
            throw new CRMFException("Wrong type: this EncryptedKey object is of ENVELOPED_DATA type");
        }
        if (this.encryptValue == null) {
            return null;
        }
        try {
            return (EncryptedValue)this.encryptValue.clone();
        }
        catch (CloneNotSupportedException cloneExc) {
            throw new CRMFException("Invalid Encrypted Value.", cloneExc);
        }
    }

    public void setEnvelopedData(EnvelopedData data) throws CRMFException {
        if (this.type == 0) {
            throw new CRMFException("Wrong type: this EncryptedKey object is of ENCRYPTED_VALUE type");
        }
        if (data == null) {
            throw new CRMFException("Specified EnvelopedData object is NULL.");
        }
        try {
            this.envelopData = (EnvelopedData)data.clone();
        }
        catch (CloneNotSupportedException cloneExc) {
            throw new CRMFException("Invalid Enveloped Data.", cloneExc);
        }
    }

    public EnvelopedData getEnvelopedData() throws CRMFException {
        if (this.type == 0) {
            throw new CRMFException("Wrong type: this EncryptedKey object is of ENCRYPTED_VALUE type");
        }
        if (this.envelopData == null) {
            return null;
        }
        try {
            return (EnvelopedData)this.envelopData.clone();
        }
        catch (CloneNotSupportedException cloneExc) {
            throw new CRMFException("Invalid Enveloped Data.", cloneExc);
        }
    }

    public static int getNextBEROffset(byte[] valueBER, int offset) throws CRMFException {
        if (valueBER == null) {
            throw new CRMFException("EncryptedKey Encoding is null.");
        }
        try {
            return offset + 1 + ASN1Lengths.determineLengthLen((byte[])valueBER, (int)(offset + 1)) + ASN1Lengths.determineLength((byte[])valueBER, (int)(offset + 1));
        }
        catch (ASN_Exception asnException) {
            throw new CRMFException("Could not read the BER encoding.", (Exception)((Object)asnException));
        }
    }

    public int getDERLen(int special) throws CRMFException {
        this.special = special;
        return this.encodeInit();
    }

    public int getDEREncoding(byte[] encoding, int offset, int special) throws CRMFException {
        int returnValue;
        if (encoding == null) {
            throw new CRMFException("Specified array is null in EncryptedKey.");
        }
        this.special = special;
        try {
            if (this.asn1Template == null) {
                this.getDERLen(special);
            }
            returnValue = this.asn1Template.derEncode(encoding, offset);
            this.asn1Template = null;
        }
        catch (ASN_Exception asnException) {
            this.asn1Template = null;
            throw new CRMFException("Unable to encode EncryptedKey.", (Exception)((Object)asnException));
        }
        return returnValue;
    }

    private int encodeInit() throws CRMFException {
        try {
            byte[] encoding;
            int dataLen;
            boolean valuePresent = false;
            boolean dataPresent = false;
            if (this.encryptValue != null) {
                dataLen = this.encryptValue.getDERLen(0);
                encoding = new byte[dataLen];
                dataLen = this.encryptValue.getDEREncoding(encoding, 0, 0);
                valuePresent = true;
            } else if (this.envelopData != null) {
                dataLen = this.envelopData.getContentInfoDERLen(0x803000);
                encoding = new byte[dataLen];
                dataLen = this.envelopData.writeMessage(encoding, 0, 0x800000);
                dataPresent = true;
            } else {
                throw new CRMFException("EncryptedKey Data is not set.");
            }
            ChoiceContainer keyContainer = new ChoiceContainer(this.special, 0);
            EndContainer endContainer = new EndContainer();
            EncodedContainer envelopedData = new EncodedContainer(0x803000, dataPresent, 0, encoding, 0, dataLen);
            EncodedContainer encryptedValue = new EncodedContainer(12288, valuePresent, 0, encoding, 0, dataLen);
            ASN1Container[] asn1Def = new ASN1Container[]{keyContainer, encryptedValue, envelopedData, endContainer};
            this.asn1Template = new ASN1Template(asn1Def);
            return this.asn1Template.derEncodeInit();
        }
        catch (ASN_Exception asnException) {
            throw new CRMFException((Exception)((Object)asnException));
        }
        catch (PKCS7Exception pkcs7Exception) {
            throw new CRMFException(pkcs7Exception);
        }
    }

    public Object clone() throws CloneNotSupportedException {
        try {
            EncryptedKey otherSelf = new EncryptedKey(this.theCertJ, this.theCertPathCtx, this.pubKey, this.privKey);
            if (this.envelopData != null) {
                otherSelf.envelopData = (EnvelopedData)this.envelopData.clone();
            }
            if (this.encryptValue != null) {
                otherSelf.encryptValue = (EncryptedValue)this.encryptValue.clone();
            }
            otherSelf.type = this.type;
            otherSelf.special = this.special;
            if (this.asn1Template != null) {
                otherSelf.encodeInit();
            }
            return otherSelf;
        }
        catch (CRMFException crmfException) {
            throw new CloneNotSupportedException(crmfException.getMessage());
        }
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof EncryptedKey)) {
            return false;
        }
        EncryptedKey other = (EncryptedKey)obj;
        if (this.type != other.type) {
            return false;
        }
        if (this.envelopData != null ? !this.envelopData.equals(other.envelopData) : other.envelopData != null) {
            return false;
        }
        return !(this.encryptValue != null ? !this.encryptValue.equals(other.encryptValue) : other.encryptValue != null);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = prime * result + CertJInternalHelper.hashCodeValue(this.encryptValue);
        result = prime * result + CertJInternalHelper.hashCodeValue(this.envelopData);
        result = prime * result + this.type;
        return result;
    }
}

