/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.crmf;

import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN1Template;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.EncodedContainer;
import com.rsa.certj.CertJUtils;
import com.rsa.certj.crmf.CRMFException;
import com.rsa.certj.crmf.Control;
import java.util.Arrays;

public class NonStandardControl
extends Control {
    private byte[] valueDER;
    ASN1Template asn1TemplateValue;

    public NonStandardControl() {
        this.controlTypeFlag = 6;
        this.controlTypeString = "NonStandardControl";
    }

    public NonStandardControl(byte[] oid, int oidOffset, int oidLen, byte[] valueDER, int valueOffset, int valueLen) {
        this.controlTypeFlag = 6;
        if (oid != null && oidLen != 0) {
            this.theOID = new byte[oidLen];
            System.arraycopy(oid, oidOffset, this.theOID, 0, oidLen);
        }
        if (valueDER != null && valueLen != 0) {
            this.valueDER = new byte[valueLen];
            System.arraycopy(valueDER, valueOffset, this.valueDER, 0, valueLen);
        }
        this.controlTypeString = "NonStandardControl";
    }

    protected void decodeValue(byte[] valueBER, int offset) throws CRMFException {
        if (valueBER == null) {
            throw new CRMFException("Non Standard Control encoding is null.");
        }
        this.valueDER = new byte[valueBER.length - offset];
        System.arraycopy(valueBER, offset, this.valueDER, 0, valueBER.length - offset);
    }

    public void setOID(byte[] oid, int oidOffset, int oidLen) {
        if (oid != null && oidLen != 0) {
            this.theOID = new byte[oidLen];
            System.arraycopy(oid, oidOffset, this.theOID, 0, oidLen);
        }
    }

    public void setValue(byte[] valueDER, int valueOffset, int valueLen) {
        if (valueDER != null && valueLen != 0) {
            this.valueDER = new byte[valueLen];
            System.arraycopy(valueDER, valueOffset, this.valueDER, 0, valueLen);
        }
    }

    public byte[] getValue() {
        if (this.valueDER == null) {
            return null;
        }
        return (byte[])this.valueDER.clone();
    }

    protected int derEncodeValueInit() throws CRMFException {
        this.asn1TemplateValue = null;
        if (this.valueDER == null || this.theOID == null) {
            throw new CRMFException("Values are not set in Non Standard Control.");
        }
        try {
            EncodedContainer theValue = new EncodedContainer(65280, true, 0, this.valueDER, 0, this.valueDER.length);
            ASN1Container[] asn1Def = new ASN1Container[]{theValue};
            this.asn1TemplateValue = new ASN1Template(asn1Def);
            return this.asn1TemplateValue.derEncodeInit();
        }
        catch (ASN_Exception asnException) {
            throw new CRMFException("Cannot encode Non Standard Control. ", (Exception)((Object)asnException));
        }
    }

    protected int derEncodeValue(byte[] encoding, int offset) throws CRMFException {
        if (encoding == null) {
            return 0;
        }
        if (this.asn1TemplateValue == null && this.derEncodeValueInit() == 0) {
            throw new CRMFException("Cannot encode Non Standard Control. ");
        }
        try {
            int totalLen = this.asn1TemplateValue.derEncode(encoding, offset);
            this.asn1Template = null;
            return totalLen;
        }
        catch (ASN_Exception asnException) {
            throw new CRMFException("Cannot encode Non Standard Control. ", (Exception)((Object)asnException));
        }
    }

    public Object clone() throws CloneNotSupportedException {
        NonStandardControl otherSelf = new NonStandardControl();
        if (this.valueDER != null) {
            otherSelf.valueDER = (byte[])this.valueDER.clone();
        }
        if (this.theOID != null) {
            otherSelf.theOID = (byte[])this.theOID.clone();
        }
        super.copyValues(otherSelf);
        return otherSelf;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof NonStandardControl)) {
            return false;
        }
        NonStandardControl other = (NonStandardControl)obj;
        if (!CertJUtils.byteArraysEqual(this.valueDER, other.valueDER)) {
            return false;
        }
        return CertJUtils.byteArraysEqual(this.theOID, other.theOID);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = prime * result + Arrays.hashCode(this.valueDER);
        result = prime * result + Arrays.hashCode(this.theOID);
        return result;
    }
}

