/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.crmf;

import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN1Template;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.EncodedContainer;
import com.rsa.asn1.EndContainer;
import com.rsa.asn1.IntegerContainer;
import com.rsa.asn1.SequenceContainer;
import com.rsa.certj.CertJInternalHelper;
import com.rsa.certj.CertJUtils;
import com.rsa.certj.cert.NameException;
import com.rsa.certj.cert.extensions.GeneralName;
import com.rsa.certj.crmf.CRMFException;
import com.rsa.certj.crmf.Control;
import java.util.Arrays;

public class OldCertID
extends Control {
    private GeneralName issuerName;
    private byte[] serialNumber;
    ASN1Template asn1TemplateValue;
    private int special = 0;

    public OldCertID() {
        this.controlTypeFlag = 4;
        this.theOID = new byte[OID_LIST[4].length];
        System.arraycopy(OID_LIST[4], 0, this.theOID, 0, this.theOID.length);
        this.controlTypeString = "OldCertID";
    }

    public void decodeValue(byte[] valueBER, int offset) throws CRMFException {
        if (valueBER == null) {
            throw new CRMFException("OldCertID Encoding is null.");
        }
        try {
            SequenceContainer aSeq = new SequenceContainer(this.special);
            EndContainer anEnd = new EndContainer();
            EncodedContainer nameContainer = new EncodedContainer(65280);
            IntegerContainer numberContainer = new IntegerContainer(0);
            ASN1Container[] asn1Def = new ASN1Container[]{aSeq, nameContainer, numberContainer, anEnd};
            ASN1.berDecode((byte[])valueBER, (int)offset, (ASN1Container[])asn1Def);
            this.serialNumber = new byte[numberContainer.dataLen];
            System.arraycopy(numberContainer.data, numberContainer.dataOffset, this.serialNumber, 0, numberContainer.dataLen);
            this.issuerName = new GeneralName(nameContainer.data, nameContainer.dataOffset, 0);
        }
        catch (Exception anyExc) {
            throw new CRMFException("Cannot decode OldCertID control.", anyExc);
        }
    }

    public void setCertIssuerName(GeneralName name) throws CRMFException {
        if (name == null) {
            throw new CRMFException("Issuer Name in OldCertID control cannot be null.");
        }
        try {
            this.issuerName = (GeneralName)name.clone();
        }
        catch (CloneNotSupportedException cloneExc) {
            throw new CRMFException("Invalid Issuer Name.", cloneExc);
        }
    }

    public void setSerialNumber(byte[] serialNumber, int offset, int len) throws CRMFException {
        if (serialNumber == null || len <= 0 || offset < 0) {
            throw new CRMFException("Passed in SerialNumber value is null in OldCertID control.");
        }
        this.serialNumber = new byte[len];
        System.arraycopy(serialNumber, offset, this.serialNumber, 0, len);
    }

    public byte[] getSerialNumber() {
        if (this.serialNumber == null) {
            return null;
        }
        return (byte[])this.serialNumber.clone();
    }

    public GeneralName getCertIssuerName() {
        if (this.issuerName == null) {
            return null;
        }
        try {
            return (GeneralName)this.issuerName.clone();
        }
        catch (CloneNotSupportedException cloneException) {
            return null;
        }
    }

    protected int derEncodeValue(byte[] encoding, int offset) throws CRMFException {
        if (encoding == null) {
            throw new CRMFException("Passed in array is null in OldCertID control.");
        }
        if (this.asn1TemplateValue == null && this.derEncodeValueInit() == 0) {
            throw new CRMFException("Cannot encode OldCertID control.");
        }
        try {
            int totalLen = this.asn1TemplateValue.derEncode(encoding, offset);
            this.asn1Template = null;
            return totalLen;
        }
        catch (ASN_Exception asnException) {
            throw new CRMFException("Cannot encode OldCertID control.", (Exception)((Object)asnException));
        }
    }

    protected int derEncodeValueInit() throws CRMFException {
        byte[] nameEncoding;
        int nameLen;
        this.asn1TemplateValue = null;
        SequenceContainer aSeq = new SequenceContainer(this.special, true, 0);
        EndContainer anEnd = new EndContainer();
        if (this.issuerName == null) {
            throw new CRMFException("Issuer Name is not set in OldCertID control.");
        }
        try {
            nameLen = this.issuerName.getDERLen(0);
            nameEncoding = new byte[nameLen];
            nameLen = this.issuerName.getDEREncoding(nameEncoding, 0, 0);
        }
        catch (NameException nameExc) {
            throw new CRMFException("Cannot encode IssuerName. ", nameExc);
        }
        try {
            EncodedContainer issuer = new EncodedContainer(12288, true, 0, nameEncoding, 0, nameLen);
            if (this.serialNumber == null) {
                throw new CRMFException("Serial Number is not set in OldCertID control.");
            }
            IntegerContainer serial = null;
            serial = (this.serialNumber[0] & 0x80) >> 7 == 0 ? new IntegerContainer(0, true, 0, this.serialNumber, 0, this.serialNumber.length, true) : new IntegerContainer(0, true, 0, this.serialNumber, 0, this.serialNumber.length, false);
            ASN1Container[] asn1Def = new ASN1Container[]{aSeq, issuer, serial, anEnd};
            this.asn1TemplateValue = new ASN1Template(asn1Def);
            return this.asn1TemplateValue.derEncodeInit();
        }
        catch (ASN_Exception asnException) {
            throw new CRMFException((Exception)((Object)asnException));
        }
    }

    public Object clone() throws CloneNotSupportedException {
        OldCertID otherSelf = new OldCertID();
        if (this.issuerName != null) {
            otherSelf.issuerName = (GeneralName)this.issuerName.clone();
        }
        if (this.serialNumber != null) {
            otherSelf.serialNumber = (byte[])this.serialNumber.clone();
        }
        otherSelf.special = this.special;
        super.copyValues(otherSelf);
        return otherSelf;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof OldCertID)) {
            return false;
        }
        OldCertID other = (OldCertID)obj;
        if (this.issuerName != null ? !this.issuerName.equals(other.issuerName) : other.issuerName != null) {
            return false;
        }
        return CertJUtils.byteArraysEqual(this.serialNumber, other.serialNumber);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = prime * result + CertJInternalHelper.hashCodeValue(this.issuerName);
        result = prime * result + Arrays.hashCode(this.serialNumber);
        return result;
    }
}

